<?php
/*
  $Id: checkout_confirmation.php,v 1.3 2006/03/23 02:12:25 ryu Exp $

  osCommerce, Open Source E-Commerce Solutions
  http://www.oscommerce.com

  Copyright (c) 2003 osCommerce

  Released under the GNU General Public License
  
  modified for Koshoten.net2
  http://www.koshoten.net/
*/

  require('includes/application_top.php');

  if (defined("KN_CFG_ALLOW_CHECKOUT") && (KN_CFG_ALLOW_CHECKOUT == "false")) {
    tep_redirect(tep_href_link(FILENAME_DEFAULT));
  }

// if the customer is not logged on, redirect them to the login page
  if (!tep_session_is_registered('customer_id')) {
    $navigation->set_snapshot(array('mode' => 'SSL', 'page' => FILENAME_CHECKOUT_PAYMENT));
    tep_redirect(tep_href_link(FILENAME_LOGIN, '', 'SSL'));
  }

// if there is nothing in the customers cart, redirect them to the shopping cart page
  if ($cart->count_contents() < 1) {
    tep_redirect(tep_href_link(FILENAME_SHOPPING_CART));
  }

// avoid hack attempts during the checkout procedure by checking the internal cartID
  if (isset($cart->cartID) && tep_session_is_registered('cartID')) {
    if ($cart->cartID != $cartID) {
      tep_redirect(tep_href_link(FILENAME_CHECKOUT_SHIPPING, '', 'SSL'));
    }
  }

// if no shipping method has been selected, redirect the customer to the shipping method selection page
  if (!tep_session_is_registered('shipping')) {
    tep_redirect(tep_href_link(FILENAME_CHECKOUT_SHIPPING, '', 'SSL'));
  }

  if (!tep_session_is_registered('payment')) tep_session_register('payment');
  if (isset($HTTP_POST_VARS['payment'])) $payment = $HTTP_POST_VARS['payment'];

  if (!tep_session_is_registered('comments')) tep_session_register('comments');
  if ($HTTP_POST_VARS['comments_added'] != '') {
    $comments = tep_db_prepare_input($HTTP_POST_VARS['comments']);
  }

// load the selected payment module
  if (KN_CFG_USE_KN_MODULES == 'true') {
    require(DIR_WS_CLASSES . 'kn_payment.php');
  } else {
    require(DIR_WS_CLASSES . 'payment.php');
  }
  $payment_modules = new payment($payment);

  require(DIR_WS_CLASSES . 'order.php');
  $order = new order;

  $payment_modules->update_status();

  if ( ( is_array($payment_modules->modules) && (sizeof($payment_modules->modules) > 1) && !is_object($$payment) ) || (is_object($$payment) && ($$payment->enabled == false)) ) {
    tep_redirect(tep_href_link(FILENAME_CHECKOUT_PAYMENT, 'error_message=' . urlencode(ERROR_NO_PAYMENT_MODULE_SELECTED), 'SSL'));
  }

  if (is_array($payment_modules->modules)) {
    $payment_modules->pre_confirmation_check();
  }

// load the selected shipping module
  require(DIR_WS_CLASSES . 'shipping.php');
  $shipping_modules = new shipping($shipping);

  require(DIR_WS_CLASSES . 'order_total.php');
  $order_total_modules = new order_total;

// Stock Check
  $any_out_of_stock = false;
  if (STOCK_CHECK == 'true') {
    for ($i=0, $n=sizeof($order->products); $i<$n; $i++) {
      if (tep_check_stock($order->products[$i]['id'], $order->products[$i]['qty'])) {
        $any_out_of_stock = true;
      }
    }
    // Out of Stock
    if ( (STOCK_ALLOW_CHECKOUT != 'true') && ($any_out_of_stock == true) ) {
      tep_redirect(tep_href_link(FILENAME_SHOPPING_CART));
    }
  }

  require(DIR_WS_LANGUAGES . $language . '/' . FILENAME_CHECKOUT_CONFIRMATION);

  $breadcrumb->add(NAVBAR_TITLE_1, tep_href_link(FILENAME_CHECKOUT_SHIPPING, '', 'SSL'));
  $breadcrumb->add(NAVBAR_TITLE_2);
?>
<!doctype html public "-//W3C//DTD HTML 4.01 Transitional//EN">
<html <?php echo HTML_PARAMS; ?>>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=<?php echo CHARSET; ?>">
<title><?php echo TITLE; ?></title>
<base href="<?php echo (($request_type == 'SSL') ? HTTPS_SERVER : HTTP_SERVER) . DIR_WS_CATALOG; ?>">
<link rel="stylesheet" type="text/css" href="general.css">
<link rel="stylesheet" type="text/css" href="<?php echo substr(FILENAME_CHECKOUT_CONFIRMATION, 0, strrpos(FILENAME_CHECKOUT_CONFIRMATION, '.'));?>.css">
</head>
<body>
<div id="bodyWrapper">
<!-- header //-->
<?php require(DIR_WS_INCLUDES . 'header.php'); ?>
<!-- header_eof //-->
<!-- body //-->
<table id="contents">
  <tr>
<!-- left_navigation //-->
<?php require(DIR_WS_INCLUDES . 'column_left.php'); ?>
<!-- left_navigation_eof //-->
<!-- body_text //-->
    <td id="mainContents">
      <h1 class="pageHeading"><?php echo HEADING_TITLE; ?></h1>
<?php
  $shop_info_query = tep_db_query("select shop_info_title, shop_info_value, allow_tags from " . TABLE_SHOP_INFO . " where shop_info_key = 'SHOP_INFO_CHECKOUT_CONFIRMATION'");
  $shop_info = tep_db_fetch_array($shop_info_query);
  if (isset($shop_info['shop_info_value']) && tep_not_null($shop_info['shop_info_value'])) {
    echo '      <div id="siCheckoutConfirmation">';
    if ($shop_info['allow_tags']) {
      echo $shop_info['shop_info_value'];
    } else {
      echo nl2br(htmlspecialchars($shop_info['shop_info_value']));
    }
    echo '      </div>';
  }
?>
      <h3><?php echo HEADING_PRODUCTS_INFORMATION; ?></h3>
      <table class="checkoutOrders">
<?php
  if (sizeof($order->info['tax_groups']) > 1) {
?>
      <thead>
        <tr>
          <th class="checkoutOrdersProductsCol" colspan="3"><?php echo '<span class="tableHeading">' . HEADING_PRODUCTS . '</span> <a href="' . tep_href_link(FILENAME_SHOPPING_CART) . '"><span class="orderEdit">(' . TEXT_EDIT . ')</span></a>'; ?></th>
          <th class="checkoutOrdersTaxCol"><span class="tableHeading"><?php echo HEADING_TAX; ?></span></th>
          <th class="checkoutOrdersPriceCol"><span class="tableHeading"><?php echo HEADING_TOTAL; ?></span></th>
        </tr>
      </thead>
      <tbody>
<?php
  } else {
?>
      <thead>
        <tr>
          <th class="checkoutOrdersProductsCol" colspan="4"><?php echo '<span class="tableHeading">' . HEADING_PRODUCTS . '</span> <a href="' . tep_href_link(FILENAME_SHOPPING_CART) . '"><span class="orderEdit">(' . TEXT_EDIT . ')</span></a>'; ?></th>
        </tr>
      </thead>
      <tbody>
<?php
  }

  for ($i=0, $n=sizeof($order->products); $i<$n; $i++) {
    echo '        <tr>' . "\n" .
         '          <td class="checkoutOrdersQuantityCol">' . $order->products[$i]['qty'] . '&nbsp;x</td>' . "\n" .
         '          <td class="checkoutOrdersProductsCol">' . $order->products[$i]['name'];

    if (STOCK_CHECK == 'true') {
      echo tep_check_stock($order->products[$i]['id'], $order->products[$i]['qty']);
    }

    if ( (isset($order->products[$i]['attributes'])) && (sizeof($order->products[$i]['attributes']) > 0) ) {
      for ($j=0, $n2=sizeof($order->products[$i]['attributes']); $j<$n2; $j++) {
        echo '<br><span class="productOptions"> - ' . $order->products[$i]['attributes'][$j]['option'] . ': ' . $order->products[$i]['attributes'][$j]['value'] . '</span>';
      }
    }

    echo '</td>' . "\n";
    echo '          <td class="checkoutOrdersDescriptionCol">';
    if ((KN_CFG_USE_SUBTITLE == 'true') && !empty($order->products[$i]['subtitle'])) {
      echo $order->products[$i]['subtitle'] . '&nbsp;';
    }
    if ((KN_CFG_USE_SERIES_TITLE == 'true') && !empty($order->products[$i]['series_title'])) {
      echo $order->products[$i]['series_title'] . '&nbsp;';
    }
    if ((KN_CFG_USE_AUTHOR == 'true') && !empty($order->products[$i]['author'])) {
      echo $order->products[$i]['author'] . '&nbsp;';
    }
    if ((KN_CFG_USE_PUBLISHERS == 'true') && !empty($order->products[$i]['publishers'])) {
      echo $order->products[$i]['publishers'] . '&nbsp;';
    }
    if ((KN_CFG_USE_VOLUME == 'true') && !empty($order->products[$i]['volume'])) {
      echo $order->products[$i]['volume'] . '&nbsp;';
    }
    if ((KN_CFG_USE_PUBLISHED == 'true') && !empty($order->products[$i]['published'])) {
      echo $order->products[$i]['published'] . '&nbsp;';
    }
    echo $order->products[$i]['description'] . '</td>' . "\n";

    if (sizeof($order->info['tax_groups']) > 1) echo '          <td class="checkoutOrdersTaxCol">' . tep_display_tax_value($order->products[$i]['tax']) . '%</td>' . "\n";

    echo '          <td class="checkoutOrdersPriceCol">' . $currencies->display_price($order->products[$i]['final_price'], $order->products[$i]['tax'], $order->products[$i]['qty']) . '</td>' . "\n" .
         '        </tr>' . "\n";
  }
?>
<?php
  if (MODULE_ORDER_TOTAL_INSTALLED) {
    if (sizeof($order->info['tax_groups']) > 1) {
      echo '        <tr>';
      echo '          <td colspan="5"><table class="checkoutOrdersTotal">';
    } else {
      echo '        <tr>';
      echo '          <td colspan="4"><table class="checkoutOrdersTotal">';
    }
    $order_total_modules->process();
    echo $order_total_modules->output() . "</table>\n";
    echo "</td>\n";
    echo '        </tr>' . "\n";
  }
?>
      </tbody>
      </table>
      <h3><?php echo HEADING_CUSTOMER_INFORMATION; ?></h3>
      <table class="checkoutCustomerInfo">
        <tr>
          <td class="checkoutCustomerInfoShipping"><table>
<?php
  if ($sendto != false) {
?>
            <tr><td><?php echo '<span class="tableHeading">' . HEADING_DELIVERY_ADDRESS . '</span> <a href="' . tep_href_link(FILENAME_CHECKOUT_SHIPPING_ADDRESS, '', 'SSL') . '"><span class="orderEdit">(' . TEXT_EDIT . ')</span></a>'; ?></td></tr>
            <tr><td><?php echo tep_address_format($order->delivery['format_id'], $order->delivery, 1, ' ', '<br>'); ?></td></tr>
<?php
  }
  if ($order->info['shipping_method']) {
?>
            <tr><td><?php echo '<span class="tableHeading">' . HEADING_SHIPPING_METHOD . '</span> <a href="' . tep_href_link(FILENAME_CHECKOUT_SHIPPING, '', 'SSL') . '"><span class="orderEdit">(' . TEXT_EDIT . ')</span></a>'; ?></td></tr>
            <tr><td><?php echo $order->info['shipping_method']; ?></td></tr>
<?php
    }
?>
          </table></td>
          <td class="checkoutCustomerInfoPayment"><table>
            <tr><td><?php echo '<span class="tableHeading">' . HEADING_BILLING_ADDRESS . '</span> <a href="' . tep_href_link(FILENAME_CHECKOUT_PAYMENT_ADDRESS, '', 'SSL') . '"><span class="orderEdit">(' . TEXT_EDIT . ')</span></a>'; ?></td></tr>
            <tr><td><?php echo tep_address_format($order->billing['format_id'], $order->billing, 1, ' ', '<br>'); ?></td></tr>
<?php
  if ($order->info['payment_method']) {
?>
            <tr><td><?php echo '<span class="tableHeading">' . HEADING_PAYMENT_METHOD . '</span> <a href="' . tep_href_link(FILENAME_CHECKOUT_PAYMENT, '', 'SSL') . '"><span class="orderEdit">(' . TEXT_EDIT . ')</span></a>'; ?></td></tr>
            <tr><td><?php echo $order->info['payment_method']; ?></td></tr>
<?php
  }
?>
          </table></td>
        </tr>
      </table>
<?php
  if (is_array($payment_modules->modules)) {
    if ($confirmation = $payment_modules->confirmation()) {
?>
      <h3><?php echo HEADING_PAYMENT_INFORMATION; ?></h3>
      <div class="checkoutPaymentInformation">
        <div class="checkoutPaymentInformationTitle"><?php echo $confirmation['title']; ?></div>
<?php
      for ($i=0, $n=sizeof($confirmation['fields']); $i<$n; $i++) {
?>
        <div class="checkoutPaymentInformationFields"><?php echo $confirmation['fields'][$i]['title']; ?><?php echo $confirmation['fields'][$i]['field']; ?></div>
<?php
      }
?>
      </div>
<?php
    }
  }

  if (tep_not_null($order->info['comments'])) {
?>
      <h3 class="checkoutCommentsHeader"><?php echo '<span class="tableHeading">' . HEADING_ORDER_COMMENTS . '</span> <a href="' . tep_href_link(FILENAME_CHECKOUT_PAYMENT, '', 'SSL') . '"><span class="orderEdit">(' . TEXT_EDIT . ')</span></a>'; ?></h3>
      <div class="checkoutComments"><?php echo nl2br(htmlspecialchars($order->info['comments'])); ?></div>
<?php
  }
?>
      <table>
        <tr class="buttonLine">
          <td class="buttonRight">
<?php
  if (isset($$payment->form_action_url)) {
    $form_action_url = $$payment->form_action_url;
  } else {
    $form_action_url = tep_href_link(FILENAME_CHECKOUT_PROCESS, '', 'SSL');
  }

  echo tep_draw_form('checkout_confirmation', $form_action_url, 'post');

  if (is_array($payment_modules->modules)) {
    echo $payment_modules->process_button();
  }

  echo tep_draw_hidden_field('comments', $order->info['comments']) . tep_image_submit('button_confirm_order.gif', IMAGE_BUTTON_CONFIRM_ORDER) . '</form>' . "\n";
?>
          </td>
        </tr>
      </table>
      <table class="checkoutBar">
        <tr class="checkoutBarImage">
          <td class="checkoutBarFrom"><?php echo tep_draw_separator('pixel_trans.gif', '100%', '1'); ?></td>
          <td class="checkoutBarFrom"><?php echo tep_draw_separator('pixel_trans.gif', '100%', '1'); ?></td>
          <td class="checkoutBarCurrent"><?php echo tep_image(DIR_WS_IMAGES . 'checkout_bullet.gif'); ?></td>
          <td class="checkoutBarTo"><?php echo tep_draw_separator('pixel_trans.gif', '100%', '1'); ?></td>
        </tr>
        <tr class="checkoutBarText">
          <td class="checkoutBarFrom"><?php echo '<a href="' . tep_href_link(FILENAME_CHECKOUT_SHIPPING, '', 'SSL') . '"><span class="checkoutBarDelivery">' . CHECKOUT_BAR_DELIVERY . '</span></a>'; ?></td>
          <td class="checkoutBarFrom"><?php echo '<a href="' . tep_href_link(FILENAME_CHECKOUT_PAYMENT, '', 'SSL') . '"><span class="checkoutBarPayment">' . CHECKOUT_BAR_PAYMENT . '</span></a>'; ?></td>
          <td class="checkoutBarCurrent"><span class="checkoutBarConfirmation"><?php echo CHECKOUT_BAR_CONFIRMATION; ?></span></td>
          <td class="checkoutBarTo"><span class="checkoutBarFinished"><?php echo CHECKOUT_BAR_FINISHED; ?></span></td>
        </tr>
      </table>
<?php
  $shop_info_query = tep_db_query("select shop_info_title, shop_info_value, allow_tags from " . TABLE_SHOP_INFO . " where shop_info_key = 'SHOP_INFO_SHIPPING'");
  $shop_info = tep_db_fetch_array($shop_info_query);
  if (isset($shop_info['shop_info_value']) && tep_not_null($shop_info['shop_info_value'])) {
    echo '      <div class="checkoutOrderNotesHeader">' . HEADING_ORDER_NOTES . '</div>' . "\n";
    echo '      <div id="siShipping">';
    if ($shop_info['allow_tags']) {
      echo $shop_info['shop_info_value'];
    } else {
      echo nl2br(htmlspecialchars($shop_info['shop_info_value']));
    }
    echo '      </div>' . "\n";
  }
 ?>
    </form></td>
<!-- body_text_eof //-->
<!-- right_navigation //-->
<?php require(DIR_WS_INCLUDES . 'column_right.php'); ?>
<!-- right_navigation_eof //-->
  </tr>
</table>
<!-- body_eof //-->
<!-- footer //-->
<?php require(DIR_WS_INCLUDES . 'footer.php'); ?>
<!-- footer_eof //-->
</div>
</body>
</html>
<?php require(DIR_WS_INCLUDES . 'application_bottom.php'); ?>
