<?php
/*
  $Id: checkout_payment.php,v 1.3 2006/03/23 02:12:25 ryu Exp $

  osCommerce, Open Source E-Commerce Solutions
  http://www.oscommerce.com

  Copyright (c) 2003 osCommerce

  Released under the GNU General Public License
  
  modified for Koshoten.net2
  http://www.koshoten.net/
*/

  require('includes/application_top.php');

  if (defined("KN_CFG_ALLOW_CHECKOUT") && (KN_CFG_ALLOW_CHECKOUT == "false")) {
    tep_redirect(tep_href_link(FILENAME_DEFAULT));
  }

// if the customer is not logged on, redirect them to the login page
  if (!tep_session_is_registered('customer_id')) {
    $navigation->set_snapshot();
    tep_redirect(tep_href_link(FILENAME_LOGIN, '', 'SSL'));
  }

// if there is nothing in the customers cart, redirect them to the shopping cart page
  if ($cart->count_contents() < 1) {
    tep_redirect(tep_href_link(FILENAME_SHOPPING_CART));
  }

// if no shipping method has been selected, redirect the customer to the shipping method selection page
  if (!tep_session_is_registered('shipping')) {
    tep_redirect(tep_href_link(FILENAME_CHECKOUT_SHIPPING, '', 'SSL'));
  }

// avoid hack attempts during the checkout procedure by checking the internal cartID
  if (isset($cart->cartID) && tep_session_is_registered('cartID')) {
    if ($cart->cartID != $cartID) {
      tep_redirect(tep_href_link(FILENAME_CHECKOUT_SHIPPING, '', 'SSL'));
    }
  }

// Stock Check
  if ( (STOCK_CHECK == 'true') && (STOCK_ALLOW_CHECKOUT != 'true') ) {
    $products = $cart->get_products();
    for ($i=0, $n=sizeof($products); $i<$n; $i++) {
      if (tep_check_stock($products[$i]['id'], $products[$i]['quantity'])) {
        tep_redirect(tep_href_link(FILENAME_SHOPPING_CART));
        break;
      }
    }
  }

// if no billing destination address was selected, use the customers own address as default
  if (!tep_session_is_registered('billto')) {
    tep_session_register('billto');
    $billto = $customer_default_address_id;
  } else {
// verify the selected billing address
    $check_address_query = tep_db_query("select count(*) as total from " . TABLE_ADDRESS_BOOK . " where customers_id = '" . (int)$customer_id . "' and address_book_id = '" . (int)$billto . "'");
    $check_address = tep_db_fetch_array($check_address_query);

    if ($check_address['total'] != '1') {
      $billto = $customer_default_address_id;
      if (tep_session_is_registered('payment')) tep_session_unregister('payment');
    }
  }

  require(DIR_WS_CLASSES . 'order.php');
  $order = new order;

  if (!tep_session_is_registered('comments')) tep_session_register('comments');

  $total_weight = $cart->show_weight();
  $total_count = $cart->count_contents();

// load all enabled payment modules
// koshoten.netѤλʧ⥸塼Ȥɤ
  if (KN_CFG_USE_KN_MODULES == 'true') {
    require(DIR_WS_CLASSES . 'kn_payment.php');
  } else {
    require(DIR_WS_CLASSES . 'payment.php');
  }
  $payment_modules = new payment;

  require(DIR_WS_LANGUAGES . $language . '/' . FILENAME_CHECKOUT_PAYMENT);

  $breadcrumb->add(NAVBAR_TITLE_1, tep_href_link(FILENAME_CHECKOUT_SHIPPING, '', 'SSL'));
  $breadcrumb->add(NAVBAR_TITLE_2, tep_href_link(FILENAME_CHECKOUT_PAYMENT, '', 'SSL'));
?>
<!doctype html public "-//W3C//DTD HTML 4.01 Transitional//EN">
<html <?php echo HTML_PARAMS; ?>>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=<?php echo CHARSET; ?>">
<title><?php echo TITLE; ?></title>
<base href="<?php echo (($request_type == 'SSL') ? HTTPS_SERVER : HTTP_SERVER) . DIR_WS_CATALOG; ?>">
<link rel="stylesheet" type="text/css" href="general.css">
<link rel="stylesheet" type="text/css" href="<?php echo substr(FILENAME_CHECKOUT_PAYMENT, 0, strrpos(FILENAME_CHECKOUT_PAYMENT, '.'));?>.css">
<script language="javascript"><!--
var selected;

function selectRowEffect(object, buttonSelect) {
  if (!selected) {
    if (document.getElementById) {
      selected = document.getElementById('defaultSelected');
    } else {
      selected = document.all['defaultSelected'];
    }
  }

  if (selected) selected.className = 'checkoutModuleRow';
  object.className = 'checkoutModuleRowSelected';
  selected = object;

// one button is not an array
  if (document.checkout_payment.payment[0]) {
    document.checkout_payment.payment[buttonSelect].checked=true;
  } else {
    document.checkout_payment.payment.checked=true;
  }
}

function rowOverEffect(object) {
  if (object.className == 'checkoutModuleRow') object.className = 'checkoutModuleRowOver';
}

function rowOutEffect(object) {
  if (object.className == 'checkoutModuleRowOver') object.className = 'checkoutModuleRow';
}
//--></script>
<?php echo $payment_modules->javascript_validation(); ?>
</head>
<body>
<div id="bodyWrapper">
<!-- header //-->
<?php require(DIR_WS_INCLUDES . 'header.php'); ?>
<!-- header_eof //-->
<!-- body //-->
<table id="contents">
  <tr>
<!-- left_navigation //-->
<?php require(DIR_WS_INCLUDES . 'column_left.php'); ?>
<!-- left_navigation_eof //-->
<!-- body_text //-->
    <td id="mainContents"><?php echo tep_draw_form('checkout_payment', tep_href_link(FILENAME_CHECKOUT_CONFIRMATION, '', 'SSL'), 'post', 'onsubmit="return check_form();"'); ?>
      <h1 class="pageHeading"><?php echo HEADING_TITLE; ?></h1>
<?php
  if (isset($HTTP_GET_VARS['payment_error']) && is_object(${$HTTP_GET_VARS['payment_error']}) && ($error = ${$HTTP_GET_VARS['payment_error']}->get_error())) {
?>
      <div class="checkoutErrorHeader"><?php echo nl2br(htmlspecialchars($error['title'])); ?></div>
      <div class="checkoutErrorContents">
        <div class="checkoutErrorMessage"><?php echo nl2br(htmlspecialchars($error['error'])); ?></div>
      </div>
<?php
  }
?>
      <div class="checkoutAddressHeader"><?php echo TABLE_HEADING_BILLING_ADDRESS; ?></div>
      <div class="checkoutAddressConfirmation">
        <div class="checkoutChooseDestination"><?php echo TEXT_SELECTED_BILLING_DESTINATION; ?></div>
        <div class="checkoutAddressLabel"><?php echo tep_address_label($customer_id, $billto, true, ' ', '<br>'); ?></div>
        <div class="checkoutChangeAddress"><?php echo '<a href="' . tep_href_link(FILENAME_CHECKOUT_PAYMENT_ADDRESS, '', 'SSL') . '">' . tep_image_button('button_change_address.gif', IMAGE_BUTTON_CHANGE_ADDRESS) . '</a>'; ?></div>
      </div>
      <div class="checkoutChooseModuleHeader"><?php echo TABLE_HEADING_PAYMENT_METHOD; ?></div>
      <table class="checkoutModuleTable">
<?php
  $selection = $payment_modules->selection();

  if (sizeof($selection) > 1) {
?>
      <thead>
        <tr>
          <th colspan="3"><?php echo TEXT_SELECT_PAYMENT_METHOD; ?></th>
        </tr>
      </thead>
      <tbody>
<?php
  } else {
?>
      <thead>
        <tr>
          <th colspan="3"><?php echo TEXT_ENTER_PAYMENT_INFORMATION; ?></th>
        </tr>
      </thead>
      <tbody>
<?php
  }

  $radio_buttons = 0;
  for ($i=0, $n=sizeof($selection); $i<$n; $i++) {
    if ( ($selection[$i]['id'] == $payment) || ($n == 1) ) {
      echo '        <tr id="defaultSelected" class="checkoutModuleRowSelected" onmouseover="rowOverEffect(this)" onmouseout="rowOutEffect(this)" onclick="selectRowEffect(this, ' . $radio_buttons . ')">' . "\n";
    } else {
      echo '        <tr class="checkoutModuleRow" onmouseover="rowOverEffect(this)" onmouseout="rowOutEffect(this)" onclick="selectRowEffect(this, ' . $radio_buttons . ')">' . "\n";
    }
?>
          <td class="checkoutModuleTitle" colspan="2"><?php echo $selection[$i]['module']; ?></td>
          <td class="checkoutModuleSelect">
<?php
    if (sizeof($selection) > 1) {
      echo tep_draw_radio_field('payment', $selection[$i]['id']) . "</td>\n";
    } else {
      echo tep_draw_hidden_field('payment', $selection[$i]['id']) . "</td>\n";
    }
?>
        </tr>
<?php
    if (isset($selection[$i]['error'])) {
?>
        <tr>
          <td class="checkoutModuleError" colspan="3"><?php echo $selection[$i]['error']; ?></td>
        </tr>
<?php
    } elseif (isset($selection[$i]['fields']) && is_array($selection[$i]['fields'])) {
      for ($j=0, $n2=sizeof($selection[$i]['fields']); $j<$n2; $j++) {
?>
        <tr>
          <td class="checkoutModuleMethod"><?php echo $selection[$i]['fields'][$j]['title']; ?></td>
          <td class="checkoutModuleField"><?php echo $selection[$i]['fields'][$j]['field']; ?></td>
          <td class="checkoutModuleSelect"></td>
        </tr>
<?php
      }
    }
    $radio_buttons++;
  }
?>
      </tbody>
      </table>
      <div class="checkoutCommentsHeader"><?php echo TABLE_HEADING_COMMENTS; ?></div>
      <div class="checkoutComments"><?php echo tep_draw_textarea_field('comments', 'soft', '60', '5') . tep_draw_hidden_field('comments_added', 'YES'); ?></div>
      <div class="checkoutContinueCheckout">
        <div class="checkoutContinueCheckoutTitle"><?php echo TITLE_CONTINUE_CHECKOUT_PROCEDURE; ?></div>
        <div class="checkoutContinueCheckoutText"><?php echo TEXT_CONTINUE_CHECKOUT_PROCEDURE; ?></div>
        <div class="checkoutContinueCheckoutButton"><?php echo tep_image_submit('button_continue.gif', IMAGE_BUTTON_CONTINUE); ?></div>
      </div>
      <table class="checkoutBar">
        <tr class="checkoutBarImage">
          <td class="checkoutBarFrom"><?php echo tep_draw_separator('pixel_trans.gif', '100%', '1'); ?></td>
          <td class="checkoutBarCurrent"><?php echo tep_image(DIR_WS_IMAGES . 'checkout_bullet.gif'); ?></td>
          <td class="checkoutBarTo"><?php echo tep_draw_separator('pixel_trans.gif', '100%', '1'); ?></td>
          <td class="checkoutBarTo"><?php echo tep_draw_separator('pixel_trans.gif', '100%', '1'); ?></td>
        </tr>
        <tr class="checkoutBarText">
          <td class="checkoutBarFrom"><?php echo '<a href="' . tep_href_link(FILENAME_CHECKOUT_SHIPPING, '', 'SSL') . '"><span class="checkoutBarDelivery">' . CHECKOUT_BAR_DELIVERY . '</span></a>'; ?></td>
          <td class="checkoutBarCurrent"><span class="checkoutBarPayment"><?php echo CHECKOUT_BAR_PAYMENT; ?></span></td>
          <td class="checkoutBarTo"><span class="checkoutBarConfirmation"><?php echo CHECKOUT_BAR_CONFIRMATION; ?></span></td>
          <td class="checkoutBarTo"><span class="checkoutBarFinished"><?php echo CHECKOUT_BAR_FINISHED; ?></span></td>
        </tr>
      </table>
<?php
  $shop_info_query = tep_db_query("select shop_info_title, shop_info_value, allow_tags from " . TABLE_SHOP_INFO . " where shop_info_key = 'SHOP_INFO_SHIPPING'");
  $shop_info = tep_db_fetch_array($shop_info_query);
  if (isset($shop_info['shop_info_value']) && tep_not_null($shop_info['shop_info_value'])) {
    echo '      <div class="checkoutOrderNotesHeader">' . HEADING_ORDER_NOTES . '</div>' . "\n";
    echo '      <div id="siShipping">';
    if ($shop_info['allow_tags']) {
      echo $shop_info['shop_info_value'];
    } else {
      echo nl2br(htmlspecialchars($shop_info['shop_info_value']));
    }
    echo '      </div>' . "\n";
  }
 ?>
    </form></td>
<!-- body_text_eof //-->
<!-- right_navigation //-->
<?php require(DIR_WS_INCLUDES . 'column_right.php'); ?>
<!-- right_navigation_eof //-->
  </tr>
</table>
<!-- body_eof //-->
<!-- footer //-->
<?php require(DIR_WS_INCLUDES . 'footer.php'); ?>
<!-- footer_eof //-->
</div>
</body>
</html>
<?php require(DIR_WS_INCLUDES . 'application_bottom.php'); ?>
