<?php
/*
  $Id: header.php,v 1.2 2006/03/23 02:12:26 ryu Exp $

  osCommerce, Open Source E-Commerce Solutions
  http://www.oscommerce.com

  Copyright (c) 2003 osCommerce

  Released under the GNU General Public License
  
  modified for Koshoten.net2
  http://www.koshoten.net/
*/

// check if the 'install' directory exists, and warn of its existence
  if (WARN_INSTALL_EXISTENCE == 'true') {
    if (file_exists(dirname($HTTP_SERVER_VARS['SCRIPT_FILENAME']) . '/install')) {
      echo '<div class="errorBox">' . tep_image(DIR_WS_ICONS . 'warning.gif', ICON_WARNING) . ' ' . WARNING_INSTALL_DIRECTORY_EXISTS . '</div>';
    }
  }

// check if the configure.php file is writeable
  if (WARN_CONFIG_WRITEABLE == 'true') {
    if ( (file_exists(dirname($HTTP_SERVER_VARS['SCRIPT_FILENAME']) . '/includes/configure.php')) && (is_writeable(dirname($HTTP_SERVER_VARS['SCRIPT_FILENAME']) . '/includes/configure.php')) ) {
      echo '<div class="errorBox">' . tep_image(DIR_WS_ICONS . 'warning.gif', ICON_WARNING) . ' ' . WARNING_CONFIG_FILE_WRITEABLE . '</div>';
    }
  }

// check if the session folder is writeable
  if (WARN_SESSION_DIRECTORY_NOT_WRITEABLE == 'true') {
    if (STORE_SESSIONS == '') {
      if (!is_dir(tep_session_save_path())) {
        echo '<div class="errorBox">' . tep_image(DIR_WS_ICONS . 'warning.gif', ICON_WARNING) . ' ' . WARNING_SESSION_DIRECTORY_NON_EXISTENT . '</div>';
      } elseif (!is_writeable(tep_session_save_path())) {
        echo '<div class="errorBox">' . tep_image(DIR_WS_ICONS . 'warning.gif', ICON_WARNING) . ' ' . WARNING_SESSION_DIRECTORY_NOT_WRITEABLE . '</div>';
      }
    }
  }

// check session.auto_start is disabled
  if ( (function_exists('ini_get')) && (WARN_SESSION_AUTO_START == 'true') ) {
    if (ini_get('session.auto_start') == '1') {
      echo '<div class="errorBox">' . tep_image(DIR_WS_ICONS . 'warning.gif', ICON_WARNING) . ' ' . WARNING_SESSION_AUTO_START . '</div>';
    }
  }

  if ( (WARN_DOWNLOAD_DIRECTORY_NOT_READABLE == 'true') && (DOWNLOAD_ENABLED == 'true') ) {
    if (!is_dir(DIR_FS_DOWNLOAD)) {
      echo '<div class="errorBox">' . tep_image(DIR_WS_ICONS . 'warning.gif', ICON_WARNING) . ' ' . WARNING_DOWNLOAD_DIRECTORY_NON_EXISTENT . '</div>';
    }
  }
?>
<table id="header">
  <tr>
    <td id="headerLeft"><?php echo '<a href="' . tep_href_link(FILENAME_DEFAULT) . '">' . tep_image(DIR_WS_IMAGES . KN_HEADER_IMAGE01, TITLE) . '</a>'; ?></td>
    <td id="headerRight"><?php echo tep_image(DIR_WS_IMAGES . KN_HEADER_IMAGE02, TITLE); ?></td>
  </tr>
</table>
<table id="headerBar">
  <tr>
    <td id="breadcrumb">&nbsp;&nbsp;<?php echo $breadcrumb->trail(' &raquo; '); ?></td>
<?php
  if (defined("KN_CFG_ALLOW_CHECKOUT") && (KN_CFG_ALLOW_CHECKOUT == "false")) {
?>
    <td></td>
<?php
  } else {
?>
    <td id="headerMenu"><?php if (tep_session_is_registered('customer_id')) { ?><a href="<?php echo tep_href_link(FILENAME_LOGOFF, '', 'SSL'); ?>"><span class="headerMenu"><?php echo HEADER_TITLE_LOGOFF; ?></span></a><?php } ?><a href="<?php echo tep_href_link(FILENAME_ACCOUNT, '', 'SSL'); ?>"><span class="headerMenu"><?php echo HEADER_TITLE_MY_ACCOUNT; ?></span></a><a href="<?php echo tep_href_link(FILENAME_SHOPPING_CART); ?>"><span class="headerMenu"><?php echo HEADER_TITLE_CART_CONTENTS; ?></span></a><a href="<?php echo tep_href_link(FILENAME_CHECKOUT_SHIPPING, '', 'SSL'); ?>"><span class="headerMenu"><?php echo HEADER_TITLE_CHECKOUT; ?></span></a></td>
<?php
  }
?>
  </tr>
</table>
<?php
  if (isset($HTTP_GET_VARS['error_message']) && tep_not_null($HTTP_GET_VARS['error_message'])) {
?>
<div class="headerError"><?php echo htmlspecialchars(urldecode($HTTP_GET_VARS['error_message'])); ?></div>
<?php
  }

  if (isset($HTTP_GET_VARS['info_message']) && tep_not_null($HTTP_GET_VARS['info_message'])) {
?>
<div class="headerInfo"><?php echo htmlspecialchars($HTTP_GET_VARS['info_message']); ?></div>
<?php
  }
?>