<?php
/*
  $Id: address_book.php,v 1.5 2006/08/07 06:21:15 ryu Exp $

  osCommerce, Open Source E-Commerce Solutions
  http://www.oscommerce.com

  Copyright (c) 2003 osCommerce

  Released under the GNU General Public License
  
  modified for Koshoten.net2
  http://www.koshoten.net/
*/

  require('includes/application_top.php');

  if (defined("KN_CFG_ALLOW_CHECKOUT") && (KN_CFG_ALLOW_CHECKOUT == "false")) {
    tep_redirect(tep_href_link(FILENAME_DEFAULT));
  }

  if (!tep_session_is_registered('customer_id')) {
    $navigation->set_snapshot();
    tep_redirect(tep_href_link(FILENAME_LOGIN, '', 'SSL'));
  }

  require(DIR_WS_LANGUAGES . $language . '/' . FILENAME_ADDRESS_BOOK);

  $breadcrumb->add(NAVBAR_TITLE_1, tep_href_link(FILENAME_ACCOUNT, '', 'SSL'));
  $breadcrumb->add(NAVBAR_TITLE_2, tep_href_link(FILENAME_ADDRESS_BOOK, '', 'SSL'));
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html <?php echo HTML_PARAMS; ?>>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=<?php echo CHARSET; ?>" /> 
<meta http-equiv="content-style-type" content="text/css" />
<title><?php echo TITLE; ?></title>
<base href="<?php echo (($request_type == 'SSL') ? HTTPS_SERVER : HTTP_SERVER) . DIR_WS_CATALOG; ?>" />
<link rel="stylesheet" type="text/css" href="general.css" media="screen,print" />
<link rel="stylesheet" type="text/css" href="<?php echo substr(FILENAME_ADDRESS_BOOK, 0, strrpos(FILENAME_ADDRESS_BOOK, '.'));?>.css" media="screen,print" />
</head>
<body>
<!-- header -->
<?php require(DIR_WS_INCLUDES . 'header.php'); ?>
<!-- /header -->
<hr />
<!-- contents -->
<div id="contents">
<!-- left_contents -->
<?php require(DIR_WS_INCLUDES . 'column_left.php'); ?>
<!-- /left_contents -->
<hr />
<!-- right_contents -->
<?php require(DIR_WS_INCLUDES . 'column_right.php'); ?>
<!-- /right_contents -->
<hr />
<!-- main_contents -->
<?php
  if (KN_CFG_USE_COLUMN_RIGHT == 'true') {
    if (KN_CFG_USE_COLUMN_LEFT == 'true') {
      echo '<div id="mainContentsRL">' . "\n";
    } else {
      echo '<div id="mainContentsR">' . "\n";
    }
  } else {
    if (KN_CFG_USE_COLUMN_LEFT == 'true') {
      echo '<div id="mainContentsL">' . "\n";
    } else {
      echo '<div id="mainContents">' . "\n";
    }
  }
?>
<p class="hide"><a id="skipped" name="skipped" title="<?php echo TEXT_NAVISKIPPED; ?>"><?php echo TEXT_NAVISKIPPED; ?></a></p> 
<h2 class="pageHeading"><?php echo HEADING_TITLE; ?></h2>
<div id="addressBookList">
<table>
<tr>
<th><?php echo TABLE_HEADING_NUMBER; ?></th>
<th><?php echo TABLE_HEADING_NAME; ?></th>
<th><?php echo TABLE_HEADING_LOCATION; ?></th>
</tr>
<?php
  $address_book_query = tep_db_query("select address_book_id, entry_firstname, entry_lastname from " . TABLE_ADDRESS_BOOK . " where customers_id = '" . $customer_id . "' and address_book_id > 1 order by address_book_id");
  if (!tep_db_num_rows($address_book_query)) {
?>
<tr>
<td colspan="3" class="noData"><?php echo TEXT_NO_ENTRIES_IN_ADDRESS_BOOK; ?></td>
</tr>
<?php
  } else {
    $row = 0;
    while ($address_book = tep_db_fetch_array($address_book_query)) {
      $row++;
       if (($row / 2) == floor($row / 2)) {
        echo '<tr class="even">' . "\n";
      } else {
        echo '<tr class="odd">' . "\n";
      }
      echo '<td class="col01">' . tep_row_number_format($row) . '.</td>' . "\n" .
           '<td class="col02"><a href="' . tep_href_link(FILENAME_ADDRESS_BOOK_PROCESS, 'action=modify&entry_id=' . $address_book['address_book_id'], 'SSL') . '">' . tep_output_string_protected(tep_get_fullname($address_book['entry_firstname'],$address_book['entry_lastname'])) . '</a></td>' . "\n" .
           '<td class="col03">' . tep_address_summary($customer_id, $address_book['address_book_id']) . '</td>' . "\n" .
           '</tr>' . "\n";
    }
  }
?>
</table>
<?php
  if ($row < MAX_ADDRESS_BOOK_ENTRIES) {
?>
<p class="caution"><?php echo sprintf(TEXT_MAXIMUM_ENTRIES, MAX_ADDRESS_BOOK_ENTRIES); ?></p>
<div class="buttonLine">
<p class="buttonLeft"><?php echo '<a href="' . tep_href_link(FILENAME_ACCOUNT, '', 'SSL') . '">' . tep_image_button('button_back.gif', IMAGE_BUTTON_BACK) . '</a>'; ?></p>
<p class="buttonRight"><?php echo '<a href="' . tep_href_link(FILENAME_ADDRESS_BOOK_PROCESS,  'entry_id=' . ($row + 2), 'SSL') . '">' . tep_image_button('button_add_address.gif', IMAGE_BUTTON_ADD_ADDRESS) . '</a>'; ?></p>
</div>
<?php
  } else {
?>
<p class="caution"><?php echo sprintf(TEXT_MAXIMUM_ENTRIES_REACHED, MAX_ADDRESS_BOOK_ENTRIES); ?></p>
<div class="buttonLine">
<p class="buttonLeft"><?php echo '<a href="' . tep_href_link(FILENAME_ACCOUNT, '', 'SSL') . '">' . tep_image_button('button_back.gif', IMAGE_BUTTON_BACK) . '</a>'; ?></p>
</div>
<?php
  }
?>
</div>
</div>
<!-- /main_contents -->
<hr />
<!-- footer -->
<?php require(DIR_WS_INCLUDES . 'footer.php'); ?>
<!-- /footer -->
</div>
<!-- /contents -->
</body>
</html>
<?php require(DIR_WS_INCLUDES . 'application_bottom.php'); ?>
