<?php
/*
  $Id: checkout_confirmation.php,v 1.5 2006/08/07 06:21:15 ryu Exp $

  osCommerce, Open Source E-Commerce Solutions
  http://www.oscommerce.com

  Copyright (c) 2003 osCommerce

  Released under the GNU General Public License
  
  modified for Koshoten.net2
  http://www.koshoten.net/
*/

  require('includes/application_top.php');

  if (defined("KN_CFG_ALLOW_CHECKOUT") && (KN_CFG_ALLOW_CHECKOUT == "false")) {
    tep_redirect(tep_href_link(FILENAME_DEFAULT));
  }

// if the customer is not logged on, redirect them to the login page
  if (!tep_session_is_registered('customer_id')) {
    $navigation->set_snapshot(array('mode' => 'SSL', 'page' => FILENAME_CHECKOUT_PAYMENT));
    tep_redirect(tep_href_link(FILENAME_LOGIN, '', 'SSL'));
  }

// if there is nothing in the customers cart, redirect them to the shopping cart page
  if ($cart->count_contents() < 1) {
    tep_redirect(tep_href_link(FILENAME_SHOPPING_CART));
  }

// avoid hack attempts during the checkout procedure by checking the internal cartID
  if (isset($cart->cartID) && tep_session_is_registered('cartID')) {
    if ($cart->cartID != $cartID) {
      tep_redirect(tep_href_link(FILENAME_CHECKOUT_SHIPPING, '', 'SSL'));
    }
  }

// if no shipping method has been selected, redirect the customer to the shipping method selection page
  if (!tep_session_is_registered('shipping')) {
    tep_redirect(tep_href_link(FILENAME_CHECKOUT_SHIPPING, '', 'SSL'));
  }

  if (!tep_session_is_registered('payment')) tep_session_register('payment');
  if (isset($HTTP_POST_VARS['payment'])) $payment = $HTTP_POST_VARS['payment'];

  if (!tep_session_is_registered('comments')) tep_session_register('comments');
  if ($HTTP_POST_VARS['comments_added'] != '') {
    $comments = tep_db_prepare_input($HTTP_POST_VARS['comments']);
  }

// load the selected payment module
  if (KN_CFG_USE_KN_MODULES == 'true') {
    require(DIR_WS_CLASSES . 'kn_payment.php');
  } else {
    require(DIR_WS_CLASSES . 'payment.php');
  }
  $payment_modules = new payment($payment);

  require(DIR_WS_CLASSES . 'order.php');
  $order = new order;

  $payment_modules->update_status();

  if ( ( is_array($payment_modules->modules) && (sizeof($payment_modules->modules) > 1) && !is_object($$payment) ) || (is_object($$payment) && ($$payment->enabled == false)) ) {
    tep_redirect(tep_href_link(FILENAME_CHECKOUT_PAYMENT, 'error_message=' . urlencode(ERROR_NO_PAYMENT_MODULE_SELECTED), 'SSL'));
  }

  if (is_array($payment_modules->modules)) {
    $payment_modules->pre_confirmation_check();
  }

// load the selected shipping module
  require(DIR_WS_CLASSES . 'shipping.php');
  $shipping_modules = new shipping($shipping);

  require(DIR_WS_CLASSES . 'order_total.php');
  $order_total_modules = new order_total;

// Stock Check
  $any_out_of_stock = false;
  if (STOCK_CHECK == 'true') {
    for ($i=0, $n=sizeof($order->products); $i<$n; $i++) {
      if (tep_check_stock($order->products[$i]['id'], $order->products[$i]['qty'])) {
        $any_out_of_stock = true;
      }
    }
    // Out of Stock
    if ( (STOCK_ALLOW_CHECKOUT != 'true') && ($any_out_of_stock == true) ) {
      tep_redirect(tep_href_link(FILENAME_SHOPPING_CART));
    }
  }

  require(DIR_WS_LANGUAGES . $language . '/' . FILENAME_CHECKOUT_CONFIRMATION);

  $breadcrumb->add(NAVBAR_TITLE_1, tep_href_link(FILENAME_CHECKOUT_SHIPPING, '', 'SSL'));
  $breadcrumb->add(NAVBAR_TITLE_2);
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html <?php echo HTML_PARAMS; ?>>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=<?php echo CHARSET; ?>" /> 
<meta http-equiv="content-style-type" content="text/css" />
<title><?php echo TITLE; ?></title>
<base href="<?php echo (($request_type == 'SSL') ? HTTPS_SERVER : HTTP_SERVER) . DIR_WS_CATALOG; ?>" />
<link rel="stylesheet" type="text/css" href="general.css" media="screen,print" />
<link rel="stylesheet" type="text/css" href="<?php echo substr(FILENAME_CHECKOUT_CONFIRMATION, 0, strrpos(FILENAME_CHECKOUT_CONFIRMATION, '.'));?>.css" media="screen,print" />
</head>
<body>
<!-- header -->
<?php require(DIR_WS_INCLUDES . 'header.php'); ?>
<!-- /header -->
<hr />
<!-- contents -->
<div id="contents">
<!-- left_contents -->
<?php require(DIR_WS_INCLUDES . 'column_left.php'); ?>
<!-- /left_contents -->
<hr />
<!-- right_contents -->
<?php require(DIR_WS_INCLUDES . 'column_right.php'); ?>
<!-- /right_contents -->
<hr />
<!-- main_contents -->
<?php
  if (KN_CFG_USE_COLUMN_RIGHT == 'true') {
    if (KN_CFG_USE_COLUMN_LEFT == 'true') {
      echo '<div id="mainContentsRL">' . "\n";
    } else {
      echo '<div id="mainContentsR">' . "\n";
    }
  } else {
    if (KN_CFG_USE_COLUMN_LEFT == 'true') {
      echo '<div id="mainContentsL">' . "\n";
    } else {
      echo '<div id="mainContents">' . "\n";
    }
  }
?>
<p class="hide"><a id="skipped" name="skipped" title="<?php echo TEXT_NAVISKIPPED; ?>"><?php echo TEXT_NAVISKIPPED; ?></a></p> 
<h2 class="pageHeading"><?php echo HEADING_TITLE; ?></h2>
<div id="checkout">
<?php
  $shop_info_query = tep_db_query("select shop_info_title, shop_info_value, allow_tags from " . TABLE_SHOP_INFO . " where shop_info_key = 'SHOP_INFO_CHECKOUT_CONFIRMATION'");
  $shop_info = tep_db_fetch_array($shop_info_query);
  if (isset($shop_info['shop_info_value']) && tep_not_null($shop_info['shop_info_value'])) {
    echo '<div class="information"><p>';
    if ($shop_info['allow_tags']) {
      echo $shop_info['shop_info_value'];
    } else {
      echo nl2br(htmlspecialchars($shop_info['shop_info_value']));
    }
    echo "</p></div>\n";
  }
?>
<h3><?php echo HEADING_PRODUCTS_INFORMATION; ?></h3>
<p class="orderEdit"><?php echo '<a href="' . tep_href_link(FILENAME_SHOPPING_CART) . '">' . TEXT_EDIT . '</a>'; ?></p>
<table class="productsTable">
<?php
  if (sizeof($order->info['tax_groups']) > 1) {
?>
<tr>
<th colspan="3"><?php echo HEADING_PRODUCTS; ?></th>
<th><?php echo HEADING_TAX; ?></th>
<th><?php echo HEADING_TOTAL; ?></th>
</tr>
<?php
  } else {
?>
<tr>
<th colspan="4"><?php echo HEADING_PRODUCTS; ?></th>
</tr>
<?php
  }

  for ($i=0, $n=sizeof($order->products); $i<$n; $i++) {
    echo '<tr>' . "\n" .
         '<td class="quantity"><p>' . $order->products[$i]['qty'] . '&nbsp;x</p></td>' . "\n" .
         '<td class="product"><p>' . $order->products[$i]['name'];

    if (STOCK_CHECK == 'true') {
      echo tep_check_stock($order->products[$i]['id'], $order->products[$i]['qty']);
    }

    if ( (isset($order->products[$i]['attributes'])) && (sizeof($order->products[$i]['attributes']) > 0) ) {
      for ($j=0, $n2=sizeof($order->products[$i]['attributes']); $j<$n2; $j++) {
        echo '<br /><span class="options"> - ' . $order->products[$i]['attributes'][$j]['option'] . ': ' . $order->products[$i]['attributes'][$j]['value'] . '</span>';
      }
    }

    echo '</p></td>' . "\n";
    echo '<td><p>';
    if ((KN_CFG_USE_SUBTITLE == 'true') && !empty($order->products[$i]['subtitle'])) {
      echo $order->products[$i]['subtitle'] . '&nbsp;';
    }
    if ((KN_CFG_USE_SERIES_TITLE == 'true') && !empty($order->products[$i]['series_title'])) {
      echo $order->products[$i]['series_title'] . '&nbsp;';
    }
    if ((KN_CFG_USE_AUTHOR == 'true') && !empty($order->products[$i]['author'])) {
      echo $order->products[$i]['author'] . '&nbsp;';
    }
    if ((KN_CFG_USE_PUBLISHERS == 'true') && !empty($order->products[$i]['publishers'])) {
      echo $order->products[$i]['publishers'] . '&nbsp;';
    }
    if ((KN_CFG_USE_VOLUME == 'true') && !empty($order->products[$i]['volume'])) {
      echo $order->products[$i]['volume'] . '&nbsp;';
    }
    if ((KN_CFG_USE_PUBLISHED == 'true') && !empty($order->products[$i]['published'])) {
      echo $order->products[$i]['published'] . '&nbsp;';
    }
    echo $order->products[$i]['description'] . '</p></td>' . "\n";

    if (sizeof($order->info['tax_groups']) > 1) echo '<td class="tax"><p>' . tep_display_tax_value($order->products[$i]['tax']) . '%</p></td>' . "\n";

    echo '<td class="price"><p>' . $currencies->display_price($order->products[$i]['final_price'], $order->products[$i]['tax'], $order->products[$i]['qty']) . '</p></td>' . "\n";
    echo '</tr>' . "\n";
  }
  
  echo "</table>\n";

  if (MODULE_ORDER_TOTAL_INSTALLED) {
    $order_total_modules->process();
    echo $order_total_modules->output();
  }
?>
<h3><?php echo HEADING_CUSTOMER_INFORMATION; ?></h3>
<div id="contentsBox">
<div id="leftBox">
<?php
  if ($sendto != false) {
    echo '<h4>' . HEADING_DELIVERY_ADDRESS . "</h4>\n";
    echo '<p class="orderEdit"><a href="' . tep_href_link(FILENAME_CHECKOUT_SHIPPING_ADDRESS, '', 'SSL') . '">' . TEXT_EDIT . "</a></p>\n";
    echo '<p>' . tep_address_format($order->delivery['format_id'], $order->delivery, 1, ' ', '<br />') . "</p>\n";
  }
  if ($order->info['shipping_method']) {
    echo '<h4>' . HEADING_SHIPPING_METHOD . "</h4>\n";
    echo '<p class="orderEdit"><a href="' . tep_href_link(FILENAME_CHECKOUT_SHIPPING, '', 'SSL') . '">' . TEXT_EDIT . "</a></p>\n";
    echo '<p>' . $order->info['shipping_method'] . "</p>\n";
  }
?>
</div>
<div id="rightBox">
<?php
  echo '<h4>' . HEADING_BILLING_ADDRESS . "</h4>\n";
  echo '<p class="orderEdit"><a href="' . tep_href_link(FILENAME_CHECKOUT_PAYMENT_ADDRESS, '', 'SSL') . '">' . TEXT_EDIT . "</a></p>\n";
  echo '<p>' . tep_address_format($order->billing['format_id'], $order->billing, 1, ' ', '<br />') . "</p>\n";

  if ($order->info['payment_method']) {
    echo '<h4>' . HEADING_PAYMENT_METHOD . "</h4>\n";
    echo '<p class="orderEdit"><a href="' . tep_href_link(FILENAME_CHECKOUT_PAYMENT, '', 'SSL') . '">' . TEXT_EDIT . "</a></p>\n";
    echo '<p>' . $order->info['payment_method'] . "</p>\n";
  }
?>
</div>
</div>
<?php
  if (is_array($payment_modules->modules)) {
    if ($confirmation = $payment_modules->confirmation()) {
      echo '<h3>' . HEADING_PAYMENT_INFORMATION . "</h3>\n";
      echo "<ul>\n";
      echo '<li>' . $confirmation['title'] . "</li>\n";
      for ($i=0, $n=sizeof($confirmation['fields']); $i<$n; $i++) {
        echo '<li>' . $confirmation['fields'][$i]['title'] . $confirmation['fields'][$i]['field'] . "</li>\n";
      }
      echo "</ul>\n";
    }
  }

  if (tep_not_null($order->info['comments'])) {
    echo '<h3>' . HEADING_ORDER_COMMENTS . "</h3>\n";
    echo '<p class="orderEdit"><a href="' . tep_href_link(FILENAME_CHECKOUT_PAYMENT, '', 'SSL') . '">' . TEXT_EDIT . "</a></p>\n";
    echo '<p>' . nl2br(htmlspecialchars($order->info['comments'])) . "</p>\n";
  }
?>
<div class="buttonLine">
<p class="buttonRight">
<?php
  if (isset($$payment->form_action_url)) {
    $form_action_url = $$payment->form_action_url;
  } else {
    $form_action_url = tep_href_link(FILENAME_CHECKOUT_PROCESS, '', 'SSL');
  }

  echo tep_draw_form('checkout_confirmation', $form_action_url, 'post') . "\n";

  if (is_array($payment_modules->modules)) {
    echo $payment_modules->process_button();
  }

  echo tep_draw_hidden_field('comments', $order->info['comments']) . "\n";
  echo tep_image_submit('button_confirm_order.gif', IMAGE_BUTTON_CONFIRM_ORDER) . "\n";
  echo "</form>\n";
?>
</p>
</div>

<ul id="checkoutBar">
<li class="from"><p><?php echo '<a href="' . tep_href_link(FILENAME_CHECKOUT_SHIPPING, '', 'SSL') . '">' . CHECKOUT_BAR_DELIVERY . '</a>'; ?></p></li>
<li class="from"><p><?php echo '<a href="' . tep_href_link(FILENAME_CHECKOUT_PAYMENT, '', 'SSL') . '">' . CHECKOUT_BAR_PAYMENT . '</a>'; ?></p></li>
<li class="current">
<p><?php echo tep_image(DIR_WS_IMAGES . 'checkout_bullet.gif'); ?></p>
<p><?php echo CHECKOUT_BAR_CONFIRMATION; ?></p>
</li>
<li class="to"><p><?php echo CHECKOUT_BAR_FINISHED; ?></p></li>
</ul>
<?php
  $shop_info_query = tep_db_query("select shop_info_title, shop_info_value, allow_tags from " . TABLE_SHOP_INFO . " where shop_info_key = 'SHOP_INFO_SHIPPING'");
  $shop_info = tep_db_fetch_array($shop_info_query);
  if (isset($shop_info['shop_info_value']) && tep_not_null($shop_info['shop_info_value'])) {
    echo '<h3>' . HEADING_ORDER_NOTES . "</h3>\n";
    echo '<p>';
    if ($shop_info['allow_tags']) {
      echo $shop_info['shop_info_value'];
    } else {
      echo nl2br(htmlspecialchars($shop_info['shop_info_value']));
    }
    echo "</p>\n";
  }
 ?>
</div>
</div>
<!-- /main_contents -->
<hr />
<!-- footer -->
<?php require(DIR_WS_INCLUDES . 'footer.php'); ?>
<!-- /footer -->
</div>
<!-- /contents -->
</body>
</html>
<?php require(DIR_WS_INCLUDES . 'application_bottom.php'); ?>
