<?php
/*
  $Id: checkout_payment.php,v 1.5 2006/08/07 06:21:15 ryu Exp $

  osCommerce, Open Source E-Commerce Solutions
  http://www.oscommerce.com

  Copyright (c) 2003 osCommerce

  Released under the GNU General Public License
  
  modified for Koshoten.net2
  http://www.koshoten.net/
*/

  require('includes/application_top.php');

  if (defined("KN_CFG_ALLOW_CHECKOUT") && (KN_CFG_ALLOW_CHECKOUT == "false")) {
    tep_redirect(tep_href_link(FILENAME_DEFAULT));
  }

// if the customer is not logged on, redirect them to the login page
  if (!tep_session_is_registered('customer_id')) {
    $navigation->set_snapshot();
    tep_redirect(tep_href_link(FILENAME_LOGIN, '', 'SSL'));
  }

// if there is nothing in the customers cart, redirect them to the shopping cart page
  if ($cart->count_contents() < 1) {
    tep_redirect(tep_href_link(FILENAME_SHOPPING_CART));
  }

// if no shipping method has been selected, redirect the customer to the shipping method selection page
  if (!tep_session_is_registered('shipping')) {
    tep_redirect(tep_href_link(FILENAME_CHECKOUT_SHIPPING, '', 'SSL'));
  }

// avoid hack attempts during the checkout procedure by checking the internal cartID
  if (isset($cart->cartID) && tep_session_is_registered('cartID')) {
    if ($cart->cartID != $cartID) {
      tep_redirect(tep_href_link(FILENAME_CHECKOUT_SHIPPING, '', 'SSL'));
    }
  }

// Stock Check
  if ( (STOCK_CHECK == 'true') && (STOCK_ALLOW_CHECKOUT != 'true') ) {
    $products = $cart->get_products();
    for ($i=0, $n=sizeof($products); $i<$n; $i++) {
      if (tep_check_stock($products[$i]['id'], $products[$i]['quantity'])) {
        tep_redirect(tep_href_link(FILENAME_SHOPPING_CART));
        break;
      }
    }
  }

// if no billing destination address was selected, use the customers own address as default
  if (!tep_session_is_registered('billto')) {
    tep_session_register('billto');
    $billto = $customer_default_address_id;
  } else {
// verify the selected billing address
    $check_address_query = tep_db_query("select count(*) as total from " . TABLE_ADDRESS_BOOK . " where customers_id = '" . (int)$customer_id . "' and address_book_id = '" . (int)$billto . "'");
    $check_address = tep_db_fetch_array($check_address_query);

    if ($check_address['total'] != '1') {
      $billto = $customer_default_address_id;
      if (tep_session_is_registered('payment')) tep_session_unregister('payment');
    }
  }

  require(DIR_WS_CLASSES . 'order.php');
  $order = new order;

  if (!tep_session_is_registered('comments')) tep_session_register('comments');

  $total_weight = $cart->show_weight();
  $total_count = $cart->count_contents();

// load all enabled payment modules
// koshoten.netѤλʧ⥸塼Ȥɤ
  if (KN_CFG_USE_KN_MODULES == 'true') {
    require(DIR_WS_CLASSES . 'kn_payment.php');
  } else {
    require(DIR_WS_CLASSES . 'payment.php');
  }
  $payment_modules = new payment;

  require(DIR_WS_LANGUAGES . $language . '/' . FILENAME_CHECKOUT_PAYMENT);

  $breadcrumb->add(NAVBAR_TITLE_1, tep_href_link(FILENAME_CHECKOUT_SHIPPING, '', 'SSL'));
  $breadcrumb->add(NAVBAR_TITLE_2, tep_href_link(FILENAME_CHECKOUT_PAYMENT, '', 'SSL'));
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html <?php echo HTML_PARAMS; ?>>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=<?php echo CHARSET; ?>" /> 
<meta http-equiv="content-style-type" content="text/css" />
<title><?php echo TITLE; ?></title>
<base href="<?php echo (($request_type == 'SSL') ? HTTPS_SERVER : HTTP_SERVER) . DIR_WS_CATALOG; ?>" />
<link rel="stylesheet" type="text/css" href="general.css" media="screen,print" />
<link rel="stylesheet" type="text/css" href="<?php echo substr(FILENAME_CHECKOUT_PAYMENT, 0, strrpos(FILENAME_CHECKOUT_PAYMENT, '.'));?>.css" media="screen,print" />
<script language="javascript"><!--
var selected;

function selectRowEffect(object, buttonSelect) {
  if (!selected) {
    if (document.getElementById) {
      selected = document.getElementById('defaultSelected');
    } else {
      selected = document.all['defaultSelected'];
    }
  }

  if (selected) selected.className = 'checkoutModuleRow';
  object.className = 'checkoutModuleRowSelected';
  selected = object;

// one button is not an array
  if (document.checkout_payment.payment[0]) {
    document.checkout_payment.payment[buttonSelect].checked=true;
  } else {
    document.checkout_payment.payment.checked=true;
  }
}

function rowOverEffect(object) {
  if (object.className == 'checkoutModuleRow') object.className = 'checkoutModuleRowOver';
}

function rowOutEffect(object) {
  if (object.className == 'checkoutModuleRowOver') object.className = 'checkoutModuleRow';
}
//--></script>
<?php echo $payment_modules->javascript_validation(); ?>
</head>
<body>
<!-- header -->
<?php require(DIR_WS_INCLUDES . 'header.php'); ?>
<!-- /header -->
<hr />
<!-- contents -->
<div id="contents">
<!-- left_contents -->
<?php require(DIR_WS_INCLUDES . 'column_left.php'); ?>
<!-- /left_contents -->
<hr />
<!-- right_contents -->
<?php require(DIR_WS_INCLUDES . 'column_right.php'); ?>
<!-- /right_contents -->
<hr />
<!-- main_contents -->
<?php
  if (KN_CFG_USE_COLUMN_RIGHT == 'true') {
    if (KN_CFG_USE_COLUMN_LEFT == 'true') {
      echo '<div id="mainContentsRL">' . "\n";
    } else {
      echo '<div id="mainContentsR">' . "\n";
    }
  } else {
    if (KN_CFG_USE_COLUMN_LEFT == 'true') {
      echo '<div id="mainContentsL">' . "\n";
    } else {
      echo '<div id="mainContents">' . "\n";
    }
  }
?>
<p class="hide"><a id="skipped" name="skipped" title="<?php echo TEXT_NAVISKIPPED; ?>"><?php echo TEXT_NAVISKIPPED; ?></a></p> 
<h2 class="pageHeading"><?php echo HEADING_TITLE; ?></h2>
<?php echo tep_draw_form('checkout_payment', tep_href_link(FILENAME_CHECKOUT_CONFIRMATION, '', 'SSL'), 'post', 'onsubmit="return check_form();"'); ?>
<div id="checkout">
<?php
  if (isset($HTTP_GET_VARS['payment_error']) && is_object(${$HTTP_GET_VARS['payment_error']}) && ($error = ${$HTTP_GET_VARS['payment_error']}->get_error())) {
?>
<p class="errorTitle"><?php echo nl2br(htmlspecialchars($error['title'])); ?></p>
<p class="errorMessage"><?php echo nl2br(htmlspecialchars($error['error'])); ?></p>
<?php
  }
?>
<h3><?php echo TABLE_HEADING_BILLING_ADDRESS; ?></h3>
<p><?php echo TEXT_SELECTED_BILLING_DESTINATION; ?></p>
<p class="addressLabel"><?php echo tep_address_label($customer_id, $billto, true, ' ', '<br />'); ?></p>
<p class="changeAddress"><?php echo '<a href="' . tep_href_link(FILENAME_CHECKOUT_PAYMENT_ADDRESS, '', 'SSL') . '">' . tep_image_button('button_change_address.gif', IMAGE_BUTTON_CHANGE_ADDRESS) . '</a>'; ?></p>
<h3><?php echo TABLE_HEADING_PAYMENT_METHOD; ?></h3>
<?php
  $selection = $payment_modules->selection();

  if (sizeof($selection) > 1) {
    echo '<p>' . TEXT_SELECT_PAYMENT_METHOD . "</p>\n";
  } elseif ($free_shipping == false) {
    echo '<p>' .  TEXT_ENTER_PAYMENT_INFORMATION . "</p>\n";
  }
?>
<table class="moduleTable">
<?php
  $radio_buttons = 0;
  for ($i=0, $n=sizeof($selection); $i<$n; $i++) {
    if ( ($selection[$i]['id'] == $payment) || ($n == 1) ) {
      echo '<tr id="defaultSelected" class="checkoutModuleRowSelected" onmouseover="rowOverEffect(this)" onmouseout="rowOutEffect(this)" onclick="selectRowEffect(this, ' . $radio_buttons . ')">' . "\n";
    } else {
      echo '<tr class="checkoutModuleRow" onmouseover="rowOverEffect(this)" onmouseout="rowOutEffect(this)" onclick="selectRowEffect(this, ' . $radio_buttons . ')">' . "\n";
    }

    if (sizeof($selection) > 1) {
      echo '<th class="select">' . tep_draw_radio_field('payment', $selection[$i]['id']) . "</th>\n";
    } else {
      echo '<th class="select">' . tep_draw_hidden_field('payment', $selection[$i]['id']) . "</th>\n";
    }
?>
<th class="title" colspan="2"><?php echo $selection[$i]['module']; ?></th>
</tr>
<?php
    if (isset($selection[$i]['error'])) {
?>
<tr class="checkoutModuleRowFields">
<td class="error" colspan="3"><?php echo $selection[$i]['error']; ?></td>
</tr>
<?php
    } elseif (isset($selection[$i]['fields']) && is_array($selection[$i]['fields'])) {
      for ($j=0, $n2=sizeof($selection[$i]['fields']); $j<$n2; $j++) {
?>
<tr class="checkoutModuleRowFields">
<td class="select">&nbsp;</td>
<?php
        if ($selection[$i]['fields'][$j]['field']) {
?>
<td class="method"><?php echo $selection[$i]['fields'][$j]['title']; ?></td>
<td class="field"><?php echo $selection[$i]['fields'][$j]['field']; ?></td>
<?php
        } else {
?>
<td class="method" colspan="2"><?php echo $selection[$i]['fields'][$j]['title']; ?></td>
<?php
        }
?>
</tr>
<?php
      }
    }
    $radio_buttons++;
  }
?>
</table>
<h3><?php echo TABLE_HEADING_COMMENTS; ?></h3>
<p><?php echo tep_draw_textarea_field('comments', 'soft', '60', '5') . tep_draw_hidden_field('comments_added', 'YES'); ?></p>
<div class="buttonLine">
<p class="checkoutTitle"><?php echo TITLE_CONTINUE_CHECKOUT_PROCEDURE; ?></p>
<p class="checkoutText"><?php echo TEXT_CONTINUE_CHECKOUT_PROCEDURE; ?></p>
<p class="buttonRight"><?php echo tep_image_submit('button_continue.gif', IMAGE_BUTTON_CONTINUE); ?></p>
</div>
<ul id="checkoutBar">
<li class="from"><p><?php echo '<a href="' . tep_href_link(FILENAME_CHECKOUT_SHIPPING, '', 'SSL') . '">' . CHECKOUT_BAR_DELIVERY . '</a>'; ?></p></li>
<li class="current">
<p><?php echo tep_image(DIR_WS_IMAGES . 'checkout_bullet.gif'); ?></p>
<p><?php echo CHECKOUT_BAR_PAYMENT; ?></p>
</li>
<li class="to"><p><?php echo CHECKOUT_BAR_CONFIRMATION; ?></p></li>
<li class="to"><p><?php echo CHECKOUT_BAR_FINISHED; ?></p></li>
</ul>
<?php
  $shop_info_query = tep_db_query("select shop_info_title, shop_info_value, allow_tags from " . TABLE_SHOP_INFO . " where shop_info_key = 'SHOP_INFO_SHIPPING'");
  $shop_info = tep_db_fetch_array($shop_info_query);
  if (isset($shop_info['shop_info_value']) && tep_not_null($shop_info['shop_info_value'])) {
    echo '<h3>' . HEADING_ORDER_NOTES . "</h3>\n";
    echo '<p>';
    if ($shop_info['allow_tags']) {
      echo $shop_info['shop_info_value'];
    } else {
      echo nl2br(htmlspecialchars($shop_info['shop_info_value']));
    }
    echo "</p>\n";
  }
?>
</div>
</form>
</div>
<!-- /main_contents -->
<hr />
<!-- footer -->
<?php require(DIR_WS_INCLUDES . 'footer.php'); ?>
<!-- /footer -->
</div>
<!-- /contents -->
</body>
</html>
<?php require(DIR_WS_INCLUDES . 'application_bottom.php'); ?>
