<?php
/*
  $Id: checkout_process.php,v 1.7 2006/06/13 12:52:33 ryu Exp $

  osCommerce, Open Source E-Commerce Solutions
  http://www.oscommerce.com

  Copyright (c) 2003 osCommerce

  Released under the GNU General Public License
  
  modified for Koshoten.net2
  http://www.koshoten.net/
*/

  include('includes/application_top.php');

  if (defined("KN_CFG_ALLOW_CHECKOUT") && (KN_CFG_ALLOW_CHECKOUT == "false")) {
    tep_redirect(tep_href_link(FILENAME_DEFAULT));
  }

// ̾ǤȴʰǤ̤Ѥ
  if (KN_CFG_SHORT_CHECKOUT == 'true') {
  // if the customer is not logged on, redirect them to the login page
    if (!tep_session_is_registered('customer_id')) {
      $navigation->set_snapshot(array('mode' => 'SSL', 'page' => FILENAME_CHECKOUT_CONFIRMATION_SHORT));
      tep_redirect(tep_href_link(FILENAME_LOGIN, '', 'SSL'));
    }
  
    if (!tep_session_is_registered('sendto')) {
      tep_redirect(tep_href_link(FILENAME_CHECKOUT_CONFIRMATION_SHORT, '', 'SSL'));
    }

    if (!tep_session_is_registered('billto')) {
      tep_redirect(tep_href_link(FILENAME_CHECKOUT_CONFIRMATION_SHORT, '', 'SSL'));
    }
 
  // avoid hack attempts during the checkout procedure by checking the internal cartID
    if (isset($cart->cartID) && tep_session_is_registered('cartID')) {
      if ($cart->cartID != $cartID) {
        tep_redirect(tep_href_link(FILENAME_CHECKOUT_CONFIRMATION_SHORT, '', 'SSL'));
      }
    }
  } else {
  // if the customer is not logged on, redirect them to the login page
    if (!tep_session_is_registered('customer_id')) {
      $navigation->set_snapshot(array('mode' => 'SSL', 'page' => FILENAME_CHECKOUT_CONFIRMATION));
      tep_redirect(tep_href_link(FILENAME_LOGIN, '', 'SSL'));
    }
  
    if (!tep_session_is_registered('sendto')) {
      tep_redirect(tep_href_link(FILENAME_CHECKOUT_SHIPPING, '', 'SSL'));
    }

    if (KN_CFG_USE_KN_MODULES == 'true') {
      if ( (tep_not_null(KN_CFG_MODULE_PAYMENT_INSTALLED)) && (!tep_session_is_registered('payment')) ) {
        tep_redirect(tep_href_link(FILENAME_CHECKOUT_PAYMENT, '', 'SSL'));
      }
    } else {
      if ( (tep_not_null(MODULE_PAYMENT_INSTALLED)) && (!tep_session_is_registered('payment')) ) {
        tep_redirect(tep_href_link(FILENAME_CHECKOUT_PAYMENT, '', 'SSL'));
      }
    }
 
  // avoid hack attempts during the checkout procedure by checking the internal cartID
    if (isset($cart->cartID) && tep_session_is_registered('cartID')) {
      if ($cart->cartID != $cartID) {
        tep_redirect(tep_href_link(FILENAME_CHECKOUT_SHIPPING, '', 'SSL'));
      }
    }
  }
    
  include(DIR_WS_LANGUAGES . $language . '/' . FILENAME_CHECKOUT_PROCESS);
  
  if (isset($HTTP_POST_VARS['comments'])) {
    if (!tep_session_is_registered('comments')) tep_session_register('comments');
    $comments = tep_db_prepare_input($HTTP_POST_VARS['comments']);
  } else {
    $comments = $order->info['comments'];
  }
  
// load selected payment module
// koshoten.netѤλʧ⥸塼Ȥɤ
  if (KN_CFG_USE_KN_MODULES == 'true') {
    require(DIR_WS_CLASSES . 'kn_payment.php');
  } else {
    require(DIR_WS_CLASSES . 'payment.php');
  }
  $payment_modules = new payment($payment);

// load the selected shipping module
// koshoten.netѤ⥸塼Ȥɤ
  if (KN_CFG_USE_KN_MODULES == 'true') {
    require(DIR_WS_CLASSES . 'kn_shipping.php');
  } else {
    require(DIR_WS_CLASSES . 'shipping.php');
  }
  $shipping_modules = new shipping($shipping);
  // add for Japanese update
  if (isset($shipping['timespec'])) {
    $comments = '['.TEXT_TIME_SPECIFY.$shipping['timespec'].']'
       ."\n".$comments;
  }

  require(DIR_WS_CLASSES . 'order.php');
  $order = new order;

// load the before_process function from the payment modules
  $payment_modules->before_process();

  require(DIR_WS_CLASSES . 'order_total.php');
  $order_total_modules = new order_total;

  $order_totals = $order_total_modules->process();

// 2003-06-06 add_telephone
  $sql_data_array = array('customers_id' => $customer_id,
                          'customers_name' => tep_get_fullname($order->customer['firstname'],$order->customer['lastname']),
                          'customers_company' => $order->customer['company'],
                          'customers_street_address' => $order->customer['street_address'],
                          'customers_suburb' => $order->customer['suburb'],
                          'customers_city' => $order->customer['city'],
                          'customers_postcode' => $order->customer['postcode'], 
                          'customers_state' => $order->customer['state'], 
                          'customers_country' => $order->customer['country']['title'], 
                          'customers_telephone' => $order->customer['telephone'], 
                          'customers_email_address' => $order->customer['email_address'],
                          'customers_address_format_id' => $order->customer['format_id'], 
                          'delivery_name' => tep_get_fullname($order->delivery['firstname'],$order->delivery['lastname']), 
                          'delivery_company' => $order->delivery['company'],
                          'delivery_street_address' => $order->delivery['street_address'], 
                          'delivery_suburb' => $order->delivery['suburb'], 
                          'delivery_city' => $order->delivery['city'], 
                          'delivery_postcode' => $order->delivery['postcode'], 
                          'delivery_state' => $order->delivery['state'], 
                          'delivery_country' => $order->delivery['country']['title'], 
                          'delivery_telephone' => $order->delivery['telephone'], 
                          'delivery_address_format_id' => $order->delivery['format_id'], 
                          'billing_name' => tep_get_fullname($order->billing['firstname'],$order->billing['lastname']),
                          'billing_company' => $order->billing['company'],
                          'billing_street_address' => $order->billing['street_address'], 
                          'billing_suburb' => $order->billing['suburb'], 
                          'billing_city' => $order->billing['city'], 
                          'billing_postcode' => $order->billing['postcode'], 
                          'billing_state' => $order->billing['state'], 
                          'billing_country' => $order->billing['country']['title'], 
                          'billing_telephone' => $order->billing['telephone'], 
                          'billing_address_format_id' => $order->billing['format_id'], 
                          'payment_method' => $order->info['payment_method'], 
                          'cc_type' => $order->info['cc_type'], 
                          'cc_owner' => $order->info['cc_owner'], 
                          'cc_number' => $order->info['cc_number'], 
                          'cc_expires' => $order->info['cc_expires'], 
                          'date_purchased' => 'now()', 
                          'orders_status' => $order->info['order_status'], 
                          'currency' => $order->info['currency'], 
                          'currency_value' => $order->info['currency_value']);
  tep_db_perform(TABLE_ORDERS, $sql_data_array);
  $insert_id = tep_db_insert_id();
  for ($i=0, $n=sizeof($order_totals); $i<$n; $i++) {
    $sql_data_array = array('orders_id' => $insert_id,
                            'title' => $order_totals[$i]['title'],
                            'text' => $order_totals[$i]['text'],
                            'value' => $order_totals[$i]['value'], 
                            'class' => $order_totals[$i]['code'], 
                            'sort_order' => $order_totals[$i]['sort_order']);
    tep_db_perform(TABLE_ORDERS_TOTAL, $sql_data_array);
  }

  $customer_notification = (SEND_EMAILS == 'true') ? '1' : '0';
  $sql_data_array = array('orders_id' => $insert_id, 
                          'orders_status_id' => $order->info['order_status'], 
                          'date_added' => 'now()', 
                          'customer_notified' => $customer_notification,
                          'comments' => $comments);
  tep_db_perform(TABLE_ORDERS_STATUS_HISTORY, $sql_data_array);

// initialized for the email confirmation
  $products_ordered = '';
  $subtotal = 0;
  $total_tax = 0;

  for ($i=0, $n=sizeof($order->products); $i<$n; $i++) {
// Stock Update - Joao Correia
    if (STOCK_LIMITED == 'true') {
      if (DOWNLOAD_ENABLED == 'true') {
        $stock_query_raw = "SELECT products_quantity, pad.products_attributes_filename 
                            FROM " . TABLE_PRODUCTS . " p
                            LEFT JOIN " . TABLE_PRODUCTS_ATTRIBUTES . " pa
                             ON p.products_id=pa.products_id
                            LEFT JOIN " . TABLE_PRODUCTS_ATTRIBUTES_DOWNLOAD . " pad
                             ON pa.products_attributes_id=pad.products_attributes_id
                            WHERE p.products_id = '" . tep_get_prid($order->products[$i]['id']) . "'";
// Will work with only one option for downloadable products
// otherwise, we have to build the query dynamically with a loop
        $products_attributes = $order->products[$i]['attributes'];
        if (is_array($products_attributes)) {
          $stock_query_raw .= " AND pa.options_id = '" . $products_attributes[0]['option_id'] . "' AND pa.options_values_id = '" . $products_attributes[0]['value_id'] . "'";
        }
        $stock_query = tep_db_query($stock_query_raw);
      } else {
        $stock_query = tep_db_query("select products_quantity from " . TABLE_PRODUCTS . " where products_id = '" . tep_get_prid($order->products[$i]['id']) . "'");
      }
      if (tep_db_num_rows($stock_query) > 0) {
        $stock_values = tep_db_fetch_array($stock_query);
// do not decrement quantities if products_attributes_filename exists
        if ((DOWNLOAD_ENABLED != 'true') || (!$stock_values['products_attributes_filename'])) {
          $stock_left = $stock_values['products_quantity'] - $order->products[$i]['qty'];
        } else {
          $stock_left = $stock_values['products_quantity'];
        }
        tep_db_query("update " . TABLE_PRODUCTS . " set products_quantity = '" . $stock_left . "' where products_id = '" . tep_get_prid($order->products[$i]['id']) . "'");
        if ($stock_left < 1) {
          tep_db_query("update " . TABLE_PRODUCTS . " set products_status = '0' where products_id = '" . tep_get_prid($order->products[$i]['id']) . "'");
        }
      }
    }

// Update products_ordered (for bestsellers list)
    tep_db_query("update " . TABLE_PRODUCTS . " set products_ordered = products_ordered + " . sprintf('%d', $order->products[$i]['qty']) . " where products_id = '" . tep_get_prid($order->products[$i]['id']) . "'");

    $sql_data_array = array('orders_id' => $insert_id, 
                            'products_id' => tep_get_prid($order->products[$i]['id']), 
                            'products_model' => $order->products[$i]['model'], 
                            'products_name' => $order->products[$i]['name'],
                            'products_subtitle' => $order->products[$i]['subtitle'],
                            'products_series_title' => $order->products[$i]['series_title'],
                            'products_author' => $order->products[$i]['author'],
                            'products_published' => $order->products[$i]['published'],
                            'products_publishers' => $order->products[$i]['publishers'],
                            'products_volume' => $order->products[$i]['volume'],
                            'products_isbn' => $order->products[$i]['isbn'],
                            'manufacturers_id' => $order->products[$i]['mID'],
                            'products_description' => $order->products[$i]['description'],
                            'products_price' => $order->products[$i]['price'], 
                            'final_price' => $order->products[$i]['final_price'], 
                            'products_tax' => $order->products[$i]['tax'], 
                            'products_quantity' => $order->products[$i]['qty']);
    tep_db_perform(TABLE_ORDERS_PRODUCTS, $sql_data_array);
    $order_products_id = tep_db_insert_id();

//------insert customer choosen option to order--------
    $attributes_exist = '0';
    $products_ordered_attributes = '';
    if (isset($order->products[$i]['attributes'])) {
      $attributes_exist = '1';
      for ($j=0, $n2=sizeof($order->products[$i]['attributes']); $j<$n2; $j++) {
        if (DOWNLOAD_ENABLED == 'true') {
          $attributes_query = "select popt.products_options_name, poval.products_options_values_name, pa.options_values_price, pa.price_prefix, pad.products_attributes_maxdays, pad.products_attributes_maxcount , pad.products_attributes_filename 
                               from " . TABLE_PRODUCTS_OPTIONS . " popt, " . TABLE_PRODUCTS_OPTIONS_VALUES . " poval, " . TABLE_PRODUCTS_ATTRIBUTES . " pa 
                               left join " . TABLE_PRODUCTS_ATTRIBUTES_DOWNLOAD . " pad
                                on pa.products_attributes_id=pad.products_attributes_id
                               where pa.products_id = '" . $order->products[$i]['id'] . "' 
                                and pa.options_id = '" . $order->products[$i]['attributes'][$j]['option_id'] . "' 
                                and pa.options_id = popt.products_options_id 
                                and pa.options_values_id = '" . $order->products[$i]['attributes'][$j]['value_id'] . "' 
                                and pa.options_values_id = poval.products_options_values_id 
                                and popt.language_id = '" . $languages_id . "' 
                                and poval.language_id = '" . $languages_id . "'";
          $attributes = tep_db_query($attributes_query);
        } else {
          $attributes = tep_db_query("select popt.products_options_name, poval.products_options_values_name, pa.options_values_price, pa.price_prefix from " . TABLE_PRODUCTS_OPTIONS . " popt, " . TABLE_PRODUCTS_OPTIONS_VALUES . " poval, " . TABLE_PRODUCTS_ATTRIBUTES . " pa where pa.products_id = '" . $order->products[$i]['id'] . "' and pa.options_id = '" . $order->products[$i]['attributes'][$j]['option_id'] . "' and pa.options_id = popt.products_options_id and pa.options_values_id = '" . $order->products[$i]['attributes'][$j]['value_id'] . "' and pa.options_values_id = poval.products_options_values_id and popt.language_id = '" . $languages_id . "' and poval.language_id = '" . $languages_id . "'");
        }
        $attributes_values = tep_db_fetch_array($attributes);

        $sql_data_array = array('orders_id' => $insert_id, 
                                'orders_products_id' => $order_products_id, 
                                'products_options' => $attributes_values['products_options_name'],
                                'products_options_values' => $attributes_values['products_options_values_name'], 
                                'options_values_price' => $attributes_values['options_values_price'], 
                                'price_prefix' => $attributes_values['price_prefix']);
        tep_db_perform(TABLE_ORDERS_PRODUCTS_ATTRIBUTES, $sql_data_array);

        if ((DOWNLOAD_ENABLED == 'true') && isset($attributes_values['products_attributes_filename']) && tep_not_null($attributes_values['products_attributes_filename'])) {
          $sql_data_array = array('orders_id' => $insert_id, 
                                  'orders_products_id' => $order_products_id, 
                                  'orders_products_filename' => $attributes_values['products_attributes_filename'], 
                                  'download_maxdays' => $attributes_values['products_attributes_maxdays'], 
                                  'download_count' => $attributes_values['products_attributes_maxcount']);
          tep_db_perform(TABLE_ORDERS_PRODUCTS_DOWNLOAD, $sql_data_array);
        }
        $products_ordered_attributes .= "\n\t" . $attributes_values['products_options_name'] . ' ' . $attributes_values['products_options_values_name'];
      }
    }
//------insert customer choosen option eof ----
    $total_weight += ($order->products[$i]['qty'] * $order->products[$i]['weight']);
    $total_tax += tep_calculate_tax($total_products_price, $products_tax) * $order->products[$i]['qty'];
    $total_cost += $total_products_price;

    $products_ordered .= EMAIL_SEPARATOR . "\n" . EMAIL_TEXT_PRODUCTS . '  ' . $order->products[$i]['name'] . "\n";
    if ((KN_CFG_USE_SUBTITLE == 'true') && !empty($order->products[$i]['subtitle'])) {
      $products_ordered .= EMAIL_TEXT_SUBTITLE . '  ' . $order->products[$i]['subtitle'] . "\n";
    }
    if ((KN_CFG_USE_SERIES_TITLE == 'true') && !empty($order->products[$i]['series_title'])) {
      $products_ordered .= EMAIL_TEXT_SERIES_TITLE . '  ' . $order->products[$i]['series_title'] . "\n";
    }
    if ((KN_CFG_USE_AUTHOR == 'true') && !empty($order->products[$i]['author'])) {
      $products_ordered .= EMAIL_TEXT_AUTHOR . '  ' . $order->products[$i]['author'] . "\n";
    }
    if ((KN_CFG_USE_PUBLISHERS == 'true') && !empty($order->products[$i]['publishers'])) {
      $products_ordered .= EMAIL_TEXT_PUBLISHERS . '  ' . $order->products[$i]['publishers'] . "\n";
    }
    if ((KN_CFG_USE_VOLUME == 'true') && !empty($order->products[$i]['volume'])) {
      $products_ordered .= EMAIL_TEXT_VOLUME . '  ' . $order->products[$i]['volume'] . "\n";
    }
    if ((KN_CFG_USE_PUBLISHED == 'true') && !empty($order->products[$i]['published'])) {
      $products_ordered .= EMAIL_TEXT_PUBLISHED . '  ' . $order->products[$i]['published'] . "\n";
    }
    if ((KN_CFG_USE_ISBN == 'true')&& !empty($order->products[$i]['isbn'])) {
      $products_ordered .= EMAIL_TEXT_ISBN . '  ' . $order->products[$i]['isbn'] . "\n";
    }
    $products_ordered .=  EMAIL_TEXT_DESCRIPTION . '   ' . $order->products[$i]['description'] . "\n" . EMAIL_TEXT_MODEL . ' ' . $order->products[$i]['model'] . "\n" . EMAIL_TEXT_PRICE . '   ' . $currencies->display_price($order->products[$i]['final_price'], $order->products[$i]['tax'], $order->products[$i]['qty']) . $products_ordered_attributes . "\n";
  }

// lets start with the email confirmation
// 2003.03.08 Edit Japanese osCommerce
  $email_order = EMAIL_TEXT_AUTO_MAIL . "\n\n";  

  $shop_info_query = tep_db_query("select shop_info_title, shop_info_value, shop_info_value2, allow_tags from " . TABLE_SHOP_INFO . " where shop_info_key = 'SHOP_INFO_EMAIL_AUTO_REPLY'");
  $shop_info = tep_db_fetch_array($shop_info_query);
  $email_subject = $shop_info['shop_info_title'];
  $email_text1 = $shop_info['shop_info_value'];
  $email_text2 = $shop_info['shop_info_value2'];
  $shop_info_query = tep_db_query("select shop_info_value from " . TABLE_SHOP_INFO . " where shop_info_key = 'SHOP_INFO_EMAIL_SIGNATURE'");
  $shop_info = tep_db_fetch_array($shop_info_query);
  $email_signature = $shop_info['shop_info_value'];

  $email_order .= (($language == 'japanese') ? STORE_NAME . $email_text1 : STORE_NAME) . "\n\n" . 
                 EMAIL_TEXT_ORDER_NUMBER . ' ' . $insert_id . "\n" .
                 EMAIL_TEXT_DATE_ORDERED . ' ' . strftime(DATE_FORMAT_LONG) . "\n";

  $email_order .= $products_ordered . 
                  EMAIL_SEPARATOR . "\n";

  for ($i=0, $n=sizeof($order_totals); $i<$n; $i++) {
    if ($order_totals[$i]['code'] == 'ot_discount') { continue; }
    if ($order_totals[$i]['code'] == 'ot_addition') { continue; }
    $email_order .= strip_tags($order_totals[$i]['title']) . ' ' . strip_tags($order_totals[$i]['text']) . "\n";
  }
  if ($comments) {
    $email_order .= "\n" . EMAIL_TEXT_COMMENT . "\n" .
                  EMAIL_SEPARATOR . "\n" .
                  tep_db_output($comments) . "\n";
  }
  
  $email_order .= "\n";
  
  if (KN_CFG_MAIL_PRIVACY_DISPLAY == 'true') {
    $email_order .= "\n" . EMAIL_TEXT_CUSTOMER . "\n" . EMAIL_SEPARATOR . "\n";
    $email_order .= EMAIL_TEXT_CUSTOMER_NAME . '  ' . tep_get_fullname($order->customer['firstname'],$order->customer['lastname']);
    if ((KN_CFG_ACCOUNT_NAME_KANA == 'true') && ($language == 'japanese')) {
      $email_order .=  '' . $order->customer['lastname_kana'] . ' ' . $order->customer['firstname_kana'] . "\n";
    } else {
      $email_order .=  "\n";
    }
    $email_order .= EMAIL_TEXT_CUSTOMER_EMAIL_ADDRESS . '  ' . $order->customer['email_address'] . "\n";
    $email_order .= "\n" . EMAIL_TEXT_DELIVERY_ADDRESS . "\n" . 
                    EMAIL_SEPARATOR . "\n" .
                    tep_address_label($customer_id, $sendto, 0, '', "\n") . "\n";

    $email_order .= "\n" . EMAIL_TEXT_BILLING_ADDRESS . "\n" .
                    EMAIL_SEPARATOR . "\n" .
                    tep_address_label($customer_id, $billto, 0, '', "\n") . "\n";

    if ((KN_CFG_SHORT_CHECKOUT == 'false') && (is_object($$payment))) {
      $email_order .= EMAIL_TEXT_PAYMENT_METHOD . "\n" . 
                      EMAIL_SEPARATOR . "\n";
      $payment_class = $$payment;
      $email_order .= $payment_class->title . "\n";
      if ($payment_class->email_footer) { 
        $email_order .= $payment_class->email_footer . "\n\n";
      }
    } else {
      $email_order .= "\n\n";
    }
  } else {
    $email_order .= EMAIL_TEXT_INVOICE_URL . ' ' . tep_href_link(FILENAME_ACCOUNT_HISTORY_INFO, 'order_id=' . $insert_id, 'SSL', false) . "\n\n";
  }

  if ($email_text2) {
    $email_order .= $email_text2 . "\n\n";
  }
  
  $email_order .= $email_signature;
  
  tep_mail(tep_get_fullname($order->customer['firstname'],$order->customer['lastname']), $order->customer['email_address'], $email_subject, nl2br($email_order), STORE_OWNER, STORE_OWNER_EMAIL_ADDRESS, '');

// send emails to other people
  if (SEND_EXTRA_ORDER_EMAILS_TO != '') {
    tep_mail('', SEND_EXTRA_ORDER_EMAILS_TO, $email_subject, nl2br($email_order), tep_get_fullname($order->customer['firstname'],$order->customer['lastname']) . EMAIL_HONORIFIC, $order->customer['email_address'], '');
  }

// load the after_process function from the payment modules
  $payment_modules->after_process();

  $cart->reset(true);

// unregister session variables used during checkout
  tep_session_unregister('sendto');
  tep_session_unregister('billto');
  tep_session_unregister('shipping');
  tep_session_unregister('payment');
  tep_session_unregister('comments');

  tep_redirect(tep_href_link(FILENAME_CHECKOUT_SUCCESS, '', 'SSL'));

  require(DIR_WS_INCLUDES . 'application_bottom.php');
?>