/***************************************************************************
                          docTables.h  -  description
                             -------------------
    begin                :   2 22 2003
    copyright            : (C) 2003 by K.Kobayashi
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#ifndef DOCTABLES_H
#define DOCTABLES_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// include files for Qt

// include files for KDE

// forward declaration
#ifdef CRON_DILLON
enum DATATYPE { CRON, ANACRON, AT };
#else
enum DATATYPE { CRON, ANACRON, AT, CRON_LOG, ANACRON_LOG, AT_LOG };
enum CRONTYPE { CRON_USER, CRON_ETC };
#endif

#define EDIT_MODIFY  0x01
#define EDIT_CREATE  0x02
#define EDIT_DELETE  0x04
#define EDIT_NEW     0x08
#define EDIT_CURRENT 0x10
#define NO_EXEDISP   0x20
#define NO_DATA      0x40

/**
  * Variable Table
  */
class VarTbl
{
  public:
    /** Constructor */
    VarTbl( const QString& str, const QString& comment);
    VarTbl( const QString& name, const QString& value, const QString& comment);

    /** Data Members */
//    int       Flag;         // Update Flag
    QString   Name;         // Valuable Name
    QString   Val;          // Value
    QString   Cmnt;         // Comment
    
};

/**
  * User Table ( cron, anacron )
  */
class UserTbl
{
  public:
    /** Constructor */
    UserTbl( DATATYPE t, const QString& usr, const QString& head,
                QPtrList<VarTbl>* v );
    ~UserTbl();

    /** Data Members */
    int       Flag;         // Update Flag
    DATATYPE  dType;        // Data Type
    QString   User;         // User Name
    QString   Head;         // Headder Comment
    QPtrList<VarTbl> *Vars; // Variable
    int       itemCnt;      // Task Count
    int       exeCnt;       // Execute Count

};

/**
  * 'cron' Table
  */
class CronTbl
{
  public:

    /** Constructor */
    CronTbl() {};
    CronTbl( const QString& usr, const QString& str, const QString& comment,
              UserTbl* e );
    ~CronTbl();

    /** Data Members */
    int       Flag;         // Update Flag
#ifndef CRON_DILLON
    CRONTYPE  cronType;     // Data type: 0=user 1=/etc/cronab
#endif
    QString   User;         // User Name
    QString   Time;         // Time Format
    QString   Cmnd;         // Command
    QString   Cmnt;         // Comment
    UserTbl *userTbl;       // Valuables
    int       exeCnt;       // Execute Count

};

/**
  * 'anacron' Table
  */
class AnacTbl
{
  public:
    /** Constructor */
    AnacTbl() {};
    AnacTbl( const QString& str, const QString& comment,
               UserTbl* e, bool newFlag=FALSE );

    /** Data Members */
    int       Flag;         // Update Flag
    short     Prod;         // Period
    short     Dlay;         // Delay
    QString   Idnt;         // Identifier
    QString   Cmnd;         // Command
    QString   Cmnt;         // Comment
    QDateTime Mtim;         // Last Modified
    UserTbl  *userTbl;      // Valuables
    int      exeCnt;        // Execute Count
};

/**
  * 'at' Table
  */
class AtTbl
{
  public:
    /** Constructor */
    AtTbl() {};
    AtTbl( const QString& str );

    /** Data Members */
    int       Flag;       // Update Flag
    short     Jno;        // Job No.
    char      Qno;        // Queue No. a-z,A-Z
    QDateTime Time;       // Time Format (HH:MM MM/DD/YY)
    QString   User;       // User name
    QString   Cmnd;       // Command
    short     Mail;       // Send Mail 0=not send 1=send
    int       exeCnt;     // Execute Count
};

#ifndef CRON_DILLON
/**
  * Log Table
  */
class LogTbl
{
  public:
    /** Constructor */
    LogTbl(  const QString &str, const QString &prog, const QDate& mt );

    /** Destructor */
    ~LogTbl();

    /** Convert Month */
    int cnvMonth( const QString &s );
  
    /** Data Members */
    DATATYPE  dType; // Data Type
    QDateTime Time;
    int       Pid;
    QString   Prog;
    QString   Host;
    QString   User;
    QString   LogStr;
    bool      flg;          // Static Counter Flag

};

#endif
/**
  * 'cron' 64 BIT Flag
  */
class BitLL
{
  public:
    /** Constructor */
    BitLL() { bitLL = 0LL; };
    ~BitLL() {};

    /** Initialize from 'cron' Time String */
    void fromString( const QString& str, bool shift=false );

    /** Get 'cron' TIme String */
    
    QString toString( bool shift=false );

    /** Make 'cron' String */
    void addString( QString* str, int base, int intv, int num, bool shift );

    /** Check All Bit ON/OFF */
    inline bool isFill( bool b )
        {
          if ( b ) return ( bitLL == 0xffffffffffffffffLL );
          else     return ( bitLL == 0LL );
        }

    /** Set All Bit ON/OFF */
    inline void fill( bool b )
        {
          if ( b ) bitLL = 0xffffffffffffffffLL;
          else     bitLL = 0LL;
        }

    /** Set Bit */
    inline void bSet( int pos )
        {
          bitLL  = bitLL | ( 1LL << pos );
        }


    /** Test Bit */
    inline bool bTest( int pos )
        {
          if ( bitLL & ( 1LL << pos ) ) return true;
          else                          return false;
        }

    /** Test Bits Upper (pos) */
    inline bool bNext( int pos )
        {
          if ( bitLL & ( 0xffffffffffffffffLL << pos ) ) return true;
          else                                           return false;
        }

    /** Text 0 Bit */
    inline bool is0()
        {
          if ( bitLL == 0x01LL ) return true; else return false;
        }

    /** Bit Data */
    unsigned long long bitLL;

};

/**
  * Cron Bit Data
  */
class CronBit
{

  public:
  
    /** Constructor */
    CronBit() {}

    enum UPTIME { UP_MON, UP_DAY, UP_HOUR, UP_MIN  };

    /** Convert Week Literal/Num */
    QString convWeek( const QString& str, int flg );
    
    /** Convert Month Literal/Num */
    QString convMonth( const QString& str, int flg );

    /** Initialize from String */
    void fromString( const QString& str );

    /** Get 'cron' Time String */
    QString toString();

    /** Increment Time */
    void UpTime ( UPTIME u, QDateTime *t );

    /* Get Next Time */
    QDateTime  GetNextTime( const QDateTime& t );

    /* 'cron' Bit Data */
    BitLL Min;          // Minute
    BitLL Hour;         // Hour
    BitLL Day;          // Day
    BitLL Month;        // Month
    BitLL Week;         // Week

};

/**
  * 'cron' 'anacron' Get Next Time
  */
class CronTime
{
  public:
    /** Constructor */
    CronTime( CronTbl *cr);     // from 'cron'
    CronTime( AnacTbl *an);     // from 'anacron'
    CronTime( AtTbl *at);     // from 'anacron'

    /** Get Next Time */
    QDateTime  GetNextTime( const QDateTime& t );

    /** Get Tables */
    inline CronTbl* cronTbl() { return (CronTbl *)TblPtr; }
    inline AnacTbl* anacTbl() { return (AnacTbl *)TblPtr; }
    inline AtTbl* atTbl() { return (AtTbl *)TblPtr; }

    /** Data Type */
    DATATYPE dType;
    
    /** Table(cron,anacron) Pointer */
    void *TblPtr;

    // for 'cron'
    CronBit cronBit;

};

#endif // DOCTABLES_H
