/***************************************************************************
                          exeDlg.cpp  -  description
                             -------------------
    begin                :   2 22 2003
    copyright            : (C) 2003 by K.Kobayashi
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
//using namespace std;
//#include <iostream>
#include <string.h>
#include <sys/stat.h>

// include files for Qt
#include <qdatetime.h>
#include <qlistview.h>
#include <qfile.h>
#include <qlabel.h>
#include <qpushbutton.h>
#include <qbuttongroup.h>
#include <qcombobox.h>
#include <qtextedit.h>
#include <qlayout.h>
#include <qregexp.h>
#include <qsplitter.h>
#include <qlabel.h>

// include files for KDE
#include <klocale.h>
#include <ktempfile.h>

// application specific includes
#include "system.h"
#include "docTables.h"
#include "commonWgt.h"
#include "exeDlg.h"


/////////////////////////////////////////////////////////////////////////////
//
// ExeDlg - Execute Dialog

//
// Constructor - 'cron'
//
ExeDlg::ExeDlg( CronTbl* cr ) :
  KDialog()
{

  // User Environment Table
  userTbl = cr->userTbl;

  // Change UID,GID, if user = root
  QString user = System::uName();
  if ( cr->User != user ){
    System::setUid( cr->User );
  }

  //
  // Extract Input String ( istr )
  QString c_str;
  QString s = cr->Cmnd;
  s.replace( QRegExp( "%" ), "\n" );
  s.replace( QRegExp( "\\\\\\n" ), "%" );
  int n = s.contains( '\n' );
  inpStr = "";
  if ( n > 0 ){
    c_str = s.section( '\n', 0, 0 );
    inpStr = s.section( '\n', 1 ) + '\n' + '\0';
//cout << "command = " << c_str << endl;
//cout << "input   = " << inpStr << endl;
  }else{
    c_str = s;
  }

  // Clear All Environment Variable
  clearEnv();

  // Shell
  QString shell = getUserVar( "SHELL" );
  if ( shell == "" ) shell = "/bin/sh";

  // Initialize Display and Create Process
  initDialog( shell );

  // Command
  *process << c_str;

  // set Process Environment
  for( VarTbl* v=userTbl->Vars->first(); v; v=userTbl->Vars->next() ){
    process->setEnvironment( v->Name, v->Val );
  }

  if ( getUserVar( "SHELL" ) == "" ){
    process->setEnvironment( "SHELL", shell );
  }
  if ( getUserVar( "PATH" ) == "" ){
#ifdef CRON_DILLON
    process->setEnvironment( "PATH", "/usr/local/sbin:/sbin:/bin:/usr/sbin:/usr/bin" );
#else
    process->setEnvironment( "PATH", "/usr/bin:/bin" );
#endif
  }
  if ( getUserVar( "USESR" ) == "" ){
    process->setEnvironment( "USER", cr->User );
  }
  if ( getUserVar( "LOGNAME" ) == "" ){
    process->setEnvironment( "LOGNAME", cr->User );
  }
  QString home = getUserVar( "HOME" );
  if ( home == "" ){
    home = System::uHome();
    process->setEnvironment( "HOME", home );
  }
#ifdef CRON_DILLON
  process->setEnvironment( "PWD", hom2 );
  porcess->setEnvironment( "CONSOLE", "/dev/console" );
  process->setEnvironment( "TERM", "linux" );
#endif
  // set Process Home Directory
  process->setWorkingDirectory( home );

  // Initilaize Clock & Time
  sTime = QTime::currentTime();
  System::iniClock();
  
  // Process Start
  process->start( KProcess::NotifyOnExit, KProcess::All );

  // Write Stdin
  if ( inpStr != "" ){
    if ( process->writeStdin( inpStr, inpStr.length() ) == false ){
//      cout << "writeStdin() Error " << endl;
    }
//      cout << "writeStdin() " << endl;
    process->closeStdin();
  }

  // Restore Cleared Environment
  restoreEnv();

  // Reset UID/GID
  if ( cr->User != user ){
    System::setUid( user );
  }

    
}

//
// Constructor - 'anacron'
//
ExeDlg::ExeDlg( AnacTbl* an, int flg ) :
  KDialog()
{

  // User Environment Table
  userTbl = an->userTbl;

  // Initialize Display and Create Process
  initDialog( "/bin/sh" );
  if ( flg ){
    // 1: Do Command
    *process << an->Cmnd;
  }else{
    // 0: Update Timestamp
    *process << System::getCommand( "anacron" ) + " -u " +  an->Idnt;
  }

  if ( flg ){
    // Set Environment
    clearEnv();
    for( VarTbl* v=userTbl->Vars->first(); v; v=userTbl->Vars->next() ){
      process->setEnvironment( v->Name, v->Val );
    }
    // Set Home Directory
    process->setWorkingDirectory( "/" );
  }

  // Initilaize Clock & Time
  sTime = QTime::currentTime();
  System::iniClock();

  // Process Start
  process->start( KProcess::NotifyOnExit, KProcess::AllOutput );

  // Restore Environment
  if ( flg ) restoreEnv();

}

//
// Constructor - 'at'
//
ExeDlg::ExeDlg( AtTbl* at ) :
  KDialog()
{


  // Initialize Environment Restore Buffer
  env = new char*[10];
  memset( env, 0, sizeof(char*)*10 );

  // unset Environment
  unsetEnv( "DISPLAY" );
  unsetEnv( "TERM" );
  unsetEnv( "_" );
  unsetEnv( "SHELLOPT" );
  
  // Initialize Display and Create Process
  initDialog( "/bin/sh" );

  // Create Command File
  tempFile = new KTempFile();
  tempFile->setAutoDelete( false );

  *tempFile->textStream() << "#/bin/sh\n";
  *tempFile->textStream() << at->Cmnd;        // use a text stream
  tempFile->close();
  chmod( tempFile->name(), 06777 );

  // Set Command
  *process << tempFile->name();

  // Set Working Directory
  process->setWorkingDirectory( "/" );

  // Change UID,GID, if user = root
  QString user = System::uName();
  if ( at->User != user ){
    System::setUid( at->User );
  }

  // Initilaize Clock & Time
  sTime = QTime::currentTime();
  System::iniClock();

  // Process Start
  process->start( KProcess::NotifyOnExit, KProcess::AllOutput );

  // Restore Environment
  restoreEnv();

  // Reset UID/GID
  if ( at->User != user ){
    System::setUid( user );
  }

}

//
// Destructor
//
ExeDlg::~ExeDlg() {}

//
// Initialize Display
//
void ExeDlg::initDialog( const QString& shell )
{

  QVBoxLayout* v = new QVBoxLayout( this, marginHint(), spacingHint() );
  {
    // Output Text View
    QSplitter* sp = new QSplitter(Qt::Vertical,this);
    {
      // Stdout
      CGroupBox* g = new CGroupBox( i18n("stdout"), sp );
      QVBoxLayout* v1 = new QVBoxLayout( g->layout() );
      outEdit = new QTextEdit( g );
      outEdit->setMinimumSize( QSize(550, 100) );
      outEdit->setWordWrap( QTextEdit::NoWrap );
      outEdit->setSizePolicy( QSizePolicy( QSizePolicy::Minimum, QSizePolicy::Ignored ) );
      outEdit->setReadOnly(true);
      v1->addWidget( outEdit );
    }
    {
      // Stderr
      CGroupBox* g = new CGroupBox( i18n("stderr"), sp );
      QVBoxLayout* v1 = new QVBoxLayout( g->layout() );
      errEdit = new QTextEdit( g );
      errEdit->setMinimumSize( QSize(550, 40) );
      errEdit->setReadOnly(true);
      errEdit->setSizePolicy( QSizePolicy( QSizePolicy::Minimum, QSizePolicy::Ignored ) );
      errEdit->setColor( "red" );
      errEdit->setItalic( true );
      v1->addWidget( errEdit );
    }
    v->addWidget( sp );
  }
    {
      // Execute Time
      CGroupBox* g = new CGroupBox( i18n( "Execute Time" ), this );
      v->addWidget( g );
      QHBoxLayout* h = new QHBoxLayout( g->layout(), 5 );
      h->addWidget( new QLabel( i18n( "Processor Time" ), g ) );
      clockLbl = new FrameLabel( "      ", g );
      clockLbl->setFixedHeight( 25 );
      h->addWidget( clockLbl );
      h->addStretch( 1 );
      h->addWidget( new QLabel( i18n( "Execute Time" ), g ) );
      timeLbl = new FrameLabel( "      ", g );
      h->addWidget( timeLbl );
      h->addStretch( 1 );
    }
  {
    // KILL/OK Buttons
    QHBoxLayout* h = new QHBoxLayout( v, 5 );
    h->addStretch( 1 );
    killBtn = new QPushButton( i18n("&KILL"), this );
    h->addWidget( killBtn );
    QObject::connect( killBtn, SIGNAL( clicked() ),
                    this, SLOT( slotKill() ) );

    okBtn = new QPushButton( i18n("&OK"), this );
    okBtn->setDefault( true );
    okBtn->setEnabled( false );
    h->addWidget( okBtn );
    QObject::connect( okBtn, SIGNAL( clicked() ),
                    this, SLOT( accept() ) );

  }
  setCaption( i18n("Test Execute") );
  tempFile = NULL;

  // Create Process
  process = new KShellProcess( shell );
  connect( process, SIGNAL(receivedStdout(KProcess*,char*,int)), this, SLOT(slotStdout(KProcess*,char*,int)));
  connect( process, SIGNAL(receivedStderr(KProcess*,char*,int)), this, SLOT(slotStderr(KProcess*,char*,int)));
  connect( process, SIGNAL(processExited(KProcess*)), this, SLOT(slotExit(KProcess*)));

}

//
// Get 'cron/anacron' Environment Variable fron Name
//
QString ExeDlg::getUserVar( const QString& name )
{
  QString s = "";
  for( VarTbl* v=userTbl->Vars->first(); v; v=userTbl->Vars->next() ){
    if ( name == v->Name ){
      s = v->Val;
      break;
    }
  }
  return s;
}

//
// Clear Current Environment
//
void ExeDlg::clearEnv()
{

  // Count Number
  int i = 0;
  for( i=0; __environ[i] != NULL; i++ );

  // Create Restore Buffer
  env = new char*[i+1];

  // Save Environments
  for( i=0; __environ[i] != NULL; i++ ){
    env[i] = strdup( __environ[i] );
  }
  env[i] = NULL;        // Last

  // Clear All Current Environments
  clearenv();

}

//
// Clear Environment by Name
//
void ExeDlg::unsetEnv( const QString& name )
{

  QString str;
  char *s = getenv( name );
  if ( s ){
    // Restore Environment
    for( int i=0; i < 10; i++ ){
      if ( env[i] == NULL ){
        str = name + " = " + (char*)s;
        env[i] = strdup( str );
        break;
      }
    }
    // unset Environmet
    unsetenv( name );
  }

}

//
// Restore Cleared Environment
//
void ExeDlg::restoreEnv()
{

  for( int i=0; env[i] != NULL; i++ ){
    putenv( env[i] );
  }
  free( env );
}       


//
//---SLOTS-------------------------------------------------------------------

//
// Stdout : insert Output Text View
//
void ExeDlg::slotStdout(KProcess* ,char* s, int n)
{
  outEdit->insert( QString().fromLocal8Bit((const char*)s,n) );
}

//
// Stderr : insert Error Text View
//
void ExeDlg::slotStderr(KProcess* ,char* s, int n)
{
  errEdit->insert( QString().fromLocal8Bit((const char*)s,n) );
}

//
// Exit : Process Exit Callback
//
void ExeDlg::slotExit(KProcess* p)
{
  // Enable OK Button
  okBtn->setEnabled( true );

  // Disable KILL Button
  killBtn->setEnabled( false );

  // Output Result
  outEdit->setItalic( true );
  if ( p->exitStatus() == 0 ){
    outEdit->setColor( "blue" );
    outEdit->insert( i18n("-- Normal Exit --\n") );
  }else{
    outEdit->setColor( "red" );
    outEdit->insert( QString( i18n("-- Exit Code = %1 --\n") ).arg(p->exitStatus()) );
  }

  // if temp file exists (at), delete that
  if ( tempFile != NULL ){
    delete tempFile;
  }

  int cmsec = System::getClock();
  int emsec = sTime.msecsTo( QTime::currentTime() );
  clockLbl->setText( QString().sprintf( "%d.%03d sec", cmsec/1000, cmsec%1000 ) );
  timeLbl->setText( QString().sprintf( "%d.%03d sec", emsec/1000, emsec%1000 ) );
}

//
// KILL Action : Process KILL
//
void ExeDlg::slotKill()
{
  process->kill();
}

