/***************************************************************************
                          kroneconfig.h  -  description
                             -------------------
    begin                :   2 8 2003
    copyright            : (C) 2003 by kobayashi
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KRONECONFIG_H
#define KRONEKONFIG_H
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <sys/syslog.h>

/** Program search PATH: for 'crontab', 'at', 'anacrontab'
 * use if Environment 'PATH' not found the program.
*/
#define PSEARCH_PATH "/bin:/usr/bin:/sbin:/usr/sbin:/usr/local/bin:/usr/local/sbin"

/** Log Default Path
*/
#ifdef CRONLOG_FILE
#define LOG_PATH    CRONLOG_FILE
#else
#ifdef CRON_DEBIAN
#define LOG_PATH    "/var/log/syslog"
#else
#ifdef LOG_CRON
#define LOG_PATH    "/var/log/cron"
#else
#define LOG_PATH    "/var/log/daemon"
#endif
#endif
#endif

/** 'at -l' command extract command lines from 'regexp'string
*/
#define AT_COMMAND_DELIM  "\ncd*{\n*echo*\n*exit*\n}\n"

/** Extract "Mail on/off" line
*/
#define AT_MAIL_LINE      "#\\s+mail\\s+\\S+\\s+\\d"


/** Version lines from 'crontab -l' output
 *| # DO NOT EDIT THIS FILE - edit the master and reinstall.
 *| # (/tmp/kde-root/cronclock6QIDFb.tmp installed on Sat Feb  8 00:34:15 2003)
 *| # (Cron version -- $Id: kroneconfig.h,v 1.5 2003/04/25 05:12:19 kroneko Exp $)
*/
#ifdef CRON_DEBIAN
#define CRON_VERLINES       3
#define CRON_VER            "CRONTAB_NOHEADER=N "
#else
#define CRON_VERLINES       3
#define CRON_VER            ""
#endif
#define CRON_VERLINE_START  2
#define CRON_VERLINE_END    2

/** Version extract line from command:'anacrontab -V' command
 *| Anacron 2.3
 *| Copyright (C) 1998 Itai Tzur <itzur@actcom.co.il>
 *| Copyright (C) 1999 Sean 'Shaleh' Perry <shaleh@debian.org>
 *|
*/
#define ANAC_VERLINE_START  0
#define ANAC_VERLINE_END    2

/** Version extact lines from command:'at -V' 
 *|  at version 3.1.8
 *|  Bug report to: ig25@rz.uni-karlsrrche.de (Thomas Koenig)
 *|  Garbled time 
*/
#define AT_VERLINE_START    0
#define AT_VERLINE_END      1


#endif // KRONECONFIG_H
