/***************************************************************************
                          kronekoview.cpp  -  description
                             -------------------
    begin                :   2  8 00:43:28 JST 2003
    copyright            : (C) 2003 by kobayashi
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

// include files for Qt
#include <qlayout.h>
#include <qtabwidget.h>
#include <qlistview.h>
#include <qsplitter.h>


// include files for KDE
#include <klocale.h>

// application specific includes
#include "system.h"  
#include "option.h"
#include "docTables.h"
#include "kroneko.h"
#include "listTabs.h"
#include "viewTabs.h"
#include "kronekoview.h"
#include "kronekodoc.h"

extern Option*    g_Option;
extern bool       g_ViewMode;

/////////////////////////////////////////////////////////////////////////////
// KronekoView - View Class

//
// Constructor
KronekoView::KronekoView(QWidget *parent, const char *name) : QWidget(parent, name)
{
//  setBackgroundMode(PaletteBase);

  QHBoxLayout *l = new QHBoxLayout( this );
  QSplitter* sp = new QSplitter(Qt::Horizontal,this);

  // List Tab Widget
  listTab = new QTabWidget( sp );
  {
    // setting list view
    stngLvw = new StngLvw();
    listTab->insertTab( stngLvw, IconFile("listicon"), i18n( "Task List" ) );

    // Execute time list view
    execLvw = new ExecLvw();
    listTab->insertTab( execLvw, IconFile("listicon"), i18n( "Execute List" ) );

#ifndef CRON_DILLON
    // Log list view
    logLvw = new LogLvw();
    if ( System::access( g_Option->logFile ) & CAN_READ  ){
      listTab->insertTab( logLvw, IconFile("listicon"), i18n( "Log List" ) );
      logListEnable = true;
    }else{
      logListEnable = false;
    }
#endif

  }
  // View Tab Widget
  viewTab = new QTabWidget( sp );
  {
    // Clock view
    clockWgt = new ClockWgt();
    viewTab->insertTab( clockWgt,  IconFile("clockicon"), i18n("Clock") );

    // Detail view
    detailWgt = new DetailWgt();
    viewTab->insertTab( detailWgt, IconFile("detailicon"), i18n("Detail") );

    if ( ! g_ViewMode ){
      // 'crontab' edit view
      cronEditWgt = new CronEditWgt();
      viewTab->insertTab( cronEditWgt, IconFile("cronedit"), "Cron" );

      // 'anacron' edit view
      if ( System::isAnacWritable() ){
        anacEditWgt = new AnacEditWgt();
        if ( g_Option->useAnacron ){
          viewTab->insertTab( anacEditWgt, IconFile("anacedit"),  "Anacron" );
        }
      }

      // 'at' edit view
      atEditWgt = new AtEditWgt();
      if ( System::atEnable() ){
        viewTab->insertTab( atEditWgt, IconFile("atedit"), "aT" );
      }
    }

  }
  viewTab->setMinimumWidth( 300 );
  viewTab->setMaximumWidth( 455 );
  l->addWidget( sp );
  
}
