/***************************************************************************
                          listTabs.h  -  description
                             -------------------
    begin                :   2 21 2003
    copyright            : (C) 2003 by K.Kobayashi
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#ifndef LISTTABS_H
#define LISTTABS_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// include files for Qt

// include files for KDE

// forward declaration
//class CronTbl;
//class AnacTbl;
//class AtTbl;

/**
  * Common ListViewItem for List TAB
  * used by StngLvw, ExecLvw, LogLvw
  */
class TabLvi : public QListViewItem
{

  public:
    /** Constructor fron 'cron' Table */
    TabLvi( QListView *p, CronTbl *cr, const QDateTime& next )
      : QListViewItem(p), dType(CRON), Next(next), TblPtr((void*)cr) {}
    /** Constructor fron 'anacron' Table */
    TabLvi( QListView *p, AnacTbl *an, const QDateTime& next )
      : QListViewItem( p ), dType( ANACRON ), Next( next ), TblPtr((void*)an) {}
    /** Constructor fron 'at' Table */
    TabLvi( QListView *p, AtTbl   *at )
      : QListViewItem( p ), dType( AT ), Next( at->Time ), TblPtr((void*)at) {}
#ifndef CRON_DILLON
    /** Constructor fron Log Table */
    TabLvi( QListView *p, LogTbl  *log )
      : QListViewItem( p ), dType( log->dType ), Next( log->Time ), TblPtr((void*)log) {}
#endif
    /** Destructor */
    ~TabLvi();

    /** Compare !QDateTime */
    int compare( QListViewItem * i, int col, bool ascending ) const;

    /** Get Table Pointer */
    inline CronTbl* cronTbl() { return (CronTbl*)TblPtr; }
    inline AnacTbl* anacTbl() { return (AnacTbl*)TblPtr; }                                       
    inline AtTbl*   atTbl()   { return (AtTbl*)TblPtr;   }
#ifndef CRON_DILLON
    inline LogTbl*  logTbl()  { return (LogTbl*)TblPtr;  }
#endif
    
    /** Data Type CRON/ANACRON/AT/LOG_CRON/LOG_ANACRON */  
    DATATYPE    dType;
    /** Item Time */
    QDateTime   Next;
    /** Table Pointer */
    void *TblPtr;

};


/**
  * Common ListView for List TAB
  * Inherited by StngLvw, ExecLvw, LogLvw
  */
class TabLvw : public QListView
{
  public:
    /** Constructor */
    TabLvw();
    /** Destructor */
    ~TabLvw() {}

    /** Get Pixmap */
    QPixmap* compPixmap( const QPixmap& p1, const QPixmap& p2 );
    const QPixmap pixmap(DATATYPE t, int f = 0);
};

/**
  * Setting List View
  */
class StngLvw : public TabLvw
{
  public:
    /** Constructor */
    StngLvw();
    /** Destructor */
    ~StngLvw() {}

    /** Add 'cron' Table */
    TabLvi *addItem ( CronTbl *cr, const QDateTime& next );
    /** Add 'anacron' Table */
    TabLvi *addItem ( AnacTbl *an, const QDateTime& next );
    /** Add 'at' Table */
    TabLvi *addItem ( AtTbl   *at );
    /** Get ListViewItem from Table Pointer */
    TabLvi *getItem ( void* ptr );
    /** Change All Lines Pixmap from Flag */
    void resetFlag();

};

/**
  * Execute List View
  */
class ExecLvw : public TabLvw
{
  public:
    /** Constructor */
    ExecLvw();
    /** Destructor */
    ~ExecLvw() {}

    /** Add 'cron' Table */
    void addItem ( CronTbl *cr, const QDateTime& next );
    /** Add 'anacron' Table */
    void addItem ( AnacTbl *an, const QDateTime& next );
    /** Add 'at' Table */
    void addItem ( AtTbl *at );
    /** Change All Lines Pixmap from Flag */
    void resetFlag();

};

#ifndef CRON_DILLON

/**
  * Log List View
  */
class LogLvw : public TabLvw
{
  public:
    /** Constructor */
    LogLvw();
    /** Destructor */
    ~LogLvw() {}

    /** Add Log */
    void addItem ( LogTbl *log );

};
#endif

#endif // LISTTABS_H
