/***************************************************************************
                          timeDlg.cpp  -  description
                             -------------------
    begin                :   2 22 2003
    copyright            : (C) 2003 by K.Kobayashi
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
//using namespace std;
//#include <iostream>

// include files for Qt
#include <qdatetime.h>
#include <qlistview.h>
#include <qfile.h>
#include <qpushbutton.h>
#include <qbuttongroup.h>
#include <qcombobox.h>
#include <qlabel.h>
#include <qdatetimeedit.h>
#include <qlayout.h>
#include <qptrlist.h>
#include <qpainter.h>

// include files for KDE
#include <klocale.h>

// application specific includes
#include "option.h"
#include "docTables.h"
#include "commonWgt.h"
#include "timeDlg.h"

extern Option*    g_Option;
extern QDateTime* g_CurTime;        // current time

const int Space = KDialog::spacingHint();
const int SpaceT = KDialog::spacingHint() * 3;

/////////////////////////////////////////////////////////////////////////////
// Time Button - Toggle Time Button Class

//
// Constructor - String
TimeButton::TimeButton( QWidget* w, const QString& s ) :
  QPushButton( w )
{
  setToggleButton( true );
  setText( s );
}

//
// Constructor - Number
TimeButton::TimeButton( QWidget* w, int i ) :
  QPushButton( w )
{
  setToggleButton( true );
  setText( QString().setNum(i) );
  setFixedSize( 27, 27 );
}

//
// Change Toggled Color
void TimeButton::drawButton( QPainter *p )
{
  if ( isOn() ){
    setBackgroundMode( PaletteMidlight );
    setPaletteBackgroundColor( QColor( 255, 255, 220 ) );
  }else{
    setBackgroundMode( PaletteMidlight );
    setPaletteBackgroundColor( colorGroup().midlight() );
  }
  QPushButton::drawButton(p);
}

/////////////////////////////////////////////////////////////////////////////
// CronTimeDlg - 'cron' Time Edit Dialog

//
// Constructor
CronTimeDlg::CronTimeDlg( const QString& tstr ) :
  KDialog()
{

  /** Initialize 'cron' Time Convert class */
  cronBit = new CronBit();
  cronBit->fromString( tstr );

  QButtonGroup *g;
  QGridLayout  *gl;
  int i;

  QVBoxLayout* v = new QVBoxLayout( this, marginHint(), Space );
  {
    // Time Label
    QHBoxLayout* h = new QHBoxLayout( v, 5 );
    QLabel* l = new QLabel( i18n("Time"), this );
    h->addWidget( l );
    l->setFixedWidth( 50 );
    timeLbl = new FrameLabel( tstr, this );
    h->addWidget( timeLbl );
  }
  {
    QHBoxLayout* h = new QHBoxLayout( v, 5 );
    {
      // Minute Button Group
      g = new QButtonGroup( i18n("Minutes"), this );
      h->addWidget( g );
      gl = new QGridLayout( g, 8, 12, 0, 0 );
      gl->addRowSpacing( 0, SpaceT );
      gl->addColSpacing( 0, Space );
      for( i=0; i<60; i++ ){
        gl->addWidget( new TimeButton( g, i ), i/10+1, i%10+1 );
      }
      gl->addRowSpacing( 7, Space );
      gl->addColSpacing( 11, Space );
      minBgp = g;
      connect( g, SIGNAL( clicked( int ) ), this,
                        SLOT( slotMinuteButtons( int ) ) );
    }
    {
      // Hour Button Group
      g = new QButtonGroup( i18n("Hours"), this );
      h->addWidget( g );
      gl = new QGridLayout( g, 8, 8, 0, 0 );
      gl->addRowSpacing( 0, SpaceT );
      gl->addMultiCellWidget( new QLabel( i18n("AM"), g ), 1, 1, 6, 6 );
      gl->addMultiCellWidget( new QLabel( i18n("PM"), g ), 4, 4, 6, 6 );
      gl->addColSpacing( 0, Space );
      for( i=0; i<24; i++ ){
        gl->addWidget( new TimeButton( g, i ), i/6+2+i/12, i%6+1 );
      }
      gl->addRowSpacing( 7, Space );
      gl->addColSpacing( 7, Space );
      hourBgp = g;
      connect( g, SIGNAL( clicked( int ) ), this,
                        SLOT( slotHourButtons( int ) ) );
    }
    {
      // Day Button Group
      g = new QButtonGroup( i18n("Days of Month"), this );
      h->addWidget( g );
      gl = new QGridLayout( g, 7, 9, 0, 0 );
      gl->addRowSpacing( 0, SpaceT );
      gl->addColSpacing( 0, Space );
      for( i=0; i<31; i++ ){
        gl->addWidget( new TimeButton( g, i+1 ), i/7+1, i%7+1 );
      }
      gl->addRowSpacing( 6, Space );
      gl->addColSpacing( 8, Space );
      dayBgp = g;
      connect( g, SIGNAL( clicked( int ) ), this,
                        SLOT( slotDayButtons( int ) ) );
    }
  }
  {
    QHBoxLayout* h = new QHBoxLayout( v, 5 );
    {
      // Month Button Group
      g = new QButtonGroup( i18n("Months"), this );
      h->addWidget( g );
      QHBoxLayout* gh = new QHBoxLayout( g, 5 );
      QVBoxLayout* gv1 = new QVBoxLayout( gh, Space );
      gv1->addSpacing( SpaceT );
      gv1->addWidget( new TimeButton( g, i18n("Januray(1)") ) );
      gv1->addWidget( new TimeButton( g, i18n("Febrary(2)") ) );
      gv1->addWidget( new TimeButton( g, i18n("March(3)") ) );
      gv1->addWidget( new TimeButton( g, i18n("April(4)") ) );
      gv1->addWidget( new TimeButton( g, i18n("May(5)") ) );
      gv1->addWidget( new TimeButton( g, i18n("Jun(6)") ) );
      QVBoxLayout* gv2 = new QVBoxLayout( gh, Space );
      gv2->addSpacing( SpaceT );
      gv2->addWidget( new TimeButton( g, i18n("July(7)") ) );
      gv2->addWidget( new TimeButton( g, i18n("Auguest(8)") ) );
      gv2->addWidget( new TimeButton( g, i18n("September(9)") ) );
      gv2->addWidget( new TimeButton( g, i18n("October(10)") ) );
      gv2->addWidget( new TimeButton( g, i18n("November(11)") ) );
      gv2->addWidget( new TimeButton( g, i18n("December(12)") ) );
      monBgp = g;
      connect( g, SIGNAL( clicked( int ) ), this,
                        SLOT( slotMonthButtons( int ) ) );
    }
    {
      // Week Button Group
      g = new QButtonGroup( i18n("Weeks"), this );
      g->setFixedWidth( 200 );
      h->addWidget( g );
      QVBoxLayout* gv = new QVBoxLayout( g, Space );
      gv->addSpacing( SpaceT );
      gv->addWidget( new TimeButton( g, i18n("Sunday(0)") ) );
      gv->addWidget( new TimeButton( g, i18n("Monday(1)") ) );
      gv->addWidget( new TimeButton( g, i18n("Thesday(2)") ) );
      gv->addWidget( new TimeButton( g, i18n("Wednesday(3)") ) );
      gv->addWidget( new TimeButton( g, i18n("Thursday(4)") ) );
      gv->addWidget( new TimeButton( g, i18n("Friday(5)") ) );
      gv->addWidget( new TimeButton( g, i18n("Sataday(6)") ) );
      weekBgp = g;
      connect( g, SIGNAL( clicked( int ) ), this,
                        SLOT( slotWeekButtons( int ) ) );
    }
#ifndef CRON_DILLON
    {
      // Simple Button Group
      g = new QButtonGroup( i18n("Simple"), this );
      g->setExclusive( true );
      g->setFixedWidth( 120 );
      h->addWidget( g );
      QVBoxLayout* gv = new QVBoxLayout( g, Space );
      gv->addSpacing( SpaceT );
      gv->addWidget( new TimeButton( g, "Hourly"  ) );
      gv->addWidget( new TimeButton( g, "Daily"  ) );
      gv->addWidget( new TimeButton( g, "Weekly"  ) );
      gv->addWidget( new TimeButton( g, "Monthly"  ) );
      gv->addWidget( new TimeButton( g, "Yearly"  ) );
      gv->addWidget( new TimeButton( g, "Reboot"  ) );
      simpleBgp = g;
      connect( g, SIGNAL( clicked( int ) ), this,
                        SLOT( slotSimpleButtons( int ) ) );
    }
#endif
  }
  {
    // OK/Cancel Button Group
    QHBoxLayout* h = new QHBoxLayout( v, 5 );
    h->addStretch( 1 );
    QPushButton *okbutton = new QPushButton( i18n("&OK"), this );
    okbutton->setDefault( true );
    h->addWidget( okbutton );

    QPushButton *canbutton = new QPushButton( i18n("&Cancel"), this );
    h->addWidget( canbutton );

    connect( okbutton, SIGNAL( clicked() ),
                    this, SLOT( accept() ) );
    connect( canbutton, SIGNAL( clicked() ),
                    this, SLOT( reject() ) );
  }
  setCaption( i18n("Cron Time Setting") );
  iniButton();
#ifndef CRON_DILLON
  iniSimple();
#endif

}

//
// Destructor
CronTimeDlg::~CronTimeDlg()
{
  delete cronBit;
}

//
// Initialize Simple Button
void CronTimeDlg::iniSimple()
{
  // Set All Buttons Off
  for ( int i=0; i<6; i++ ){
    ((QPushButton*)simpleBgp->find(i))->setOn( false );
  }

  // Set On from 'cron' Time
  QString s = getTime();
  int idx = -1;
  if ( s == "@hourly" ) idx = 0;
  else if ( s == "@daily" ) idx=1;
  else if ( s == "@midnight" ) idx=1;
  else if ( s == "@weekly" ) idx=2;
  else if ( s == "@monthly" ) idx=3;
  else if ( s == "@yearly" ) idx=4;
  else if ( s == "@annually" ) idx=4;
  else if ( s == "@reboot" ) idx=5;
  if ( idx >= 0 ) ((QPushButton*)simpleBgp->find(idx))->setOn( true );
}

//
// Initialize Button
void CronTimeDlg::iniButton( )
{

    QPushButton *btn;
    int i;
    for( i=0; i<60; i++ ){
      btn = (QPushButton*)minBgp->find(i);
      if ( ! cronBit->Min.isFill(true) && cronBit->Min.bTest(i) )
            btn->setOn( true );
      else  btn->setOn( false );
    }
    for( i=0; i<24; i++ ){
      btn = (QPushButton*)hourBgp->find(i);
      if ( ! cronBit->Hour.isFill(true) && cronBit->Hour.bTest(i) )
            btn->setOn( true );
      else  btn->setOn( false );
    }
    for( i=0; i<31; i++ ){
      btn = (QPushButton*)dayBgp->find(i);
      if ( ! cronBit->Day.isFill(true) && cronBit->Day.bTest(i) )
            btn->setOn( true );
      else  btn->setOn( false );
    }
    for( i=0; i<12; i++ ){
      btn = (QPushButton*)monBgp->find(i);
      if ( ! cronBit->Month.isFill(true) && cronBit->Month.bTest(i) )
            btn->setOn( true );
      else  btn->setOn( false );
    }
    for( i=0; i<7; i++ ){
      btn = (QPushButton*)weekBgp->find(i);
      if ( ! cronBit->Week.isFill(true) && cronBit->Week.bTest(i) )
            btn->setOn( true );
      else  btn->setOn( false );
    }
}

//
//---------------------------------------------------------------------------

//
// Minute Button Group Action
void CronTimeDlg::slotMinuteButtons( int )
{
  cronBit->Min.fill( false );     // reset
  // Set From Minute Buttons
  int i;
  for( i=0; i<60; i++ ){
    if ( ((QPushButton*)minBgp->find(i))->isOn() ) cronBit->Min.bSet(i);
  }

  // Set 'cron' Time Label
  timeLbl->setText( cronBit->toString() );
#ifndef CRON_DILLON
  iniSimple();
#endif
}

//
// Hour Button Group Action
void CronTimeDlg::slotHourButtons( int )
{
  cronBit->Hour.fill( false );    // reset
  // set From Hour Buttons
  int i;
  for( i=0; i<24; i++ ){
    if ( ((QPushButton*)hourBgp->find(i))->isOn() ) cronBit->Hour.bSet(i);
  }
  if ( cronBit->Hour.isFill(false) ) cronBit->Hour.fill(true);

  // Set 'cron' Time Label
  timeLbl->setText( cronBit->toString() );
#ifndef CRON_DILLON
  iniSimple();
#endif
}

//
// Day Button Group Action
void CronTimeDlg::slotDayButtons( int )
{
  cronBit->Day.fill( false );   // reset
  // set From Day Buttons
  int i;
  for( i=0; i<31; i++ ){
    if ( ((QPushButton*)dayBgp->find(i))->isOn() ) cronBit->Day.bSet(i);
  }
  if ( cronBit->Day.isFill(false) ) cronBit->Day.fill(true);

  // Set 'cron' Time Label
  timeLbl->setText( cronBit->toString() );
#ifndef CRON_DILLON
  iniSimple();
#endif
}

//
// Month Button Group Action
void CronTimeDlg::slotMonthButtons( int )
{
  cronBit->Month.fill( false );   // reset
  // set From Month Buttons
  int i;
  for( i=0; i<12; i++ ){
    if ( ((QPushButton*)monBgp->find(i))->isOn() ) cronBit->Month.bSet(i);
  }
  if ( cronBit->Month.isFill(false) ) cronBit->Month.fill(true);

  // Set 'cron' Time Label
  timeLbl->setText( cronBit->toString() );
#ifndef CRON_DILLON
  iniSimple();
#endif
}

//
// Week Button Group Action
void CronTimeDlg::slotWeekButtons( int )
{
  cronBit->Week.fill( false );    // reset
  // set From Week Buttons
  int i;
  for( i=0; i<7; i++ ){
    if ( ((QPushButton*)weekBgp->find(i))->isOn() ) cronBit->Week.bSet(i);
  }

  // Set 'cron' Time Label
  timeLbl->setText( cronBit->toString() );
#ifndef CRON_DILLON
  iniSimple();
#endif
}

//
// Simple Button Group Action
void CronTimeDlg::slotSimpleButtons( int id )
{

  cronBit->Min.fill( false );
  cronBit->Min.bSet( 0 );
  cronBit->Hour.fill( false );
  cronBit->Day.fill( false );
  cronBit->Month.fill( false );
  cronBit->Week.fill( false );

  QString tstr;
  switch( id ){
    case 0 :
      tstr = "@hourly";
      break;
    case 1 :
      tstr = "@daily";
      cronBit->Hour.bSet( 0 );
      break;
    case 2 :
      tstr = "@weekly";
      cronBit->Hour.bSet( 0 );
      cronBit->Week.bSet( 0 );
      break;
    case 3 :
      tstr = "@monthly";
      cronBit->Hour.bSet( 0 );
      cronBit->Day.bSet( 0 );
      break;
    case 4 :
      tstr = "@yearly";
      cronBit->Hour.bSet( 0 );
      cronBit->Day.bSet( 0 );
      cronBit->Month.bSet( 0 );
      break;
    case 5 :
       tstr = "@reboot";
      if ( g_Option->ponWeekDay ){
        cronBit->Week.fromString("1-5", false );
      }
      cronBit->Hour.bSet( g_Option->ponTime.hour() );
      cronBit->Min.bSet( g_Option->ponTime.minute() );
      
    default :
      break;
  }
  if ( cronBit->Hour.isFill( false ) )  cronBit->Hour.fill( true );
  if ( cronBit->Day.isFill( false ) )   cronBit->Day.fill( true );
  if ( cronBit->Month.isFill( false ) ) cronBit->Month.fill( true );

  iniButton();

  timeLbl->setText( tstr );

}

/////////////////////////////////////////////////////////////////////////////
// AtTimeDlg - 'at' Time Edit Dialog

//
// Constructor
AtTimeDlg::AtTimeDlg( const QDateTime& tm ) :
  KDialog()
{

  setDt = tm;
  QButtonGroup *g;
  QGridLayout  *gl;
  int i, j;
  
  startYear = tm.date().year();

  QVBoxLayout* v = new QVBoxLayout( this, marginHint(), Space );
  {
    // Date Time Edit Widget
    QHBoxLayout* h = new QHBoxLayout( v, 5 );
    QLabel* l = new QLabel( i18n("Time"), this );
    l->setFixedWidth( 50 );
    h->addWidget( l );
    setDte = new QDateTimeEdit( tm, this );
    setDte->dateEdit()->setMinValue( QDate( g_CurTime->date().year(), 1, 1) );
//    setDte->dateEdit()->setMaxValue( QDate( startYear+1, 12, 31) );

    h->addWidget( setDte );
    connect( setDte, SIGNAL( valueChanged( const QDateTime& ) ), this,
                        SLOT( slotChangeDateTime( const QDateTime& ) ) );
  }
  {
    QHBoxLayout* h = new QHBoxLayout( v, 5 );
    {
      QVBoxLayout* v1 = new QVBoxLayout( h, 5 );
      {
        // Year Button Group
        g = new QButtonGroup( i18n("Year"), this );
        g->setExclusive( true );
        v1->addWidget( g );
        gl = new QGridLayout( g, 3, 3, 0, 0 );
        gl->addRowSpacing( 0, SpaceT );
        gl->addColSpacing( 0, Space );
        gl->addWidget( new TimeButton( g, QString().setNum(startYear) ), 1, 1 );
        gl->addWidget( new TimeButton( g, QString().setNum(startYear+1) ), 1, 2 );
        gl->addRowSpacing( 2, Space );
        gl->addColSpacing( 3, Space );
        yearBgp = g;
        connect( g, SIGNAL( clicked( int ) ), this,
                        SLOT( slotYearButtons( int ) ) );
      }
      {
        // Month Button Group
        g = new QButtonGroup( i18n("Month"), this );
        g->setExclusive( true );
        v1->addWidget( g );
        gl = new QGridLayout( g, 8, 3, 0, 0 );
        gl->addRowSpacing( 0, SpaceT );
        gl->addColSpacing( 0, Space );
        gl->addWidget( new TimeButton( g, i18n("1  Jan") ), 1, 1 );
        gl->addWidget( new TimeButton( g, i18n("2  Feb") ), 2, 1 );
        gl->addWidget( new TimeButton( g, i18n("3  Mar") ), 3, 1 );
        gl->addWidget( new TimeButton( g, i18n("4  Apr") ), 4, 1 );
        gl->addWidget( new TimeButton( g, i18n("5  May") ), 5, 1 );
        gl->addWidget( new TimeButton( g, i18n("6  Jun") ), 6, 1 );
        gl->addWidget( new TimeButton( g, i18n("7  Jul") ), 1, 2 );
        gl->addWidget( new TimeButton( g, i18n("8  Aug") ), 2, 2 );
        gl->addWidget( new TimeButton( g, i18n("9  Sep") ), 3, 2 );
        gl->addWidget( new TimeButton( g, i18n("10 Oct") ), 4, 2 );
        gl->addWidget( new TimeButton( g, i18n("11 Nov") ), 5, 2 );
        gl->addWidget( new TimeButton( g, i18n("12 Dec") ), 6, 2 );
        gl->addRowSpacing( 7, Space );
        gl->addColSpacing( 3, Space );
        monBgp = g;
        connect( g, SIGNAL( clicked( int ) ), this,
                        SLOT( slotMonthButtons( int ) ) );
      }
    }
    {
      // Day Button Group
      g = new QButtonGroup( i18n("Day"), this );
      g->setExclusive( true );
      h->addWidget( g );
      gl = new QGridLayout( g, 9, 9, 0, 0 );
      gl->addRowSpacing( 0, SpaceT );
      gl->addColSpacing( 0, SpaceT );
      QLabel* l = new QLabel( i18n("Sun"), g );
      l->setFixedHeight( 23 );
      l->setAlignment( Qt::AlignCenter );
      gl->addWidget( l, 1, 1 );
      gl->addWidget( new QLabel( i18n("Mon"), g ), 1, 2 );
      gl->addWidget( new QLabel( i18n("The"), g ), 1, 3 );
      gl->addWidget( new QLabel( i18n("Wed"), g ), 1, 4 );
      gl->addWidget( new QLabel( i18n("Thu"), g ), 1, 5 );
      gl->addWidget( new QLabel( i18n("Fri"), g ), 1, 6 );
      gl->addWidget( new QLabel( i18n("Sat"), g ), 1, 7 );
      for( i=0; i<6; i++ ){
        for( j=0; j<7; j++ ){
          TimeButton* b = new TimeButton( g, "" );
          b->setFixedSize( 27, 27 );
          gl->addWidget( b, i+2, j+1 );

        }
      }
      gl->addRowSpacing( 8, Space );
      gl->addColSpacing( 8, SpaceT );
      dayBgp = g;
      connect( g, SIGNAL( clicked( int ) ), this,
                        SLOT( slotDayButtons( int ) ) );
      iniCalend();
    }
  }
  {
    QHBoxLayout* h = new QHBoxLayout( v, 5 );
    {
      // Hour Button Group
      g = new QButtonGroup( i18n("Hours"), this );
      g->setExclusive( true );
      h->addWidget( g );
      gl = new QGridLayout( g, 8, 8, 0, 0 );
      gl->addRowSpacing( 0, SpaceT );
      gl->addMultiCellWidget( new QLabel( i18n("AM"), g ), 1, 1, 6, 6 );
      gl->addMultiCellWidget( new QLabel( i18n("PM"), g ), 4, 4, 6, 6 );
      gl->addColSpacing( 0, Space );
      for( i=0; i<24; i++ ){
        TimeButton* b = new TimeButton( g, i );
        gl->addWidget( b, i/6+2+i/12, i%6+1 );

      }
      gl->addRowSpacing( 7, Space );
      gl->addColSpacing( 7, Space );
      hourBgp = g;
      connect( g, SIGNAL( clicked( int ) ), this,
                        SLOT( slotHourButtons( int ) ) );
    }
    {
      // Minutes Button Group
      g = new QButtonGroup( i18n("Minutes"), this );
      g->setExclusive( true );
      h->addWidget( g );
      gl = new QGridLayout( g, 8, 12, 0, 0 );
      gl->addRowSpacing( 0, SpaceT );
      gl->addColSpacing( 0, Space );
      for( i=0; i<60; i++ ){
        TimeButton* b = new TimeButton( g, i );
        gl->addWidget( b, i/10+1, i%10+1 );

      }
      gl->addRowSpacing( 7, Space );
      gl->addColSpacing( 11, Space );
      connect( g, SIGNAL( clicked( int ) ), this,
                        SLOT( slotMinuteButtons( int ) ) );
      minBgp = g;
    }
  }
  {
    // OK/Cancel Button
    QHBoxLayout* h = new QHBoxLayout( v, 5 );
    h->addStretch( 1 );
    QPushButton *okbutton = new QPushButton( i18n("&OK"), this );
    okbutton->setDefault( true );
    h->addWidget( okbutton );

    QPushButton *canbutton = new QPushButton( i18n("&Cancel"), this );
    h->addWidget( canbutton );

    connect( okbutton, SIGNAL( clicked() ),
                    this, SLOT( accept() ) );
    connect( canbutton, SIGNAL( clicked() ),
                    this, SLOT( reject() ) );
  }

  iniButton();
  setCaption( i18n("At Time Setting") );
}

//
// Destructor
AtTimeDlg::~AtTimeDlg()
{
}

//
// Initialize All Buttons On/Off
void AtTimeDlg::iniButton()
{

  // Year Buttons
  ((QPushButton*)yearBgp->find( setDt.date().year()-startYear ))->setOn( true );
  // Month Buttons
  ((QPushButton*)monBgp->find( setDt.date().month()-1 ))->setOn( true );
  // Day Buttons
  ((QPushButton*)dayBgp->find( setDt.date().day() + startDayPos - 1 ))->setOn( true );
  // Hour Buttons
  ((QPushButton*)hourBgp->find( setDt.time().hour() ))->setOn( true );
  // Minute Buttons
  ((QPushButton*)minBgp->find( setDt.time().minute() ))->setOn( true );

}

//
// Set Label to Day Buttons
void AtTimeDlg::iniCalend()
{
  QDate cur( setDt.date().year(), setDt.date().month(), 1);
  QDate pre = cur.addMonths(-1);
  int lastd = pre.daysInMonth();
  int frstd = lastd - cur.dayOfWeek() + 1;
  int pos = 0;
  int i;
  QPushButton *b;

  // Set Year
  b = (QPushButton*)yearBgp->find(0);
  b->setText( QString().setNum(startYear));
  b = (QPushButton*)yearBgp->find(1);
  b->setText( QString().setNum(startYear+1));
  
  // Set Previous Month Date
  for ( i=frstd; i<=lastd; i++ ){
    b = (QPushButton*)dayBgp->find(pos);
    b->setText( QString().setNum(i) );
    b->setEnabled( false );
    pos++;
  }

  // Set Current Month Date
  startDayPos = pos;
  for( i=1; i<=cur.daysInMonth(); i++ ){
    b = (QPushButton*)dayBgp->find(pos);
    b->setText( QString().setNum(i) );
    b->setEnabled( true );
    pos++;
  }

  // Set Next Month Date 
  for ( i=1; pos < 42; i++ ){
    b = (QPushButton*)dayBgp->find(pos);
    b->setText( QString().setNum(i) );
    b->setEnabled( false );
    pos++;
  }

}

//
//---SLOTS-------------------------------------------------------------------

//
// Year Button Group Action
void AtTimeDlg::slotYearButtons( int id )
{
  int d =  setDt.date().day();
  QDate dt( id + startYear, setDt.date().month(), 1 );
  if ( dt.daysInMonth() < d ) d = dt.daysInMonth();
  dt.setYMD( id + startYear, setDt.date().month(), d );
  setDte->dateEdit()->setDate(dt);
}

//
// Month Button Group Action
void AtTimeDlg::slotMonthButtons( int id )
{
  int d =  setDt.date().day();
  QDate dt( setDt.date().year(), id+1, 1 );
  if ( dt.daysInMonth() < d ) d = dt.daysInMonth();
  dt.setYMD( setDt.date().year(), id+1,  d );
  setDte->dateEdit()->setDate(dt);
}

//
// Day Button Group Action
void AtTimeDlg::slotDayButtons( int id )
{
  setDte->dateEdit()->setDate(QDate(setDt.date().year(), setDt.date().month(), id-startDayPos+1));
}

//
// Hour Button Group Action
void AtTimeDlg::slotHourButtons( int id )
{
  setDte->timeEdit()->setTime(QTime(id, setDt.time().minute(), 0));
}

//
// Minute Button Group Action
void AtTimeDlg::slotMinuteButtons( int id )
{
  setDte->timeEdit()->setTime(QTime(setDt.time().hour(), id, 0));
}

//
// DateTimeEdit Changed
void AtTimeDlg::slotChangeDateTime( const QDateTime& dt )
{
  // Check year boundary ( startYear - startYear+1 )
  if ( dt.date().year() < startYear ){
    // Reset Start Year
    startYear = dt.date().year();
  } else if (  dt.date().year() > startYear+1 ){
    startYear = dt.date().year()-1;
  }
  setDt = dt;
  iniCalend();
  iniButton();
}
