/*
 system call list for ia64
 Copyright (c) 2006 Hitachi,Ltd.,
 Created by Satoru Moriya <s-moriya@sdl.hitachi.co.jp>
 
 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef __KSTRAX_SYSCALL_LIST_H__
#define __KATRACE_SYSCALL_LIST_H__

enum syscall {
	KS_NI_SYSCALL=0,        /* 0 */
	KS_EXIT,
	KS_READ,
	KS_WRITE,
	KS_OPEN,
	KS_CLOSE,               /* 5 */ 
	KS_CREAT,
	KS_LINK,
	KS_UNLINK,
	KS_EXECVE,
	KS_CHDIR,               /* 10 */
	KS_FCHDIR,
	KS_UTIMES,
	KS_MKNOD,
	KS_CHMOD,
	KS_CHOWN,               /* 15 */
	KS_LSEEK,
	KS_GETPID,
	KS_GETPPID,
	KS_MOUNT,
	KS_UMOUNT,              /* 20 */
	KS_SETUID,
	KS_GETUID,
	KS_GETEUID,
	KS_PTRACE,
	KS_ACCESS,              /* 25 */
	KS_SYNC,
	KS_FSYNC,
	KS_FDATASYNC,
	KS_KILL,
	KS_RENAME,              /* 30 */
	KS_MKDIR,
	KS_RMDIR,
	KS_DUP,
	KS_PIPE,
	KS_TIMES,               /* 35 */
	KS_BRK,
	KS_SETGID,
	KS_GETGID,
	KS_GETEGID,
	KS_ACCT,                /* 40 */
	KS_IOCTL,
	KS_FCNTL,
	KS_UMASK,
	KS_CHROOT,
	KS_USTAT,               /* 45 */
	KS_DUP2,
	KS_SETREUID,
	KS_SETREGID,
	KS_GETRESUID,
	KS_SETRESUID,           /* 50 */
	KS_GETRESGID,
	KS_SETRESGID,
	KS_GETGROUPS,
	KS_SETGROUPS,
	KS_GETPGID,             /* 55 */
	KS_SETPGID,
	KS_SETSID,
	KS_GETSID,
	KS_SETHOSTNAME,
	KS_SETRLIMIT,           /* 60 */
	KS_GETRLIMIT,
	KS_GETRUSAGE,
	KS_GETTIMEOFDAY,
	KS_SETTIMEOFDAY,
	KS_SELECT,              /* 65 */
	KS_POLL,
	KS_SYMLINK,
	KS_READLINK,
	KS_USELIB,
	KS_SWAPON,              /* 70 */
	KS_SWAPOFF,
	KS_REBOOT,
	KS_TRUNCATE,
	KS_FTRUNCATE,
	KS_FCHMOD,              /* 75 */
	KS_FCHOWN,
	KS_GETPRIORITY,
	KS_SETPRIORITY,
	KS_STATFS,
	KS_FSTATFS,             /* 80 */
	KS_GETTID,
	KS_SEMGET,
	KS_SEMOP,
	KS_SEMCTL,
	KS_MSGGET,              /* 85 */
	KS_MSGSND,
	KS_MSGRCV,
	KS_MSGCTL,
	KS_SHMGET,
	KS_SHMAT,               /* 90 */
	KS_SHMDT,
	KS_SHMCTL,
	KS_SYSLOG,
	KS_SETITIMER,
	KS_GETITIMER,           /* 95 */
	KS_OLD_STAT,
	KS_OLD_LSTAT,
	KS_OLD_FSTAT,
	KS_VHANGUP,
	KS_LCHOWN,              /* 100 */
	KS_REMAP_FILE_PAGES,
	KS_WAIT4,
	KS_SYSINFO,
	KS_CLONE,
	KS_SETDOMAINNAME,       /* 105 */
	KS_UNAME,
	KS_ADJTIMEX,
	KS_CREATE_MODULE,
	KS_INIT_MODULE,
	KS_DELETE_MODULE,       /* 110 */
	KS_GET_KERNEL_SYMS,
	KS_QUERY_MODULE,
	KS_QUOTACTL,
	KS_BDFLUSH,
	KS_SYSFS,               /* 115 */
	KS_PERSONALITY,
	KS_AFS_SYSCALL,
	KS_SETFSUID,
	KS_SETFSGID,
	KS_GETDENTS,            /* 120 */
	KS_FLOCK,
	KS_READV,
	KS_WRITEV,
	KS_PREAD64,
	KS_PWRITE64,            /* 125 */
	KS_SYSCTL,
	KS_MMAP,
	KS_MUNMAP,
	KS_MLOCK,
	KS_MLOCKALL,            /* 130 */
	KS_MPROTECT,
	KS_MREMAP,
	KS_MSYNC,
	KS_MUNLOCK,
	KS_MUNLOCKALL,          /* 135 */
	KS_SCHED_GETPARAM,
	KS_SCHED_SETPARAM,
	KS_SCHED_GETSCHEDULER,
	KS_SCHED_SETSCHEDULER,
	KS_SCHED_YIELD,         /* 140 */
	KS_SCHED_GET_PRIORITY_MAX,
	KS_SCHED_SET_PRIORITY_MIN,
	KS_SCHED_RR_GET_INTERVAL,
	KS_NANOSLEEP,
	KS_NFSSERVCTL,          /* 145 */
	KS_PRCTL,
	KS_GETPAGESIZE,
	KS_MMAP2,
	KS_PCICONFIG_READ,
	KS_PCICONFIG_WRITE,     /* 150 */
	KS_PERFMONCTL,
	KS_SIGALTSTACK,
	KS_RT_SIGACTION,
	KS_RT_SIGPENDING,
	KS_RT_SIGPROCMASK,      /* 155 */
	KS_RT_SIGQUEUEINFO,
	KS_RT_SIGRETURN,
	KS_RT_SIGSUSPEND,
	KS_RT_SIGTIMEDWAIT,
	KS_GETCWD,              /* 160 */
	KS_CAPGET,
	KS_CAPSET,
	KS_SENDFILE,
	KS_GETPMSG,
	KS_PUTPMSG,             /* 165 */
	KS_SOCKET,
	KS_BIND,
	KS_CONNECT,
	KS_LISTEN,
	KS_ACCEPT,              /* 170 */
	KS_GETSOCKNAME,
	KS_GETPEERNAME,
	KS_SOCKETPAIR,
	KS_SEND,
	KS_SENDTO,              /* 175 */
	KS_RECV,
	KS_RECVFROM,
	KS_SHUTDOWN,
	KS_SETSOCKOPT,
	KS_GETSOCKOPT,          /* 180 */
	KS_SENDMSG,
	KS_RECVMSG,
	KS_PIVOT_ROOT,
	KS_MINCORE,
	KS_MADVISE,             /* 185 */
	KS_STAT,
	KS_LSTAT,
	KS_FSTAT,
	KS_CLONE2,
	KS_GETDENTS64,          /* 190 */
	KS_GETUNWIND,
	KS_READAHEAD,
	KS_SETXATTR,
	KS_LSETXATTR,
	KS_FSETXATTR,           /* 195 */
	KS_GETXATTR,
	KS_LGETXATTR,
	KS_FGETXATTR,
	KS_LISTXATTR,
	KS_LLISTXATTR,          /* 200 */
	KS_FLISTXATTR,
	KS_REMOVEXATTR,
	KS_LREMOVEXATTR,
	KS_FREMOVEXATTR,
	KS_TKILL,               /* 205 */
	KS_FUTEX,
	KS_SCHED_SETAFFINITY,
	KS_SCHED_GETAFFINITY,
	KS_SET_TID_ADDRESS,
	KS_FADVISE64,           /* 210 */
	KS_TGKILL,
	KS_EXIT_GROUP,
	KS_LOOKUP_DCOOKIE,
	KS_IO_SETUP,
	KS_IO_DESTROY,          /* 215 */
	KS_IO_GETEVENTS,
	KS_IO_SUBMIT,
	KS_IO_CANCEL,
	KS_EPOLL_CREATE,
	KS_EPOLL_CTL,           /* 220 */
	KS_EPOLL_WAIT,
	KS_RESTART_SYSCALL,
	KS_SEMTIMEDOP,
	KS_TIMER_CREATE,
	KS_TIMER_SETTIME,       /* 225 */
	KS_TIMER_GETTIME,
	KS_TIMER_GETOVERRUN,
	KS_TIMER_DELETE,
	KS_CLOCK_SETTIME,
	KS_CLOCK_GETTIME,       /* 230 */
	KS_CLOCK_GETRES,
	KS_CLOCK_NANOSLEEP,
	KS_FSTATFS64,
	KS_STATFS64,
	KS_MBIND,               /* 235 */
	KS_GET_MEMPOLICY,
	KS_SET_MEMPOLICY,
	KS_MQ_OPEN,
	KS_MQ_UNLINK,
	KS_MQ_TIMEDSEND,        /* 240 */
	KS_MQ_TIMEDRECEIVE,
	KS_MQ_NOTIFY,
	KS_MQ_GETSETATTR,
	KS_KEXEC_LOAD,
	KS_VSERVER,             /* 245 */
	KS_WAITID,
	KS_ADD_KEY,
	KS_REQUEST_KEY,
	KS_KEYCTL,
	KS_IOPRIO_SET,          /* 250 */
	KS_IOPRIO_GET,
	KS_SET_ZONE_RECLAIM,
	KS_INOTIFY_INIT,
	KS_INOTIFY_ADD_WATCH,
	KS_INOTIFY_RM_WATCH
};

#endif /* __KSTRAX_SYSCALL_LIST__ */
