/*
 stub for IA-64
 Copyright (c) 2006 Hitachi,Ltd.,
 Created by Satoru Moriya <s-moriya@sdl.hitachi.co.jp>
 Updated by Masami Hiramatsu <hiramatu@sdl.hitachi.co.jp>
 
 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


#include <linux/module.h>
#include <asm/unistd.h>

#include "ctr.h"

struct ks_ia64_symbol;

static unsigned long s_addr;
module_param(s_addr, ulong, 0444);
MODULE_PARM_DESC(s_addr, "Address of system call table(sys_call_table).");

static unsigned long fs_addr;
module_param(fs_addr, ulong, 0444);
MODULE_PARM_DESC(fs_addr, "Address of system call table(sys_call_table).");

extern void sys_call_stub_arch(void);
extern void sys_call_stub_arch_arg8(void);
extern void sys_call_stub_arch_clone(void);

asmlinkage long sys_call_stub(ctr_handler_t args)
{
        long ret = -1;
        struct ks_ia64_symbol *true_syscall;

	true_syscall = ia64_get_true_syscall();

        /*
         * pre processing
         */
	pre_sys_call(args);

        ret = ((call_table_t)true_syscall)(args);
        /*
         * post processing
         */
	args.arg_6 = ret;
	post_sys_call(args);
	
        return ret;
}

/*------------------------------------------------------------------------
 *  module init/exit
 */
static void exit_stub(void)
{
	restore_sys_call_table();
	return;
}

static int __init init_stub(void)
{
        /* check parameter */
        if ((void *)s_addr == NULL || (void *)fs_addr == NULL) {
                printk(KERN_ERR "error(init):Invalid parameter\n");
                return -EINVAL;
        }

	printk("before change sys call table\n");

        /* call table redirection */
        if (change_sys_call_table((void *)s_addr, (void *)fs_addr, 
				  (void **)sys_call_stub_arch,
				  (void **)sys_call_stub_arch_arg8,
				  (void **)sys_call_stub_arch_clone) != 0) {
                exit_stub();
                printk(KERN_ERR "error(init):Failed to change system call table\n");
                return -EINVAL;
        }
	try_module_get(THIS_MODULE);

	printk("after change sys call table\n");

        return 0;
}

module_init(init_stub);
module_exit(exit_stub);
MODULE_AUTHOR("S.Moriya <s-moriya@sdl.hitachi.co.jp>");
MODULE_LICENSE("GPL");
EXPORT_SYMBOL_GPL(sys_call_stub);

