.TH KSTRAX 8 "July 2006" "kstrax version 1.0.0"
.SH NAME
kstrax \- Control the kernel buffer in kstrax and analyze log data.
.SH SYNOPSIS
.B kstrax
[
.B -bcehkoprsStTv
]
[
.B \-b
]
[
.B \-c | -r | -t bin_file
]
[
.B \-e sys_call
] ...
[
.B \-o output_file
] 
[
.B \-p pid
]
[
.B \-s nr_entry
]
[
.B \-T time
]
.SH DESCRIPTION
This command controls kernel buffer in kstrax such as reading, set tracing pid 
and syscall, displaying tracing status, and analyzing log data.
.SH OPTIONS
.TP
.BI \-b
Read binary data from kernel space and write it to files.
.TP
.BI \-s "\| nr_entry\^"
Set the user space buffer size to nr_entry.  
.TP
.BI \-k
Not clear the kernel buffer when read binary data from kernel space.
.TP
.BI \-T "\| time\^"
Read binary data only time sec. If you pass 0, this option is invalid.
Use this option with -b.
.TP
.BI \-R
Read binary data only a round (snap shot mode).
.TP
.BI \-e "\| sys_call\^"
Specify tracing system call(trace only sys_call). For example, 
.BR "-e open" 
means to only trace open system call. You can specify trace system call by  
not only each system call name but system call group such as 
.BR "FILE, NETWORK, IPC,PROCESS, SIGNAL and ALL". 
.BR "FILE"
is tracing all the file related system call. 
.BR "NETWORK"
is tracing the network one. 
.BR "IPC" 
is tracing IPC one. 
.BR "SIGNAL"
is tracing the signal one. 
.BR "PROCESS" 
is tracing all system call which involve process management.
.BR "ALL" 
is tracing all system call. The default is 
.BR "-e ALL".
.TP
.BI \-p "\| pid \^"
Specify tracing pid(trace only process with the process ID pid).
.TP
.BI \-c "\| bin_file\^"
Read bin_file, analyze and  write system call information to the file 
named bin_file_stat with statistics mode.
.TP
.BI \-r "\| bin_file\^"
Read bin_file, analyze and write systam call informatino to the file
named bin_file_write with raw mode. 
.TP
.BI \-t "\| bin_file\^"
Read bin_file, analyze and write system call information th the file
named bin_file_txt with normal mode.
.TP
.BI \-o "\| out_filename\^"
Set output file name to out_filename.
.TP
.BI \-S 
Display the tracing status information.
.TP
.BI \-h 
Print the help summary.
.TP
.BI \-v
Print the kstrax command version.

.SH AUTHORS
Satoru Moriya <satoru.moriya.br@hitachi.com>
.br
.SH AVAILABILITY
.B kstrax
is a part of the
.B kstrax
and is available from
.br
http://sourceforge.net/projects/kstrax
.SH SEE ALSO
.BR kstrax-rec (8),
.BR kstrax-simple (8),
.BR kstrax-filter (8),
.BR kstrax-graph (8)
