/*
 kstrax ioctl header
 Copyright (c) 2006 Hitachi,Ltd.,
 Created by Satoru Moriya <s-moriya@sdl.hitachi.co.jp>
 
 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef __KSTRAX_IOC_H__
#define __KSTRAX_IOC_H__

#include <linux/ioctl.h>
#include <linux/unistd.h>

#define NR_TRACE_PROCESS_MAX 256  

#define TRACE_ALL      -1
#define TRACE_FILE     -2
#define TRACE_NETWORK  -3
#define TRACE_IPC      -4
#define TRACE_PROCESS  -5
#define TRACE_SIGNAL   -6
#define TRACE_DEMO     -7    /* ken-patu */

#define INIT_PID        -1

#define KS_BASETIME     -1
#define KS_FILENAME    -11

#define MAGIC_SYSCALL_ZERO 23

#ifdef _IA64_KSTRAX_
# ifndef NR_syscalls
# define NR_syscalls 256
# endif

#define TRACE_TYPE_LIMIT 8

typedef struct kstrax_status {
	int nr_cpu;
	int flag_spec_syscall;
	int trace_syscall[NR_syscalls];
	pid_t trace_pid[NR_TRACE_PROCESS_MAX];
	int nr_buf_entry;
} trace_stat_t;

#else /* _IA64_KSTRAX_ */

# ifndef NR_syscalls
# define NR_syscalls 285
# endif

#define TRACE_SOCKET   -8
#define TRACE_BIND     -9
#define TRACE_CONNECT -10
#define TRACE_LISTEN  -11
#define TRACE_ACCEPT  -12
#define TRACE_GETSOCKNAME -13
#define TRACE_GETPEERNAME -14
#define TRACE_SOCKETPAIR  -15
#define TRACE_SEND    -16
#define TRACE_RECV    -17
#define TRACE_SENDTO  -18
#define TRACE_RECVFROM    -19
#define TRACE_SHUTDOWN    -20
#define TRACE_SETSOCKOPT  -21
#define TRACE_GETSOCKOPT  -22
#define TRACE_SENDMSG -23
#define TRACE_RECVMSG -24

#define TRACE_SEMOP   -25
#define TRACE_SEMGET  -26
#define TRACE_SEMCTL  -27
#define TRACE_SEMTIMEDOP -28
#define TRACE_MSGSND  -29
#define TRACE_MSGRCV  -30
#define TRACE_MSGGET  -31
#define TRACE_MSGCTL  -32
#define TRACE_SHMAT   -33
#define TRACE_SHMDT   -34
#define TRACE_SHMGET  -35
#define TRACE_SHMCTL  -36

#define TRACE_TYPE_LIMIT 37

#define NR_IPC        25
#define NR_SOCKETCALL 18

typedef struct kstrax_status {
	int nr_cpu;
	int flag_spec_syscall;
	int trace_syscall[NR_syscalls];
	int trace_socketcall[NR_SOCKETCALL];
	int trace_ipc[NR_IPC];
	pid_t trace_pid[NR_TRACE_PROCESS_MAX];
	int nr_buf_entry;
} trace_stat_t;

#endif /* _IA64_KSTRAX_ */


/* magic number */
#define KSTRAX_IOC_MAGIC 'o'

#define KSTRAX_IOC_STATUS            _IOR(KSTRAX_IOC_MAGIC, 1, struct kstrax_status)
#define KSTRAX_IOC_SET_CPU           _IOW(KSTRAX_IOC_MAGIC, 2, int)
#define KSTRAX_IOC_SET_FORCE_WAKEUP  _IO(KSTRAX_IOC_MAGIC,  3)
#define KSTRAX_IOC_INIT_INDEX        _IO(KSTRAX_IOC_MAGIC,  4)
#define KSTRAX_IOC_READ_BASETIME     _IOR(KSTRAX_IOC_MAGIC, 5, int)
#define KSTRAX_IOC_SET_OWNER         _IOW(KSTRAX_IOC_MAGIC, 6, pid_t)
#define KSTRAX_IOC_CLR_OWNER         _IO(KSTRAX_IOC_MAGIC,  7)
#define KSTRAX_IOC_PID_SPEC          _IOW(KSTRAX_IOC_MAGIC, 8, pid_t)
#define KSTRAX_IOC_SYSCALL_SPEC      _IOW(KSTRAX_IOC_MAGIC, 9, char)
#define KSTRAX_IOC_SET_CUR_INDEX     _IO(KSTRAX_IOC_MAGIC, 10)

#endif  /* __KSTRAX_IOC_H__ */
