/*
 call table redirection for IA-64
 Copyright (c) 2006,2007 Hitachi,Ltd.,
 Created by Satoru Moriya <satoru.moriya.br@hitachi.com>
 
 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef __CTREDIRECT_H__
#define __CTREDIRECT_H__

typedef struct ctr_arg_list {
	long arg_1;
	long arg_2;
	long arg_3;
	long arg_4;
	long arg_5;
	long arg_6;
	long arg_7;
	long arg_8;
	long arg_9;
} ctr_arg_t;

typedef long asmlinkage (*call_table_t) (ctr_arg_t);
typedef void (*syscall_handler_t) (const ctr_arg_t);

asmlinkage int kstrax_set_return_addr(unsigned long, unsigned long, unsigned long,
				      unsigned long);
asmlinkage struct ks_ia64_asmdata *kstrax_get_return_addr(void);
unsigned long kstrax_get_syscall_num(void);
struct ks_ia64_symbol *ia64_get_true_syscall(void);
void pre_sys_call(const ctr_arg_t);
void post_sys_call(const ctr_arg_t);
int change_sys_call_table(call_table_t *, call_table_t *, 
			  void **, void **);
void restore_sys_call_table(void);

int register_ctr(syscall_handler_t, syscall_handler_t);
void unregister_ctr(void);
#endif	/* __CTREDIRECT_H__ */
