/*
 * Decompiled with CFR 0.152.
 */
package org.drools;

import java.io.ObjectStreamException;
import java.io.Serializable;
import org.drools.concurrent.ExecutorService;

public class RuleBaseConfiguration
implements Serializable {
    private static final long serialVersionUID = 320L;
    private boolean immutable = false;
    private boolean maintainTms;
    private boolean removeIdentities;
    private boolean shareAlphaNodes;
    private boolean shareBetaNodes;
    private boolean alphaMemory;
    private int alphaNodeHashingThreshold;
    private int compositeKeyDepth;
    private boolean indexLeftBetaMemory;
    private boolean indexRightBetaMemory;
    private AssertBehaviour assertBehaviour;
    private LogicalOverride logicalOverride;
    private ExecutorService executorService;

    public RuleBaseConfiguration() {
        this.setMaintainTms(Boolean.valueOf(System.getProperty("drools.maintainTms", "true")));
        this.setRemoveIdentities(Boolean.valueOf(System.getProperty("drools.removeIdentities", "false")));
        this.setAlphaMemory(Boolean.valueOf(System.getProperty("drools.alphaMemory", "false")));
        this.setShareAlphaNodes(Boolean.valueOf(System.getProperty("drools.shareAlphaNodes", "true")));
        this.setShareBetaNodes(Boolean.valueOf(System.getProperty("drools.shareBetaNodes", "true")));
        this.setAlphaNodeHashingThreshold(Integer.parseInt(System.getProperty("drools.alphaNodeHashingThreshold", "3")));
        this.setCompositeKeyDepth(Integer.parseInt(System.getProperty("drools.compositeKeyDepth", "3")));
        this.setIndexLeftBetaMemory(Boolean.valueOf(System.getProperty("drools.indexLeftBetaMemory", "true")));
        this.setIndexRightBetaMemory(Boolean.valueOf(System.getProperty("drools.indexRightBetaMemory", "true")));
        this.setAssertBehaviour(AssertBehaviour.determineAssertBehaviour(System.getProperty("drools.assertBehaviour", "IDENTITY")));
        this.setLogicalOverride(LogicalOverride.determineLogicalOverride(System.getProperty("drools.logicalOverride", "DISCARD")));
        this.setExecutorService(RuleBaseConfiguration.determineExecutorService(System.getProperty("drools.executorService", "org.drools.concurrent.DefaultExecutorService")));
    }

    public void makeImmutable() {
        this.immutable = true;
    }

    public boolean isImmutable() {
        return this.immutable;
    }

    private void checkCanChange() {
        if (this.immutable) {
            throw new UnsupportedOperationException("Can't set a property after configuration becomes immutable");
        }
    }

    public boolean getMaintainTms() {
        return this.maintainTms;
    }

    public void setMaintainTms(boolean maintainTms) {
        this.checkCanChange();
        this.maintainTms = maintainTms;
    }

    public boolean isRemoveIdentities() {
        return this.removeIdentities;
    }

    public void setRemoveIdentities(boolean removeIdentities) {
        this.checkCanChange();
        this.removeIdentities = removeIdentities;
    }

    public boolean isAlphaMemory() {
        return this.alphaMemory;
    }

    public void setAlphaMemory(boolean alphaMemory) {
        this.checkCanChange();
        this.alphaMemory = alphaMemory;
    }

    public boolean isShareAlphaNodes() {
        return this.shareAlphaNodes;
    }

    public void setShareAlphaNodes(boolean shareAlphaNodes) {
        this.checkCanChange();
        this.shareAlphaNodes = shareAlphaNodes;
    }

    public boolean isShareBetaNodes() {
        return this.shareBetaNodes;
    }

    public void setShareBetaNodes(boolean shareBetaNodes) {
        this.checkCanChange();
        this.shareBetaNodes = shareBetaNodes;
    }

    public int getAlphaNodeHashingThreshold() {
        return this.alphaNodeHashingThreshold;
    }

    public void setAlphaNodeHashingThreshold(int alphaNodeHashingThreshold) {
        this.checkCanChange();
        this.alphaNodeHashingThreshold = alphaNodeHashingThreshold;
    }

    public AssertBehaviour getAssertBehaviour() {
        return this.assertBehaviour;
    }

    public void setAssertBehaviour(AssertBehaviour assertBehaviour) {
        this.checkCanChange();
        this.assertBehaviour = assertBehaviour;
    }

    public int getCompositeKeyDepth() {
        return this.compositeKeyDepth;
    }

    public void setCompositeKeyDepth(int compositeKeyDepth) {
        if (!this.immutable) {
            if (compositeKeyDepth > 3) {
                throw new UnsupportedOperationException("compositeKeyDepth cannot be greater than 3");
            }
        } else {
            throw new UnsupportedOperationException("Can't set a property after configuration becomes immutable");
        }
        this.compositeKeyDepth = compositeKeyDepth;
    }

    public boolean isIndexLeftBetaMemory() {
        return this.indexLeftBetaMemory;
    }

    public void setIndexLeftBetaMemory(boolean indexLeftBetaMemory) {
        this.checkCanChange();
        this.indexLeftBetaMemory = indexLeftBetaMemory;
    }

    public boolean isIndexRightBetaMemory() {
        return this.indexRightBetaMemory;
    }

    public void setIndexRightBetaMemory(boolean indexRightBetaMemory) {
        this.checkCanChange();
        this.indexRightBetaMemory = indexRightBetaMemory;
    }

    public LogicalOverride getLogicalOverride() {
        return this.logicalOverride;
    }

    public void setLogicalOverride(LogicalOverride logicalOverride) {
        this.checkCanChange();
        this.logicalOverride = logicalOverride;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public void setExecutorService(ExecutorService executorService) {
        this.checkCanChange();
        this.executorService = executorService;
    }

    public static ExecutorService determineExecutorService(String className) {
        Class<?> clazz = null;
        try {
            clazz = Thread.currentThread().getContextClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        if (clazz == null) {
            try {
                clazz = RuleBaseConfiguration.class.getClassLoader().loadClass(className);
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
        if (clazz != null) {
            try {
                return (ExecutorService)clazz.newInstance();
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Unable to instantiate ExecutorService '" + className + "'");
            }
        }
        throw new IllegalArgumentException("ExecutorService '" + className + "' not found");
    }

    public static class LogicalOverride
    implements Serializable {
        private static final long serialVersionUID = 320L;
        public static final LogicalOverride PRESERVE = new LogicalOverride(0);
        public static final LogicalOverride DISCARD = new LogicalOverride(1);
        private int value;

        private LogicalOverride(int value) {
            this.value = value;
        }

        public static LogicalOverride determineLogicalOverride(String value) {
            if (value.equals("PRESERVE")) {
                return PRESERVE;
            }
            if (value.equals("DISCARD")) {
                return DISCARD;
            }
            throw new IllegalArgumentException("Illegal enum value '" + value + "' for LogicalOverride");
        }

        private Object readResolve() throws ObjectStreamException {
            switch (this.value) {
                case 0: {
                    return PRESERVE;
                }
                case 1: {
                    return DISCARD;
                }
            }
            throw new IllegalArgumentException("Illegal enum value '" + this.value + "' for LogicalOverride");
        }
    }

    public static class AssertBehaviour
    implements Serializable {
        private static final long serialVersionUID = 320L;
        public static final AssertBehaviour IDENTITY = new AssertBehaviour(0);
        public static final AssertBehaviour EQUALITY = new AssertBehaviour(1);
        private int value;

        private AssertBehaviour(int value) {
            this.value = value;
        }

        public static AssertBehaviour determineAssertBehaviour(String value) {
            if (value.equals("IDENTITY")) {
                return IDENTITY;
            }
            if (value.equals("EQUALITY")) {
                return EQUALITY;
            }
            throw new IllegalArgumentException("Illegal enum value '" + value + "' for AssertBehaviour");
        }

        private Object readResolve() throws ObjectStreamException {
            switch (this.value) {
                case 0: {
                    return IDENTITY;
                }
                case 1: {
                    return EQUALITY;
                }
            }
            throw new IllegalArgumentException("Illegal enum value '" + this.value + "' for AssertBehaviour");
        }
    }
}

