/*
 * Decompiled with CFR 0.152.
 */
package org.drools.audit;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.drools.WorkingMemory;
import org.drools.audit.event.ActivationLogEvent;
import org.drools.audit.event.ILogEventFilter;
import org.drools.audit.event.LogEvent;
import org.drools.audit.event.ObjectLogEvent;
import org.drools.common.InternalFactHandle;
import org.drools.event.ActivationCancelledEvent;
import org.drools.event.ActivationCreatedEvent;
import org.drools.event.AfterActivationFiredEvent;
import org.drools.event.AgendaEventListener;
import org.drools.event.AgendaGroupPoppedEvent;
import org.drools.event.AgendaGroupPushedEvent;
import org.drools.event.BeforeActivationFiredEvent;
import org.drools.event.ObjectAssertedEvent;
import org.drools.event.ObjectModifiedEvent;
import org.drools.event.ObjectRetractedEvent;
import org.drools.event.WorkingMemoryEventListener;
import org.drools.rule.Declaration;
import org.drools.spi.Activation;
import org.drools.spi.Tuple;

public abstract class WorkingMemoryLogger
implements WorkingMemoryEventListener,
AgendaEventListener {
    private final List filters = new ArrayList();
    private WorkingMemory workingMemory;

    public WorkingMemoryLogger(WorkingMemory workingMemory) {
        this.workingMemory = workingMemory;
        workingMemory.addEventListener(this);
        workingMemory.addEventListener(this);
    }

    public abstract void logEventCreated(LogEvent var1);

    private void filterLogEvent(LogEvent logEvent) {
        Iterator iterator = this.filters.iterator();
        while (iterator.hasNext()) {
            ILogEventFilter filter = (ILogEventFilter)iterator.next();
            if (filter.acceptEvent(logEvent)) continue;
            return;
        }
        this.logEventCreated(logEvent);
    }

    public void addFilter(ILogEventFilter filter) {
        if (filter == null) {
            throw new NullPointerException();
        }
        this.filters.add(filter);
    }

    public void removeFilter(ILogEventFilter filter) {
        this.filters.remove(filter);
    }

    public void clearFilters() {
        this.filters.clear();
    }

    public void objectAsserted(ObjectAssertedEvent event) {
        this.filterLogEvent(new ObjectLogEvent(1, ((InternalFactHandle)event.getFactHandle()).getId(), event.getObject().toString()));
    }

    public void objectModified(ObjectModifiedEvent event) {
        this.filterLogEvent(new ObjectLogEvent(2, ((InternalFactHandle)event.getFactHandle()).getId(), event.getObject().toString()));
    }

    public void objectRetracted(ObjectRetractedEvent event) {
        this.filterLogEvent(new ObjectLogEvent(3, ((InternalFactHandle)event.getFactHandle()).getId(), event.getOldObject().toString()));
    }

    public void activationCreated(ActivationCreatedEvent event, WorkingMemory workingMemory) {
        this.filterLogEvent(new ActivationLogEvent(4, WorkingMemoryLogger.getActivationId(event.getActivation()), event.getActivation().getRule().getName(), this.extractDeclarations(event.getActivation())));
    }

    public void activationCancelled(ActivationCancelledEvent event, WorkingMemory workingMemory) {
        this.filterLogEvent(new ActivationLogEvent(5, WorkingMemoryLogger.getActivationId(event.getActivation()), event.getActivation().getRule().getName(), this.extractDeclarations(event.getActivation())));
    }

    public void beforeActivationFired(BeforeActivationFiredEvent event, WorkingMemory workingMemory) {
        this.filterLogEvent(new ActivationLogEvent(6, WorkingMemoryLogger.getActivationId(event.getActivation()), event.getActivation().getRule().getName(), this.extractDeclarations(event.getActivation())));
    }

    public void afterActivationFired(AfterActivationFiredEvent event, WorkingMemory workingMemory) {
        this.filterLogEvent(new ActivationLogEvent(7, WorkingMemoryLogger.getActivationId(event.getActivation()), event.getActivation().getRule().getName(), this.extractDeclarations(event.getActivation())));
    }

    private String extractDeclarations(Activation activation) {
        StringBuffer result = new StringBuffer();
        Tuple tuple = activation.getTuple();
        Declaration[] declarations = activation.getRule().getDeclarations();
        int length = declarations.length;
        for (int i = 0; i < length; ++i) {
            Declaration declaration = declarations[i];
            InternalFactHandle handle = tuple.get(declaration);
            if (handle instanceof InternalFactHandle) {
                InternalFactHandle handleImpl = handle;
                if (handleImpl.getId() == -1L) continue;
                Object value = declaration.getValue(this.workingMemory.getObject(handle));
                result.append(declaration.getIdentifier());
                result.append("=");
                if (value == null) {
                    result.append("null");
                } else {
                    result.append(value);
                    result.append("(");
                    result.append(handleImpl.getId());
                    result.append(")");
                }
            }
            if (i >= declarations.length - 1) continue;
            result.append("; ");
        }
        return result.toString();
    }

    private static String getActivationId(Activation activation) {
        StringBuffer result = new StringBuffer(activation.getRule().getName());
        result.append(" [");
        Tuple tuple = activation.getTuple();
        InternalFactHandle[] handles = tuple.getFactHandles();
        for (int i = 0; i < handles.length; ++i) {
            result.append(handles[i].getId());
            if (i >= handles.length - 1) continue;
            result.append(", ");
        }
        return result.append("]").toString();
    }

    public void agendaGroupPopped(AgendaGroupPoppedEvent event, WorkingMemory workingMemory) {
    }

    public void agendaGroupPushed(AgendaGroupPushedEvent event, WorkingMemory workingMemory) {
    }
}

