/*
 * Decompiled with CFR 0.152.
 */
package org.drools.base;

import org.drools.RuntimeDroolsException;
import org.drools.base.ValueType;
import org.drools.spi.FieldExtractor;
import org.drools.util.asm.ClassFieldInspector;

public abstract class BaseClassFieldExtractor
implements FieldExtractor {
    private final int index;
    private final Class fieldType;
    private final ValueType valueType;

    protected BaseClassFieldExtractor(int index, Class fieldType, ValueType valueType) {
        this.index = index;
        this.fieldType = fieldType;
        this.valueType = valueType;
    }

    public BaseClassFieldExtractor(Class clazz, String fieldName) {
        try {
            ClassFieldInspector inspector = new ClassFieldInspector(clazz);
            this.index = (Integer)inspector.getFieldNames().get(fieldName);
            this.fieldType = (Class)inspector.getFieldTypes().get(fieldName);
            this.valueType = ValueType.determineValueType(this.fieldType);
        }
        catch (Exception e) {
            throw new RuntimeDroolsException(e);
        }
    }

    public int getIndex() {
        return this.index;
    }

    public Class getExtractToClass() {
        return this.fieldType;
    }

    public ValueType getValueType() {
        return this.valueType;
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + this.fieldType.hashCode();
        result = 31 * result + this.index;
        result = 31 * result + this.valueType.hashCode();
        return result;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof BaseClassFieldExtractor)) {
            return false;
        }
        BaseClassFieldExtractor other = (BaseClassFieldExtractor)object;
        return this.fieldType == other.fieldType && this.index == other.index && this.valueType.equals(other.valueType);
    }
}

