/*
 * Decompiled with CFR 0.152.
 */
package org.drools.base;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.lang.reflect.Method;
import org.drools.RuntimeDroolsException;
import org.drools.base.ClassFieldExtractorFactory;
import org.drools.base.ValueType;
import org.drools.spi.FieldExtractor;

public class ClassFieldExtractor
implements FieldExtractor {
    private static final long serialVersionUID = 320L;
    private String fieldName;
    private Class clazz;
    private transient FieldExtractor extractor;

    public ClassFieldExtractor(Class clazz, String fieldName) {
        this(clazz, fieldName, null);
    }

    public ClassFieldExtractor(Class clazz, String fieldName, ClassLoader classLoader) {
        this.clazz = clazz;
        this.fieldName = fieldName;
        this.init(classLoader);
    }

    private void readObject(ObjectInputStream is) throws ClassNotFoundException, IOException, Exception {
        is.defaultReadObject();
        this.init(null);
    }

    public void init(ClassLoader classLoader) {
        try {
            this.extractor = ClassFieldExtractorFactory.getClassFieldExtractor(this.clazz, this.fieldName, classLoader);
        }
        catch (Exception e) {
            throw new RuntimeDroolsException(e);
        }
    }

    public int getIndex() {
        return this.extractor.getIndex();
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public Object getValue(Object object) {
        return this.extractor.getValue(object);
    }

    public ValueType getValueType() {
        return this.extractor.getValueType();
    }

    public Class getExtractToClass() {
        return this.extractor.getExtractToClass();
    }

    public String toString() {
        return "[ClassFieldExtractor class=" + this.clazz + " field=" + this.fieldName + "]";
    }

    public int hashCode() {
        return this.getValueType().hashCode() * 17 + this.getIndex();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof ClassFieldExtractor)) {
            return false;
        }
        ClassFieldExtractor other = (ClassFieldExtractor)object;
        return this.extractor.getValueType() == other.getValueType() && this.extractor.getIndex() == other.getIndex();
    }

    public boolean getBooleanValue(Object object) {
        return this.extractor.getBooleanValue(object);
    }

    public byte getByteValue(Object object) {
        return this.extractor.getByteValue(object);
    }

    public char getCharValue(Object object) {
        return this.extractor.getCharValue(object);
    }

    public double getDoubleValue(Object object) {
        return this.extractor.getDoubleValue(object);
    }

    public float getFloatValue(Object object) {
        return this.extractor.getFloatValue(object);
    }

    public int getIntValue(Object object) {
        return this.extractor.getIntValue(object);
    }

    public long getLongValue(Object object) {
        return this.extractor.getLongValue(object);
    }

    public short getShortValue(Object object) {
        return this.extractor.getShortValue(object);
    }

    public boolean isNullValue(Object object) {
        return this.extractor.isNullValue(object);
    }

    public Method getNativeReadMethod() {
        return this.extractor.getNativeReadMethod();
    }

    public int getHashCode(Object object) {
        return this.extractor.getHashCode(object);
    }
}

