/*
 * Decompiled with CFR 0.152.
 */
package org.drools.base;

import java.lang.reflect.Field;
import org.drools.RuntimeDroolsException;
import org.drools.base.ShadowProxy;
import org.drools.base.ValueType;
import org.drools.spi.ObjectType;
import org.objenesis.Objenesis;
import org.objenesis.ObjenesisStd;
import org.objenesis.instantiator.ObjectInstantiator;

public class ClassObjectType
implements ObjectType {
    private static final Objenesis OBJENESIS = new ObjenesisStd(false);
    private static final long serialVersionUID = 320L;
    protected Class objectTypeClass;
    protected ValueType valueType;
    protected boolean shadowEnabled;
    protected Class shadowClass;
    protected transient ObjectInstantiator instantiator;
    protected transient Field delegate;

    public ClassObjectType(Class objectTypeClass) {
        this(objectTypeClass, null);
    }

    public ClassObjectType(Class objectTypeClass, Class shadowClass) {
        this.objectTypeClass = objectTypeClass;
        this.valueType = ValueType.determineValueType(objectTypeClass);
        if (shadowClass != null) {
            this.shadowClass = shadowClass;
            this.shadowEnabled = true;
            this.setInstantiator();
            this.setDelegateFieldObject();
        }
    }

    private void setInstantiator() {
        this.instantiator = OBJENESIS.getInstantiatorOf(this.shadowClass);
    }

    private void setDelegateFieldObject() {
        try {
            this.delegate = this.shadowClass.getDeclaredField("delegate");
            this.delegate.setAccessible(true);
        }
        catch (Exception e) {
            throw new RuntimeDroolsException("Error retriving delegate field for shadow proxy class: " + this.shadowClass.getName(), e);
        }
    }

    public Class getClassType() {
        return this.objectTypeClass;
    }

    public boolean matches(Object object) {
        return this.getClassType().isInstance(object);
    }

    public ValueType getValueType() {
        return this.valueType;
    }

    public Object getShadow(Object fact) throws RuntimeDroolsException {
        ShadowProxy proxy = null;
        if (this.isShadowEnabled()) {
            try {
                if (this.delegate == null) {
                    this.setDelegateFieldObject();
                }
                if (this.instantiator == null) {
                    this.setInstantiator();
                }
                proxy = (ShadowProxy)this.instantiator.newInstance();
                this.delegate.set(proxy, fact);
            }
            catch (Exception e) {
                throw new RuntimeDroolsException("Error creating shadow fact for object: " + fact, e);
            }
        }
        return proxy;
    }

    public boolean isShadowEnabled() {
        return this.shadowEnabled;
    }

    public String toString() {
        return "[ClassObjectType class=" + this.getClassType().getName() + "]";
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || object.getClass() != ClassObjectType.class) {
            return false;
        }
        return this.objectTypeClass == ((ClassObjectType)object).objectTypeClass;
    }

    public int hashCode() {
        return this.objectTypeClass.hashCode();
    }
}

