/*
 * Decompiled with CFR 0.152.
 */
package org.drools.base.evaluators;

import org.drools.base.BaseEvaluator;
import org.drools.base.ValueType;
import org.drools.base.evaluators.EvaluatorFactory;
import org.drools.base.evaluators.Operator;
import org.drools.rule.VariableRestriction;
import org.drools.spi.Evaluator;
import org.drools.spi.Extractor;
import org.drools.spi.FieldValue;

public class ArrayFactory
implements EvaluatorFactory {
    private static final long serialVersionUID = -5485618486269637287L;
    private static EvaluatorFactory INSTANCE = new ArrayFactory();

    private ArrayFactory() {
    }

    public static EvaluatorFactory getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ArrayFactory();
        }
        return INSTANCE;
    }

    public Evaluator getEvaluator(Operator operator) {
        if (operator == Operator.EQUAL) {
            return ArrayEqualEvaluator.INSTANCE;
        }
        if (operator == Operator.NOT_EQUAL) {
            return ArrayNotEqualEvaluator.INSTANCE;
        }
        if (operator == Operator.CONTAINS) {
            return ArrayContainsEvaluator.INSTANCE;
        }
        if (operator == Operator.EXCLUDES) {
            return ArrayExcludesEvaluator.INSTANCE;
        }
        if (operator == Operator.MEMBEROF) {
            return ArrayMemberOfEvaluator.INSTANCE;
        }
        if (operator == Operator.NOTMEMBEROF) {
            return ArrayNotMemberOfEvaluator.INSTANCE;
        }
        throw new RuntimeException("Operator '" + operator + "' does not exist for ArrayEvaluator");
    }

    static final class ArrayUtils {
        ArrayUtils() {
        }

        public static final int search(Object[] array, Object value) {
            int index = -1;
            for (int i = 0; i < array.length; ++i) {
                if ((array[i] != null || value != null) && (array[i] == null || !array[i].equals(value))) continue;
                index = i;
                break;
            }
            return index;
        }

        public static final int search(boolean[] array, boolean value) {
            int index = -1;
            for (int i = 0; i < array.length; ++i) {
                if (array[i] != value) continue;
                index = i;
                break;
            }
            return index;
        }

        public static final int search(byte[] array, byte value) {
            int index = -1;
            for (int i = 0; i < array.length; ++i) {
                if (array[i] != value) continue;
                index = i;
                break;
            }
            return index;
        }

        public static final int search(short[] array, short value) {
            int index = -1;
            for (int i = 0; i < array.length; ++i) {
                if (array[i] != value) continue;
                index = i;
                break;
            }
            return index;
        }

        public static final int search(int[] array, int value) {
            int index = -1;
            for (int i = 0; i < array.length; ++i) {
                if (array[i] != value) continue;
                index = i;
                break;
            }
            return index;
        }

        public static final int search(long[] array, long value) {
            int index = -1;
            for (int i = 0; i < array.length; ++i) {
                if (array[i] != value) continue;
                index = i;
                break;
            }
            return index;
        }

        public static final int search(float[] array, float value) {
            int index = -1;
            for (int i = 0; i < array.length; ++i) {
                if (array[i] != value) continue;
                index = i;
                break;
            }
            return index;
        }

        public static final int search(double[] array, double value) {
            int index = -1;
            for (int i = 0; i < array.length; ++i) {
                if (array[i] != value) continue;
                index = i;
                break;
            }
            return index;
        }

        public static final int search(char[] array, char value) {
            int index = -1;
            for (int i = 0; i < array.length; ++i) {
                if (array[i] != value) continue;
                index = i;
                break;
            }
            return index;
        }
    }

    static class ArrayNotMemberOfEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 320L;
        public static final Evaluator INSTANCE = new ArrayNotMemberOfEvaluator();

        private ArrayNotMemberOfEvaluator() {
            super(ValueType.ARRAY_TYPE, Operator.NOTMEMBEROF);
        }

        public boolean evaluate(Extractor extractor, Object object1, FieldValue object2) {
            Object[] array = (Object[])object2.getValue();
            Object value = extractor.getValue(object1);
            if (array == null) {
                return false;
            }
            return ArrayUtils.search(array, value) < 0;
        }

        public boolean evaluateCachedRight(VariableRestriction.VariableContextEntry context, Object left) {
            Object[] array = (Object[])context.declaration.getExtractor().getValue(left);
            Object value = ((VariableRestriction.ObjectVariableContextEntry)context).right;
            if (array == null) {
                return false;
            }
            return ArrayUtils.search(array, value) < 0;
        }

        public boolean evaluateCachedLeft(VariableRestriction.VariableContextEntry context, Object right) {
            Object[] array = (Object[])((VariableRestriction.ObjectVariableContextEntry)context).left;
            Object value = context.extractor.getValue(right);
            if (array == null) {
                return false;
            }
            return ArrayUtils.search(array, value) < 0;
        }

        public boolean evaluate(Extractor extractor1, Object object1, Extractor extractor2, Object object2) {
            Object[] array = (Object[])extractor2.getValue(object2);
            Object value = extractor1.getValue(object1);
            if (array == null) {
                return false;
            }
            return ArrayUtils.search(array, value) < 0;
        }

        public String toString() {
            return "Array not memberOf";
        }
    }

    static class ArrayMemberOfEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 320L;
        public static final Evaluator INSTANCE = new ArrayMemberOfEvaluator();

        private ArrayMemberOfEvaluator() {
            super(ValueType.ARRAY_TYPE, Operator.MEMBEROF);
        }

        public boolean evaluate(Extractor extractor, Object object1, FieldValue object2) {
            Object[] array = (Object[])object2.getValue();
            Object value = extractor.getValue(object1);
            if (array == null) {
                return false;
            }
            return ArrayUtils.search(array, value) >= 0;
        }

        public boolean evaluateCachedRight(VariableRestriction.VariableContextEntry context, Object left) {
            Object[] array = (Object[])context.declaration.getExtractor().getValue(left);
            Object value = ((VariableRestriction.ObjectVariableContextEntry)context).right;
            if (array == null) {
                return false;
            }
            return ArrayUtils.search(array, value) >= 0;
        }

        public boolean evaluateCachedLeft(VariableRestriction.VariableContextEntry context, Object right) {
            Object[] array = (Object[])((VariableRestriction.ObjectVariableContextEntry)context).left;
            Object value = context.extractor.getValue(right);
            if (array == null) {
                return false;
            }
            return ArrayUtils.search(array, value) >= 0;
        }

        public boolean evaluate(Extractor extractor1, Object object1, Extractor extractor2, Object object2) {
            Object[] array = (Object[])extractor2.getValue(object2);
            Object value = extractor1.getValue(object1);
            if (array == null) {
                return false;
            }
            return ArrayUtils.search(array, value) >= 0;
        }

        public String toString() {
            return "Array memberOf";
        }
    }

    static class ArrayExcludesEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 320L;
        public static final Evaluator INSTANCE = new ArrayExcludesEvaluator();

        private ArrayExcludesEvaluator() {
            super(ValueType.ARRAY_TYPE, Operator.EXCLUDES);
        }

        public boolean evaluate(Extractor extractor, Object object1, FieldValue object2) {
            Object value = object2.getValue();
            Object[] array = (Object[])extractor.getValue(object1);
            if (array == null) {
                return false;
            }
            return ArrayUtils.search(array, value) < 0;
        }

        public boolean evaluateCachedRight(VariableRestriction.VariableContextEntry context, Object left) {
            Object value = context.declaration.getExtractor().getValue(left);
            Object[] array = (Object[])((VariableRestriction.ObjectVariableContextEntry)context).right;
            if (array == null) {
                return false;
            }
            return ArrayUtils.search(array, value) < 0;
        }

        public boolean evaluateCachedLeft(VariableRestriction.VariableContextEntry context, Object right) {
            Object value = ((VariableRestriction.ObjectVariableContextEntry)context).left;
            Object[] array = (Object[])context.extractor.getValue(right);
            if (array == null) {
                return false;
            }
            return ArrayUtils.search(array, value) < 0;
        }

        public boolean evaluate(Extractor extractor1, Object object1, Extractor extractor2, Object object2) {
            Object value = extractor2.getValue(object2);
            Object[] array = (Object[])extractor1.getValue(object1);
            if (array == null) {
                return false;
            }
            return ArrayUtils.search(array, value) < 0;
        }

        public String toString() {
            return "Array excludes";
        }
    }

    static class ArrayContainsEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 320L;
        public static final Evaluator INSTANCE = new ArrayContainsEvaluator();

        private ArrayContainsEvaluator() {
            super(ValueType.ARRAY_TYPE, Operator.CONTAINS);
        }

        public boolean evaluate(Extractor extractor, Object object1, FieldValue object2) {
            Object value = object2.getValue();
            Object[] array = (Object[])extractor.getValue(object1);
            if (array == null) {
                return false;
            }
            return ArrayUtils.search(array, value) >= 0;
        }

        public boolean evaluateCachedRight(VariableRestriction.VariableContextEntry context, Object left) {
            Object value = context.declaration.getExtractor().getValue(left);
            Object[] array = (Object[])((VariableRestriction.ObjectVariableContextEntry)context).right;
            if (array == null) {
                return false;
            }
            return ArrayUtils.search(array, value) >= 0;
        }

        public boolean evaluateCachedLeft(VariableRestriction.VariableContextEntry context, Object right) {
            Object value = ((VariableRestriction.ObjectVariableContextEntry)context).left;
            Object[] array = (Object[])context.extractor.getValue(right);
            if (array == null) {
                return false;
            }
            return ArrayUtils.search(array, value) >= 0;
        }

        public boolean evaluate(Extractor extractor1, Object object1, Extractor extractor2, Object object2) {
            Object value = extractor2.getValue(object2);
            Object[] array = (Object[])extractor1.getValue(object1);
            if (array == null) {
                return false;
            }
            return ArrayUtils.search(array, value) >= 0;
        }

        public String toString() {
            return "Array contains";
        }
    }

    static class ArrayNotEqualEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 320L;
        public static final Evaluator INSTANCE = new ArrayNotEqualEvaluator();

        private ArrayNotEqualEvaluator() {
            super(ValueType.ARRAY_TYPE, Operator.NOT_EQUAL);
        }

        public boolean evaluate(Extractor extractor, Object object1, FieldValue object2) {
            Object value1 = extractor.getValue(object1);
            Object value2 = object2.getValue();
            if (value1 == null) {
                return value2 != null;
            }
            return !value1.equals(value2);
        }

        public boolean evaluateCachedRight(VariableRestriction.VariableContextEntry context, Object left) {
            Object value = context.declaration.getExtractor().getValue(left);
            if (value == null) {
                return ((VariableRestriction.ObjectVariableContextEntry)context).right != null;
            }
            return !value.equals(((VariableRestriction.ObjectVariableContextEntry)context).right);
        }

        public boolean evaluateCachedLeft(VariableRestriction.VariableContextEntry context, Object right) {
            Object value = context.extractor.getValue(right);
            if (((VariableRestriction.ObjectVariableContextEntry)context).left == null) {
                return value != null;
            }
            return !((VariableRestriction.ObjectVariableContextEntry)context).left.equals(value);
        }

        public boolean evaluate(Extractor extractor1, Object object1, Extractor extractor2, Object object2) {
            Object value1 = extractor1.getValue(object1);
            Object value2 = extractor2.getValue(object2);
            if (value1 == null) {
                return value2 != null;
            }
            return !value1.equals(value2);
        }

        public String toString() {
            return "Array !=";
        }
    }

    static class ArrayEqualEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 320L;
        public static final Evaluator INSTANCE = new ArrayEqualEvaluator();

        private ArrayEqualEvaluator() {
            super(ValueType.ARRAY_TYPE, Operator.EQUAL);
        }

        public boolean evaluate(Extractor extractor, Object object1, FieldValue object2) {
            Object value1 = extractor.getValue(object1);
            Object value2 = object2.getValue();
            if (value1 == null) {
                return value2 == null;
            }
            return value1.equals(value2);
        }

        public boolean evaluateCachedRight(VariableRestriction.VariableContextEntry context, Object left) {
            Object value = context.declaration.getExtractor().getValue(left);
            if (value == null) {
                return ((VariableRestriction.ObjectVariableContextEntry)context).right == null;
            }
            return value.equals(((VariableRestriction.ObjectVariableContextEntry)context).right);
        }

        public boolean evaluateCachedLeft(VariableRestriction.VariableContextEntry context, Object right) {
            Object value = context.extractor.getValue(right);
            if (((VariableRestriction.ObjectVariableContextEntry)context).left == null) {
                return value == null;
            }
            return ((VariableRestriction.ObjectVariableContextEntry)context).left.equals(value);
        }

        public boolean evaluate(Extractor extractor1, Object object1, Extractor extractor2, Object object2) {
            Object value1 = extractor1.getValue(object1);
            Object value2 = extractor2.getValue(object2);
            if (value1 == null) {
                return value2 == null;
            }
            return value1.equals(value2);
        }

        public String toString() {
            return "Array ==";
        }
    }
}

