/*
 * Decompiled with CFR 0.152.
 */
package org.drools.base.evaluators;

import org.drools.base.BaseEvaluator;
import org.drools.base.ValueType;
import org.drools.base.evaluators.BaseMemberOfEvaluator;
import org.drools.base.evaluators.BaseNotMemberOfEvaluator;
import org.drools.base.evaluators.EvaluatorFactory;
import org.drools.base.evaluators.Operator;
import org.drools.rule.VariableRestriction;
import org.drools.spi.Evaluator;
import org.drools.spi.Extractor;
import org.drools.spi.FieldValue;

public class ByteFactory
implements EvaluatorFactory {
    private static final long serialVersionUID = -2213953461197502182L;
    private static EvaluatorFactory INSTANCE = new ByteFactory();

    private ByteFactory() {
    }

    public static EvaluatorFactory getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ByteFactory();
        }
        return INSTANCE;
    }

    public Evaluator getEvaluator(Operator operator) {
        if (operator == Operator.EQUAL) {
            return ByteEqualEvaluator.INSTANCE;
        }
        if (operator == Operator.NOT_EQUAL) {
            return ByteNotEqualEvaluator.INSTANCE;
        }
        if (operator == Operator.LESS) {
            return ByteLessEvaluator.INSTANCE;
        }
        if (operator == Operator.LESS_OR_EQUAL) {
            return ByteLessOrEqualEvaluator.INSTANCE;
        }
        if (operator == Operator.GREATER) {
            return ByteGreaterEvaluator.INSTANCE;
        }
        if (operator == Operator.GREATER_OR_EQUAL) {
            return ByteGreaterOrEqualEvaluator.INSTANCE;
        }
        if (operator == Operator.MEMBEROF) {
            return ByteMemberOfEvaluator.INSTANCE;
        }
        if (operator == Operator.NOTMEMBEROF) {
            return ByteNotMemberOfEvaluator.INSTANCE;
        }
        throw new RuntimeException("Operator '" + operator + "' does not exist for ByteEvaluator");
    }

    static class ByteNotMemberOfEvaluator
    extends BaseNotMemberOfEvaluator {
        private static final long serialVersionUID = 320L;
        public static final Evaluator INSTANCE = new ByteNotMemberOfEvaluator();

        private ByteNotMemberOfEvaluator() {
            super(ValueType.PBYTE_TYPE, Operator.NOTMEMBEROF);
        }

        public String toString() {
            return "Byte not memberOf";
        }
    }

    static class ByteMemberOfEvaluator
    extends BaseMemberOfEvaluator {
        private static final long serialVersionUID = 320L;
        public static final Evaluator INSTANCE = new ByteMemberOfEvaluator();

        private ByteMemberOfEvaluator() {
            super(ValueType.PBYTE_TYPE, Operator.MEMBEROF);
        }

        public String toString() {
            return "Byte memberOf";
        }
    }

    static class ByteGreaterOrEqualEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 8173066470532237341L;
        private static final Evaluator INSTANCE = new ByteGreaterOrEqualEvaluator();

        private ByteGreaterOrEqualEvaluator() {
            super(ValueType.PBYTE_TYPE, Operator.GREATER_OR_EQUAL);
        }

        public boolean evaluate(Extractor extractor, Object object1, FieldValue object2) {
            if (extractor.isNullValue(object1)) {
                return false;
            }
            return extractor.getByteValue(object1) >= object2.getByteValue();
        }

        public boolean evaluateCachedRight(VariableRestriction.VariableContextEntry context, Object left) {
            if (context.rightNull) {
                return false;
            }
            return ((VariableRestriction.LongVariableContextEntry)context).right >= (long)context.declaration.getExtractor().getByteValue(left);
        }

        public boolean evaluateCachedLeft(VariableRestriction.VariableContextEntry context, Object right) {
            if (context.extractor.isNullValue(right)) {
                return false;
            }
            return (long)context.extractor.getByteValue(right) >= ((VariableRestriction.LongVariableContextEntry)context).left;
        }

        public boolean evaluate(Extractor extractor1, Object object1, Extractor extractor2, Object object2) {
            if (extractor1.isNullValue(object1)) {
                return false;
            }
            return extractor1.getByteValue(object1) >= extractor2.getByteValue(object2);
        }

        public String toString() {
            return "Byte >=";
        }
    }

    static class ByteGreaterEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = -3319688501086570921L;
        public static final Evaluator INSTANCE = new ByteGreaterEvaluator();

        private ByteGreaterEvaluator() {
            super(ValueType.PBYTE_TYPE, Operator.GREATER);
        }

        public boolean evaluate(Extractor extractor, Object object1, FieldValue object2) {
            if (extractor.isNullValue(object1)) {
                return false;
            }
            return extractor.getByteValue(object1) > object2.getByteValue();
        }

        public boolean evaluateCachedRight(VariableRestriction.VariableContextEntry context, Object left) {
            if (context.rightNull) {
                return false;
            }
            return ((VariableRestriction.LongVariableContextEntry)context).right > (long)context.declaration.getExtractor().getByteValue(left);
        }

        public boolean evaluateCachedLeft(VariableRestriction.VariableContextEntry context, Object right) {
            if (context.extractor.isNullValue(right)) {
                return false;
            }
            return (long)context.extractor.getByteValue(right) > ((VariableRestriction.LongVariableContextEntry)context).left;
        }

        public boolean evaluate(Extractor extractor1, Object object1, Extractor extractor2, Object object2) {
            if (extractor1.isNullValue(object1)) {
                return false;
            }
            return extractor1.getByteValue(object1) > extractor2.getByteValue(object2);
        }

        public String toString() {
            return "Byte >";
        }
    }

    static class ByteLessOrEqualEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 5455645713080692170L;
        public static final Evaluator INSTANCE = new ByteLessOrEqualEvaluator();

        private ByteLessOrEqualEvaluator() {
            super(ValueType.PBYTE_TYPE, Operator.LESS_OR_EQUAL);
        }

        public boolean evaluate(Extractor extractor, Object object1, FieldValue object2) {
            if (extractor.isNullValue(object1)) {
                return false;
            }
            return extractor.getByteValue(object1) <= object2.getByteValue();
        }

        public boolean evaluateCachedRight(VariableRestriction.VariableContextEntry context, Object left) {
            if (context.rightNull) {
                return false;
            }
            return ((VariableRestriction.LongVariableContextEntry)context).right <= (long)context.declaration.getExtractor().getByteValue(left);
        }

        public boolean evaluateCachedLeft(VariableRestriction.VariableContextEntry context, Object right) {
            if (context.extractor.isNullValue(right)) {
                return false;
            }
            return (long)context.extractor.getByteValue(right) <= ((VariableRestriction.LongVariableContextEntry)context).left;
        }

        public boolean evaluate(Extractor extractor1, Object object1, Extractor extractor2, Object object2) {
            if (extractor1.isNullValue(object1)) {
                return false;
            }
            return extractor1.getByteValue(object1) <= extractor2.getByteValue(object2);
        }

        public String toString() {
            return "Byte <=";
        }
    }

    static class ByteLessEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 7327200711399789849L;
        public static final Evaluator INSTANCE = new ByteLessEvaluator();

        private ByteLessEvaluator() {
            super(ValueType.PBYTE_TYPE, Operator.LESS);
        }

        public boolean evaluate(Extractor extractor, Object object1, FieldValue object2) {
            if (extractor.isNullValue(object1)) {
                return false;
            }
            return extractor.getByteValue(object1) < object2.getByteValue();
        }

        public boolean evaluateCachedRight(VariableRestriction.VariableContextEntry context, Object left) {
            if (context.rightNull) {
                return false;
            }
            return ((VariableRestriction.LongVariableContextEntry)context).right < (long)context.declaration.getExtractor().getByteValue(left);
        }

        public boolean evaluateCachedLeft(VariableRestriction.VariableContextEntry context, Object right) {
            if (context.extractor.isNullValue(right)) {
                return false;
            }
            return (long)context.extractor.getByteValue(right) < ((VariableRestriction.LongVariableContextEntry)context).left;
        }

        public boolean evaluate(Extractor extractor1, Object object1, Extractor extractor2, Object object2) {
            if (extractor1.isNullValue(object1)) {
                return false;
            }
            return extractor1.getByteValue(object1) < extractor2.getByteValue(object2);
        }

        public String toString() {
            return "Byte <";
        }
    }

    static class ByteNotEqualEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 1745720793613936221L;
        public static final Evaluator INSTANCE = new ByteNotEqualEvaluator();

        private ByteNotEqualEvaluator() {
            super(ValueType.PBYTE_TYPE, Operator.NOT_EQUAL);
        }

        public boolean evaluate(Extractor extractor, Object object1, FieldValue object2) {
            if (extractor.isNullValue(object1)) {
                return !object2.isNull();
            }
            if (object2.isNull()) {
                return true;
            }
            return extractor.getByteValue(object1) != object2.getByteValue();
        }

        public boolean evaluateCachedRight(VariableRestriction.VariableContextEntry context, Object left) {
            if (context.declaration.getExtractor().isNullValue(left)) {
                return !context.isRightNull();
            }
            if (context.isRightNull()) {
                return true;
            }
            return (long)context.declaration.getExtractor().getByteValue(left) != ((VariableRestriction.LongVariableContextEntry)context).right;
        }

        public boolean evaluateCachedLeft(VariableRestriction.VariableContextEntry context, Object object2) {
            if (context.extractor.isNullValue(object2)) {
                return !context.isLeftNull();
            }
            if (context.isLeftNull()) {
                return true;
            }
            return ((VariableRestriction.LongVariableContextEntry)context).left != (long)context.extractor.getByteValue(object2);
        }

        public boolean evaluate(Extractor extractor1, Object object1, Extractor extractor2, Object object2) {
            if (extractor1.isNullValue(object1)) {
                return !extractor2.isNullValue(object2);
            }
            if (extractor2.isNullValue(object2)) {
                return true;
            }
            return extractor1.getByteValue(object1) != extractor2.getByteValue(object2);
        }

        public String toString() {
            return "Byte !=";
        }
    }

    static class ByteEqualEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = -2123381297852695049L;
        public static final Evaluator INSTANCE = new ByteEqualEvaluator();

        private ByteEqualEvaluator() {
            super(ValueType.PBYTE_TYPE, Operator.EQUAL);
        }

        public boolean evaluate(Extractor extractor, Object object1, FieldValue object2) {
            if (extractor.isNullValue(object1)) {
                return object2.isNull();
            }
            if (object2.isNull()) {
                return false;
            }
            return extractor.getByteValue(object1) == object2.getByteValue();
        }

        public boolean evaluateCachedRight(VariableRestriction.VariableContextEntry context, Object left) {
            if (context.declaration.getExtractor().isNullValue(left)) {
                return context.isRightNull();
            }
            if (context.isRightNull()) {
                return false;
            }
            return (long)context.declaration.getExtractor().getByteValue(left) == ((VariableRestriction.LongVariableContextEntry)context).right;
        }

        public boolean evaluateCachedLeft(VariableRestriction.VariableContextEntry context, Object right) {
            if (context.extractor.isNullValue(right)) {
                return context.isLeftNull();
            }
            if (context.isLeftNull()) {
                return false;
            }
            return ((VariableRestriction.LongVariableContextEntry)context).left == (long)context.extractor.getByteValue(right);
        }

        public boolean evaluate(Extractor extractor1, Object object1, Extractor extractor2, Object object2) {
            if (extractor1.isNullValue(object1)) {
                return extractor2.isNullValue(object2);
            }
            if (extractor2.isNullValue(object2)) {
                return false;
            }
            return extractor1.getByteValue(object1) == extractor2.getByteValue(object2);
        }

        public String toString() {
            return "Byte ==";
        }
    }
}

