/*
 * Decompiled with CFR 0.152.
 */
package org.drools.base.evaluators;

import org.drools.base.BaseEvaluator;
import org.drools.base.ValueType;
import org.drools.base.evaluators.BaseMemberOfEvaluator;
import org.drools.base.evaluators.BaseNotMemberOfEvaluator;
import org.drools.base.evaluators.EvaluatorFactory;
import org.drools.base.evaluators.Operator;
import org.drools.rule.VariableRestriction;
import org.drools.spi.Evaluator;
import org.drools.spi.Extractor;
import org.drools.spi.FieldValue;

public class FloatFactory
implements EvaluatorFactory {
    private static final long serialVersionUID = -4254964760901343619L;
    private static EvaluatorFactory INSTANCE = new FloatFactory();

    private FloatFactory() {
    }

    public static EvaluatorFactory getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new FloatFactory();
        }
        return INSTANCE;
    }

    public Evaluator getEvaluator(Operator operator) {
        if (operator == Operator.EQUAL) {
            return FloatEqualEvaluator.INSTANCE;
        }
        if (operator == Operator.NOT_EQUAL) {
            return FloatNotEqualEvaluator.INSTANCE;
        }
        if (operator == Operator.LESS) {
            return FloatLessEvaluator.INSTANCE;
        }
        if (operator == Operator.LESS_OR_EQUAL) {
            return FloatLessOrEqualEvaluator.INSTANCE;
        }
        if (operator == Operator.GREATER) {
            return FloatGreaterEvaluator.INSTANCE;
        }
        if (operator == Operator.GREATER_OR_EQUAL) {
            return FloatGreaterOrEqualEvaluator.INSTANCE;
        }
        if (operator == Operator.MEMBEROF) {
            return FloatMemberOfEvaluator.INSTANCE;
        }
        if (operator == Operator.NOTMEMBEROF) {
            return FloatNotMemberOfEvaluator.INSTANCE;
        }
        throw new RuntimeException("Operator '" + operator + "' does not exist for FloatEvaluator");
    }

    static class FloatNotMemberOfEvaluator
    extends BaseNotMemberOfEvaluator {
        private static final long serialVersionUID = 320L;
        public static final Evaluator INSTANCE = new FloatNotMemberOfEvaluator();

        private FloatNotMemberOfEvaluator() {
            super(ValueType.PFLOAT_TYPE, Operator.NOTMEMBEROF);
        }

        public String toString() {
            return "Float not memberOf";
        }
    }

    static class FloatMemberOfEvaluator
    extends BaseMemberOfEvaluator {
        private static final long serialVersionUID = 320L;
        public static final Evaluator INSTANCE = new FloatMemberOfEvaluator();

        private FloatMemberOfEvaluator() {
            super(ValueType.PFLOAT_TYPE, Operator.MEMBEROF);
        }

        public String toString() {
            return "Float memberOf";
        }
    }

    static class FloatGreaterOrEqualEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 320L;
        private static final Evaluator INSTANCE = new FloatGreaterOrEqualEvaluator();

        private FloatGreaterOrEqualEvaluator() {
            super(ValueType.PFLOAT_TYPE, Operator.GREATER_OR_EQUAL);
        }

        public boolean evaluate(Extractor extractor, Object object1, FieldValue object2) {
            if (extractor.isNullValue(object1)) {
                return false;
            }
            return extractor.getFloatValue(object1) >= object2.getFloatValue();
        }

        public boolean evaluateCachedRight(VariableRestriction.VariableContextEntry context, Object left) {
            if (context.rightNull) {
                return false;
            }
            return ((VariableRestriction.DoubleVariableContextEntry)context).right >= (double)context.declaration.getExtractor().getFloatValue(left);
        }

        public boolean evaluateCachedLeft(VariableRestriction.VariableContextEntry context, Object right) {
            if (context.extractor.isNullValue(right)) {
                return false;
            }
            return (double)context.extractor.getFloatValue(right) >= ((VariableRestriction.DoubleVariableContextEntry)context).left;
        }

        public boolean evaluate(Extractor extractor1, Object object1, Extractor extractor2, Object object2) {
            if (extractor1.isNullValue(object1)) {
                return false;
            }
            return extractor1.getFloatValue(object1) >= extractor2.getFloatValue(object2);
        }

        public String toString() {
            return "Float >=";
        }
    }

    static class FloatGreaterEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 320L;
        public static final Evaluator INSTANCE = new FloatGreaterEvaluator();

        private FloatGreaterEvaluator() {
            super(ValueType.PFLOAT_TYPE, Operator.GREATER);
        }

        public boolean evaluate(Extractor extractor, Object object1, FieldValue object2) {
            if (extractor.isNullValue(object1)) {
                return false;
            }
            return extractor.getFloatValue(object1) > object2.getFloatValue();
        }

        public boolean evaluateCachedRight(VariableRestriction.VariableContextEntry context, Object left) {
            if (context.rightNull) {
                return false;
            }
            return ((VariableRestriction.DoubleVariableContextEntry)context).right > (double)context.declaration.getExtractor().getFloatValue(left);
        }

        public boolean evaluateCachedLeft(VariableRestriction.VariableContextEntry context, Object right) {
            if (context.extractor.isNullValue(right)) {
                return false;
            }
            return (double)context.extractor.getFloatValue(right) > ((VariableRestriction.DoubleVariableContextEntry)context).left;
        }

        public boolean evaluate(Extractor extractor1, Object object1, Extractor extractor2, Object object2) {
            if (extractor1.isNullValue(object1)) {
                return false;
            }
            return extractor1.getFloatValue(object1) > extractor2.getFloatValue(object2);
        }

        public String toString() {
            return "Float >";
        }
    }

    static class FloatLessOrEqualEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 320L;
        public static final Evaluator INSTANCE = new FloatLessOrEqualEvaluator();

        private FloatLessOrEqualEvaluator() {
            super(ValueType.PFLOAT_TYPE, Operator.LESS_OR_EQUAL);
        }

        public boolean evaluate(Extractor extractor, Object object1, FieldValue object2) {
            if (extractor.isNullValue(object1)) {
                return false;
            }
            return extractor.getFloatValue(object1) <= object2.getFloatValue();
        }

        public boolean evaluateCachedRight(VariableRestriction.VariableContextEntry context, Object left) {
            if (context.rightNull) {
                return false;
            }
            return ((VariableRestriction.DoubleVariableContextEntry)context).right <= (double)context.declaration.getExtractor().getFloatValue(left);
        }

        public boolean evaluateCachedLeft(VariableRestriction.VariableContextEntry context, Object right) {
            if (context.extractor.isNullValue(right)) {
                return false;
            }
            return (double)context.extractor.getFloatValue(right) <= ((VariableRestriction.DoubleVariableContextEntry)context).left;
        }

        public boolean evaluate(Extractor extractor1, Object object1, Extractor extractor2, Object object2) {
            if (extractor1.isNullValue(object1)) {
                return false;
            }
            return extractor1.getFloatValue(object1) <= extractor2.getFloatValue(object2);
        }

        public String toString() {
            return "Float <=";
        }
    }

    static class FloatLessEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 320L;
        public static final Evaluator INSTANCE = new FloatLessEvaluator();

        private FloatLessEvaluator() {
            super(ValueType.PFLOAT_TYPE, Operator.LESS);
        }

        public boolean evaluate(Extractor extractor, Object object1, FieldValue object2) {
            if (extractor.isNullValue(object1)) {
                return false;
            }
            return extractor.getFloatValue(object1) < object2.getFloatValue();
        }

        public boolean evaluateCachedRight(VariableRestriction.VariableContextEntry context, Object left) {
            if (context.rightNull) {
                return false;
            }
            return ((VariableRestriction.DoubleVariableContextEntry)context).right < (double)context.declaration.getExtractor().getFloatValue(left);
        }

        public boolean evaluateCachedLeft(VariableRestriction.VariableContextEntry context, Object right) {
            if (context.extractor.isNullValue(right)) {
                return false;
            }
            return (double)context.extractor.getFloatValue(right) < ((VariableRestriction.DoubleVariableContextEntry)context).left;
        }

        public boolean evaluate(Extractor extractor1, Object object1, Extractor extractor2, Object object2) {
            if (extractor1.isNullValue(object1)) {
                return false;
            }
            return extractor1.getFloatValue(object1) < extractor2.getFloatValue(object2);
        }

        public String toString() {
            return "Float <";
        }
    }

    static class FloatNotEqualEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 320L;
        public static final Evaluator INSTANCE = new FloatNotEqualEvaluator();

        private FloatNotEqualEvaluator() {
            super(ValueType.PFLOAT_TYPE, Operator.NOT_EQUAL);
        }

        public boolean evaluate(Extractor extractor, Object object1, FieldValue object2) {
            if (extractor.isNullValue(object1)) {
                return !object2.isNull();
            }
            if (object2.isNull()) {
                return true;
            }
            return extractor.getFloatValue(object1) != object2.getFloatValue();
        }

        public boolean evaluateCachedRight(VariableRestriction.VariableContextEntry context, Object left) {
            if (context.declaration.getExtractor().isNullValue(left)) {
                return !context.isRightNull();
            }
            if (context.isRightNull()) {
                return true;
            }
            return (double)context.declaration.getExtractor().getFloatValue(left) != ((VariableRestriction.DoubleVariableContextEntry)context).right;
        }

        public boolean evaluateCachedLeft(VariableRestriction.VariableContextEntry context, Object right) {
            if (context.extractor.isNullValue(right)) {
                return !context.isLeftNull();
            }
            if (context.isLeftNull()) {
                return true;
            }
            return ((VariableRestriction.DoubleVariableContextEntry)context).left != (double)context.extractor.getFloatValue(right);
        }

        public boolean evaluate(Extractor extractor1, Object object1, Extractor extractor2, Object object2) {
            if (extractor1.isNullValue(object1)) {
                return !extractor2.isNullValue(object2);
            }
            if (extractor2.isNullValue(object2)) {
                return true;
            }
            return extractor1.getFloatValue(object1) != extractor2.getFloatValue(object2);
        }

        public String toString() {
            return "Float !=";
        }
    }

    static class FloatEqualEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 320L;
        public static final Evaluator INSTANCE = new FloatEqualEvaluator();

        private FloatEqualEvaluator() {
            super(ValueType.PFLOAT_TYPE, Operator.EQUAL);
        }

        public boolean evaluate(Extractor extractor, Object object1, FieldValue object2) {
            if (extractor.isNullValue(object1)) {
                return object2.isNull();
            }
            if (object2.isNull()) {
                return false;
            }
            return extractor.getFloatValue(object1) == object2.getFloatValue();
        }

        public boolean evaluateCachedRight(VariableRestriction.VariableContextEntry context, Object left) {
            if (context.declaration.getExtractor().isNullValue(left)) {
                return context.isRightNull();
            }
            if (context.isRightNull()) {
                return false;
            }
            return (double)context.declaration.getExtractor().getFloatValue(left) == ((VariableRestriction.DoubleVariableContextEntry)context).right;
        }

        public boolean evaluateCachedLeft(VariableRestriction.VariableContextEntry context, Object right) {
            if (context.extractor.isNullValue(right)) {
                return context.isLeftNull();
            }
            if (context.isLeftNull()) {
                return false;
            }
            return ((VariableRestriction.DoubleVariableContextEntry)context).left == (double)context.extractor.getFloatValue(right);
        }

        public boolean evaluate(Extractor extractor1, Object object1, Extractor extractor2, Object object2) {
            if (extractor1.isNullValue(object1)) {
                return extractor2.isNullValue(object2);
            }
            if (extractor2.isNullValue(object2)) {
                return false;
            }
            return extractor1.getFloatValue(object1) == extractor2.getFloatValue(object2);
        }

        public String toString() {
            return "Float ==";
        }
    }
}

