/*
 * Decompiled with CFR 0.152.
 */
package org.drools.base.evaluators;

import org.drools.base.BaseEvaluator;
import org.drools.base.ValueType;
import org.drools.base.evaluators.BaseMemberOfEvaluator;
import org.drools.base.evaluators.BaseNotMemberOfEvaluator;
import org.drools.base.evaluators.EvaluatorFactory;
import org.drools.base.evaluators.Operator;
import org.drools.rule.VariableRestriction;
import org.drools.spi.Evaluator;
import org.drools.spi.Extractor;
import org.drools.spi.FieldValue;

public class LongFactory
implements EvaluatorFactory {
    private static final long serialVersionUID = 4184811148799115566L;
    private static EvaluatorFactory INSTANCE = new LongFactory();

    private LongFactory() {
    }

    public static EvaluatorFactory getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new LongFactory();
        }
        return INSTANCE;
    }

    public Evaluator getEvaluator(Operator operator) {
        if (operator == Operator.EQUAL) {
            return LongEqualEvaluator.INSTANCE;
        }
        if (operator == Operator.NOT_EQUAL) {
            return LongNotEqualEvaluator.INSTANCE;
        }
        if (operator == Operator.LESS) {
            return LongLessEvaluator.INSTANCE;
        }
        if (operator == Operator.LESS_OR_EQUAL) {
            return LongLessOrEqualEvaluator.INSTANCE;
        }
        if (operator == Operator.GREATER) {
            return LongGreaterEvaluator.INSTANCE;
        }
        if (operator == Operator.GREATER_OR_EQUAL) {
            return LongGreaterOrEqualEvaluator.INSTANCE;
        }
        if (operator == Operator.MEMBEROF) {
            return LongMemberOfEvaluator.INSTANCE;
        }
        if (operator == Operator.NOTMEMBEROF) {
            return LongNotMemberOfEvaluator.INSTANCE;
        }
        throw new RuntimeException("Operator '" + operator + "' does not exist for LongEvaluator");
    }

    static class LongNotMemberOfEvaluator
    extends BaseNotMemberOfEvaluator {
        private static final long serialVersionUID = 320L;
        public static final Evaluator INSTANCE = new LongNotMemberOfEvaluator();

        private LongNotMemberOfEvaluator() {
            super(ValueType.PLONG_TYPE, Operator.NOTMEMBEROF);
        }

        public String toString() {
            return "Long not memberOf";
        }
    }

    static class LongMemberOfEvaluator
    extends BaseMemberOfEvaluator {
        private static final long serialVersionUID = 320L;
        public static final Evaluator INSTANCE = new LongMemberOfEvaluator();

        private LongMemberOfEvaluator() {
            super(ValueType.PLONG_TYPE, Operator.MEMBEROF);
        }

        public String toString() {
            return "Long memberOf";
        }
    }

    static class LongGreaterOrEqualEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 320L;
        private static final Evaluator INSTANCE = new LongGreaterOrEqualEvaluator();

        private LongGreaterOrEqualEvaluator() {
            super(ValueType.PLONG_TYPE, Operator.GREATER_OR_EQUAL);
        }

        public boolean evaluate(Extractor extractor, Object object1, FieldValue object2) {
            if (extractor.isNullValue(object1)) {
                return false;
            }
            return extractor.getLongValue(object1) >= object2.getLongValue();
        }

        public boolean evaluateCachedRight(VariableRestriction.VariableContextEntry context, Object left) {
            if (context.rightNull) {
                return false;
            }
            return ((VariableRestriction.LongVariableContextEntry)context).right >= context.declaration.getExtractor().getLongValue(left);
        }

        public boolean evaluateCachedLeft(VariableRestriction.VariableContextEntry context, Object right) {
            if (context.extractor.isNullValue(right)) {
                return false;
            }
            return context.extractor.getLongValue(right) >= ((VariableRestriction.LongVariableContextEntry)context).left;
        }

        public boolean evaluate(Extractor extractor1, Object object1, Extractor extractor2, Object object2) {
            if (extractor1.isNullValue(object1)) {
                return false;
            }
            return extractor1.getLongValue(object1) >= extractor2.getLongValue(object2);
        }

        public String toString() {
            return "Long >=";
        }
    }

    static class LongGreaterEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 320L;
        public static final Evaluator INSTANCE = new LongGreaterEvaluator();

        private LongGreaterEvaluator() {
            super(ValueType.PLONG_TYPE, Operator.GREATER);
        }

        public boolean evaluate(Extractor extractor, Object object1, FieldValue object2) {
            if (extractor.isNullValue(object1)) {
                return false;
            }
            return extractor.getLongValue(object1) > object2.getLongValue();
        }

        public boolean evaluateCachedRight(VariableRestriction.VariableContextEntry context, Object left) {
            if (context.rightNull) {
                return false;
            }
            return ((VariableRestriction.LongVariableContextEntry)context).right > context.declaration.getExtractor().getLongValue(left);
        }

        public boolean evaluateCachedLeft(VariableRestriction.VariableContextEntry context, Object right) {
            if (context.extractor.isNullValue(right)) {
                return false;
            }
            return context.extractor.getLongValue(right) > ((VariableRestriction.LongVariableContextEntry)context).left;
        }

        public boolean evaluate(Extractor extractor1, Object object1, Extractor extractor2, Object object2) {
            if (extractor1.isNullValue(object1)) {
                return false;
            }
            return extractor1.getLongValue(object1) > extractor2.getLongValue(object2);
        }

        public String toString() {
            return "Long >";
        }
    }

    static class LongLessOrEqualEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 320L;
        public static final Evaluator INSTANCE = new LongLessOrEqualEvaluator();

        private LongLessOrEqualEvaluator() {
            super(ValueType.PLONG_TYPE, Operator.LESS_OR_EQUAL);
        }

        public boolean evaluate(Extractor extractor, Object object1, FieldValue object2) {
            if (extractor.isNullValue(object1)) {
                return false;
            }
            return extractor.getLongValue(object1) <= object2.getLongValue();
        }

        public boolean evaluateCachedRight(VariableRestriction.VariableContextEntry context, Object left) {
            if (context.rightNull) {
                return false;
            }
            return ((VariableRestriction.LongVariableContextEntry)context).right <= context.declaration.getExtractor().getLongValue(left);
        }

        public boolean evaluateCachedLeft(VariableRestriction.VariableContextEntry context, Object right) {
            if (context.extractor.isNullValue(right)) {
                return false;
            }
            return context.extractor.getLongValue(right) <= ((VariableRestriction.LongVariableContextEntry)context).left;
        }

        public boolean evaluate(Extractor extractor1, Object object1, Extractor extractor2, Object object2) {
            if (extractor1.isNullValue(object1)) {
                return false;
            }
            return extractor1.getLongValue(object1) <= extractor2.getLongValue(object2);
        }

        public String toString() {
            return "Long <=";
        }
    }

    static class LongLessEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 320L;
        public static final Evaluator INSTANCE = new LongLessEvaluator();

        private LongLessEvaluator() {
            super(ValueType.PLONG_TYPE, Operator.LESS);
        }

        public boolean evaluate(Extractor extractor, Object object1, FieldValue object2) {
            if (extractor.isNullValue(object1)) {
                return false;
            }
            return extractor.getLongValue(object1) < object2.getLongValue();
        }

        public boolean evaluateCachedRight(VariableRestriction.VariableContextEntry context, Object left) {
            if (context.rightNull) {
                return false;
            }
            return ((VariableRestriction.LongVariableContextEntry)context).right < context.declaration.getExtractor().getLongValue(left);
        }

        public boolean evaluateCachedLeft(VariableRestriction.VariableContextEntry context, Object right) {
            if (context.extractor.isNullValue(right)) {
                return false;
            }
            return context.extractor.getLongValue(right) < ((VariableRestriction.LongVariableContextEntry)context).left;
        }

        public boolean evaluate(Extractor extractor1, Object object1, Extractor extractor2, Object object2) {
            if (extractor1.isNullValue(object1)) {
                return false;
            }
            return extractor1.getLongValue(object1) < extractor2.getLongValue(object2);
        }

        public String toString() {
            return "Long <";
        }
    }

    static class LongNotEqualEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 320L;
        public static final Evaluator INSTANCE = new LongNotEqualEvaluator();

        private LongNotEqualEvaluator() {
            super(ValueType.PLONG_TYPE, Operator.NOT_EQUAL);
        }

        public boolean evaluate(Extractor extractor, Object object1, FieldValue object2) {
            if (extractor.isNullValue(object1)) {
                return !object2.isNull();
            }
            if (object2.isNull()) {
                return true;
            }
            return extractor.getLongValue(object1) != object2.getLongValue();
        }

        public boolean evaluateCachedRight(VariableRestriction.VariableContextEntry context, Object left) {
            if (context.declaration.getExtractor().isNullValue(left)) {
                return !context.isRightNull();
            }
            if (context.isRightNull()) {
                return true;
            }
            return context.declaration.getExtractor().getLongValue(left) != ((VariableRestriction.LongVariableContextEntry)context).right;
        }

        public boolean evaluateCachedLeft(VariableRestriction.VariableContextEntry context, Object right) {
            if (context.extractor.isNullValue(right)) {
                return !context.isLeftNull();
            }
            if (context.isLeftNull()) {
                return true;
            }
            return ((VariableRestriction.LongVariableContextEntry)context).left != context.extractor.getLongValue(right);
        }

        public boolean evaluate(Extractor extractor1, Object object1, Extractor extractor2, Object object2) {
            if (extractor1.isNullValue(object1)) {
                return !extractor2.isNullValue(object2);
            }
            if (extractor2.isNullValue(object2)) {
                return true;
            }
            return extractor1.getLongValue(object1) != extractor2.getLongValue(object2);
        }

        public String toString() {
            return "Long !=";
        }
    }

    static class LongEqualEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 320L;
        public static final Evaluator INSTANCE = new LongEqualEvaluator();

        private LongEqualEvaluator() {
            super(ValueType.PLONG_TYPE, Operator.EQUAL);
        }

        public boolean evaluate(Extractor extractor, Object object1, FieldValue object2) {
            if (extractor.isNullValue(object1)) {
                return object2.isNull();
            }
            if (object2.isNull()) {
                return false;
            }
            return extractor.getLongValue(object1) == object2.getLongValue();
        }

        public boolean evaluateCachedRight(VariableRestriction.VariableContextEntry context, Object left) {
            if (context.declaration.getExtractor().isNullValue(left)) {
                return context.isRightNull();
            }
            if (context.isRightNull()) {
                return false;
            }
            return context.declaration.getExtractor().getLongValue(left) == ((VariableRestriction.LongVariableContextEntry)context).right;
        }

        public boolean evaluateCachedLeft(VariableRestriction.VariableContextEntry context, Object right) {
            if (context.extractor.isNullValue(right)) {
                return context.isLeftNull();
            }
            if (context.isLeftNull()) {
                return false;
            }
            return ((VariableRestriction.LongVariableContextEntry)context).left == context.extractor.getLongValue(right);
        }

        public boolean evaluate(Extractor extractor1, Object object1, Extractor extractor2, Object object2) {
            if (extractor1.isNullValue(object1)) {
                return extractor2.isNullValue(object2);
            }
            if (extractor2.isNullValue(object2)) {
                return false;
            }
            return extractor1.getLongValue(object1) == extractor2.getLongValue(object2);
        }

        public String toString() {
            return "Long ==";
        }
    }
}

