/*
 * Decompiled with CFR 0.152.
 */
package org.drools.base.evaluators;

import java.io.ObjectStreamException;
import java.io.Serializable;
import org.drools.RuntimeDroolsException;

public class Operator
implements Serializable {
    private static final long serialVersionUID = 320L;
    public static final Operator EQUAL = new Operator("==");
    public static final Operator NOT_EQUAL = new Operator("!=");
    public static final Operator LESS = new Operator("<");
    public static final Operator LESS_OR_EQUAL = new Operator("<=");
    public static final Operator GREATER = new Operator(">");
    public static final Operator GREATER_OR_EQUAL = new Operator(">=");
    public static final Operator CONTAINS = new Operator("contains");
    public static final Operator MATCHES = new Operator("matches");
    public static final Operator EXCLUDES = new Operator("excludes");
    public static final Operator MEMBEROF = new Operator("memberOf");
    public static final Operator NOTMEMBEROF = new Operator("not memberOf");
    private String operator;

    private Operator(String operator) {
        this.operator = operator;
    }

    private Object readResolve() throws ObjectStreamException {
        return Operator.determineOperator(this.operator);
    }

    public static Operator determineOperator(String string) {
        if (string.equals("==")) {
            return EQUAL;
        }
        if (string.equals("!=")) {
            return NOT_EQUAL;
        }
        if (string.equals("<")) {
            return LESS;
        }
        if (string.equals("<=")) {
            return LESS_OR_EQUAL;
        }
        if (string.equals(">")) {
            return GREATER;
        }
        if (string.equals(">=")) {
            return GREATER_OR_EQUAL;
        }
        if (string.equals("contains")) {
            return CONTAINS;
        }
        if (string.equals("matches")) {
            return MATCHES;
        }
        if (string.equals("excludes")) {
            return EXCLUDES;
        }
        if (string.equals("memberOf")) {
            return MEMBEROF;
        }
        if (string.equals("not memberOf")) {
            return NOTMEMBEROF;
        }
        throw new RuntimeDroolsException("unable to determine operator for String [" + string + "]");
    }

    public String toString() {
        return "Operator = '" + this.operator + "'";
    }

    public int hashCode() {
        return this.operator.hashCode();
    }

    public boolean equals(Object object) {
        return object == this;
    }
}

