/*
 * Decompiled with CFR 0.152.
 */
package org.drools.base.extractors;

import java.lang.reflect.Method;
import org.drools.RuntimeDroolsException;
import org.drools.base.BaseClassFieldExtractor;
import org.drools.base.ValueType;

public abstract class BaseDoubleClassFieldExtractor
extends BaseClassFieldExtractor {
    private static final long serialVersionUID = 20311112843487706L;

    public BaseDoubleClassFieldExtractor(Class clazz, String fieldName) {
        super(clazz, fieldName);
    }

    protected BaseDoubleClassFieldExtractor(int index, Class fieldType, ValueType valueType) {
        super(index, fieldType, valueType);
    }

    public Object getValue(Object object) {
        return new Double(this.getDoubleValue(object));
    }

    public boolean getBooleanValue(Object object) {
        throw new RuntimeDroolsException("Conversion to boolean not supported from double");
    }

    public byte getByteValue(Object object) {
        return (byte)this.getDoubleValue(object);
    }

    public char getCharValue(Object object) {
        throw new RuntimeDroolsException("Conversion to char not supported from double");
    }

    public abstract double getDoubleValue(Object var1);

    public float getFloatValue(Object object) {
        return (float)this.getDoubleValue(object);
    }

    public int getIntValue(Object object) {
        return (int)this.getDoubleValue(object);
    }

    public long getLongValue(Object object) {
        return (long)this.getDoubleValue(object);
    }

    public short getShortValue(Object object) {
        return (short)this.getDoubleValue(object);
    }

    public boolean isNullValue(Object object) {
        return false;
    }

    public Method getNativeReadMethod() {
        try {
            return this.getClass().getDeclaredMethod("getDoubleValue", Object.class);
        }
        catch (Exception e) {
            throw new RuntimeDroolsException("This is a bug. Please report to development team: " + e.getMessage(), e);
        }
    }

    public int getHashCode(Object object) {
        long temp = Double.doubleToLongBits(this.getDoubleValue(object));
        return (int)(temp ^ temp >>> 32);
    }
}

