/*
 * Decompiled with CFR 0.152.
 */
package org.drools.base.extractors;

import java.lang.reflect.Method;
import org.drools.RuntimeDroolsException;
import org.drools.base.BaseClassFieldExtractor;
import org.drools.base.ValueType;

public abstract class BaseFloatClassFieldExtractor
extends BaseClassFieldExtractor {
    private static final long serialVersionUID = 20311112843487706L;

    public BaseFloatClassFieldExtractor(Class clazz, String fieldName) {
        super(clazz, fieldName);
    }

    protected BaseFloatClassFieldExtractor(int index, Class fieldType, ValueType valueType) {
        super(index, fieldType, valueType);
    }

    public Object getValue(Object object) {
        return new Float(this.getFloatValue(object));
    }

    public boolean getBooleanValue(Object object) {
        throw new RuntimeDroolsException("Conversion to boolean not supported from float");
    }

    public byte getByteValue(Object object) {
        return (byte)this.getFloatValue(object);
    }

    public char getCharValue(Object object) {
        throw new RuntimeDroolsException("Conversion to char not supported from float");
    }

    public double getDoubleValue(Object object) {
        return this.getFloatValue(object);
    }

    public abstract float getFloatValue(Object var1);

    public int getIntValue(Object object) {
        return (int)this.getFloatValue(object);
    }

    public long getLongValue(Object object) {
        return (long)this.getFloatValue(object);
    }

    public short getShortValue(Object object) {
        return (short)this.getFloatValue(object);
    }

    public boolean isNullValue(Object object) {
        return false;
    }

    public Method getNativeReadMethod() {
        try {
            return this.getClass().getDeclaredMethod("getFloatValue", Object.class);
        }
        catch (Exception e) {
            throw new RuntimeDroolsException("This is a bug. Please report to development team: " + e.getMessage(), e);
        }
    }

    public int getHashCode(Object object) {
        return Float.floatToIntBits(this.getFloatValue(object));
    }
}

