/*
 * Decompiled with CFR 0.152.
 */
package org.drools.base.extractors;

import java.lang.reflect.Method;
import org.drools.RuntimeDroolsException;
import org.drools.base.BaseClassFieldExtractor;
import org.drools.base.ValueType;

public abstract class BaseObjectClassFieldExtractor
extends BaseClassFieldExtractor {
    private static final long serialVersionUID = 91214567753008212L;

    protected BaseObjectClassFieldExtractor(int index, Class fieldType, ValueType valueType) {
        super(index, fieldType, valueType);
    }

    public BaseObjectClassFieldExtractor(Class clazz, String fieldName) {
        super(clazz, fieldName);
    }

    public abstract Object getValue(Object var1);

    public boolean getBooleanValue(Object object) {
        Object value = this.getValue(object);
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        throw new RuntimeDroolsException("Conversion to boolean not supported from " + value.getClass().getName());
    }

    public byte getByteValue(Object object) {
        Object value = this.getValue(object);
        if (value instanceof Number) {
            return ((Number)value).byteValue();
        }
        throw new RuntimeDroolsException("Conversion to byte not supported from " + value.getClass().getName());
    }

    public char getCharValue(Object object) {
        Object value = this.getValue(object);
        if (value instanceof Character) {
            return ((Character)value).charValue();
        }
        throw new RuntimeDroolsException("Conversion to char not supported from " + value.getClass().getName());
    }

    public double getDoubleValue(Object object) {
        Object value = this.getValue(object);
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        throw new RuntimeDroolsException("Conversion to double not supported from " + value.getClass().getName());
    }

    public float getFloatValue(Object object) {
        Object value = this.getValue(object);
        if (value instanceof Number) {
            return ((Number)value).floatValue();
        }
        throw new RuntimeDroolsException("Conversion to float not supported from " + value.getClass().getName());
    }

    public int getIntValue(Object object) {
        Object value = this.getValue(object);
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        throw new RuntimeDroolsException("Conversion to int not supported from " + value.getClass().getName());
    }

    public long getLongValue(Object object) {
        Object value = this.getValue(object);
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        throw new RuntimeDroolsException("Conversion to long not supported from " + value.getClass().getName());
    }

    public short getShortValue(Object object) {
        Object value = this.getValue(object);
        if (value instanceof Number) {
            return ((Number)value).shortValue();
        }
        throw new RuntimeDroolsException("Conversion to short not supported from " + value.getClass().getName());
    }

    public boolean isNullValue(Object object) {
        if (object == null) {
            return true;
        }
        return this.getValue(object) == null;
    }

    public Method getNativeReadMethod() {
        try {
            return this.getClass().getDeclaredMethod("getValue", Object.class);
        }
        catch (Exception e) {
            throw new RuntimeDroolsException("This is a bug. Please report to development team: " + e.getMessage(), e);
        }
    }

    public int getHashCode(Object object) {
        Object value = this.getValue(object);
        return value != null ? value.hashCode() : 0;
    }
}

