/*
 * Decompiled with CFR 0.152.
 */
package org.drools.common;

import org.drools.common.AgendaItem;
import org.drools.conflict.DepthConflictResolver;
import org.drools.spi.Activation;
import org.drools.spi.AgendaGroup;
import org.drools.util.BinaryHeapQueue;
import org.drools.util.Queueable;

public class AgendaGroupImpl
implements AgendaGroup {
    private static final long serialVersionUID = 320L;
    private final String name;
    private final BinaryHeapQueue queue;
    private boolean active;

    public AgendaGroupImpl(String name) {
        this.name = name;
        this.queue = new BinaryHeapQueue(DepthConflictResolver.getInstance());
    }

    public String getName() {
        return this.name;
    }

    public void clear() {
        this.queue.clear();
    }

    public int size() {
        return this.queue.size();
    }

    public void add(Activation activation) {
        this.queue.enqueue((Queueable)((Object)activation));
    }

    public Activation getNext() {
        return (Activation)((Object)this.queue.dequeue());
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean activate) {
        this.active = activate;
    }

    public boolean isEmpty() {
        return this.queue.isEmpty();
    }

    public Activation[] getActivations() {
        return (Activation[])this.queue.toArray(new AgendaItem[this.queue.size()]);
    }

    public Queueable[] getQueueable() {
        return this.queue.getQueueable();
    }

    public String toString() {
        return "AgendaGroup '" + this.name + "'";
    }

    public boolean equal(Object object) {
        if (object == null || !(object instanceof AgendaGroupImpl)) {
            return false;
        }
        return ((AgendaGroupImpl)object).name.equals(this.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }
}

