/*
 * Decompiled with CFR 0.152.
 */
package org.drools.common;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.util.HashMap;

public class ObjectInputStreamWithLoader
extends ObjectInputStream {
    private final ClassLoader classLoader;
    private static final HashMap primClasses = new HashMap(8, 1.0f);

    public ObjectInputStreamWithLoader(InputStream in, ClassLoader classLoader) throws IOException {
        super(in);
        this.classLoader = classLoader;
        this.enableResolveObject(true);
    }

    protected Class resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
        if (this.classLoader == null) {
            return super.resolveClass(desc);
        }
        String name = desc.getName();
        Class<?> clazz = (Class<?>)primClasses.get(name);
        if (clazz == null) {
            try {
                clazz = this.classLoader.loadClass(name);
            }
            catch (ClassNotFoundException cnf) {
                clazz = super.resolveClass(desc);
            }
        }
        return clazz;
    }

    static {
        primClasses.put("boolean", Boolean.TYPE);
        primClasses.put("byte", Byte.TYPE);
        primClasses.put("char", Character.TYPE);
        primClasses.put("short", Short.TYPE);
        primClasses.put("int", Integer.TYPE);
        primClasses.put("long", Long.TYPE);
        primClasses.put("float", Float.TYPE);
        primClasses.put("double", Double.TYPE);
        primClasses.put("void", Void.TYPE);
    }
}

