/*
 * Decompiled with CFR 0.152.
 */
package org.drools.common;

import org.drools.reteoo.ReteTuple;
import org.drools.rule.Rule;
import org.drools.spi.Activation;
import org.drools.spi.PropagationContext;
import org.drools.util.ObjectHashMap;

public class PropagationContextImpl
implements PropagationContext {
    private final int type;
    private final Rule rule;
    private final Activation activation;
    private final long propagationNumber;
    public final int activeActivations;
    public final int dormantActivations;
    public ObjectHashMap retracted;

    public PropagationContextImpl(long number, int type, Rule rule, Activation activation) {
        this.type = type;
        this.rule = rule;
        this.activation = activation;
        this.propagationNumber = number;
        this.activeActivations = 0;
        this.dormantActivations = 0;
    }

    public PropagationContextImpl(long number, int type, Rule rule, Activation activation, int activeActivations, int dormantActivations) {
        this.type = type;
        this.rule = rule;
        this.activation = activation;
        this.propagationNumber = number;
        this.activeActivations = activeActivations;
        this.dormantActivations = dormantActivations;
    }

    public long getPropagationNumber() {
        return this.propagationNumber;
    }

    public Rule getRuleOrigin() {
        return this.rule;
    }

    public Activation getActivationOrigin() {
        return this.activation;
    }

    public int getType() {
        return this.type;
    }

    public int getActiveActivations() {
        return this.activeActivations;
    }

    public int getDormantActivations() {
        return this.dormantActivations;
    }

    public void addRetractedTuple(Rule rule, Activation activation) {
        if (this.retracted == null) {
            this.retracted = new ObjectHashMap();
        }
        ReteTuple tuple = (ReteTuple)activation.getTuple();
        ObjectHashMap tuples = (ObjectHashMap)this.retracted.get(rule);
        if (tuples == null) {
            tuples = new ObjectHashMap();
            this.retracted.put(rule, tuples);
        }
        tuples.put(tuple, activation);
    }

    public Activation removeRetractedTuple(Rule rule, ReteTuple tuple) {
        if (this.retracted == null) {
            return null;
        }
        ObjectHashMap tuples = (ObjectHashMap)this.retracted.get(rule);
        if (tuples != null) {
            return (Activation)tuples.remove(tuple);
        }
        return null;
    }

    public void clearRetractedTuples() {
        this.retracted = null;
    }
}

