/*
 * Decompiled with CFR 0.152.
 */
package org.drools.common;

import java.util.Iterator;
import org.drools.common.AgendaGroupImpl;
import org.drools.common.InternalRuleFlowGroup;
import org.drools.common.InternalWorkingMemory;
import org.drools.common.RuleFlowGroupNode;
import org.drools.common.WorkingMemoryAction;
import org.drools.ruleflow.instance.IRuleFlowNodeInstance;
import org.drools.ruleflow.instance.impl.RuleFlowSequenceNodeInstance;
import org.drools.spi.Activation;
import org.drools.util.LinkedList;

public class RuleFlowGroupImpl
extends RuleFlowSequenceNodeInstance
implements InternalRuleFlowGroup {
    private static final long serialVersionUID = 320L;
    private final String name;
    private boolean active = false;
    private final LinkedList list;
    private boolean autoDeactivate = true;

    public RuleFlowGroupImpl(String name) {
        this.name = name;
        this.list = new LinkedList();
    }

    public String getName() {
        return this.name;
    }

    public void setActive(boolean active) {
        if (this.active == active) {
            return;
        }
        this.active = active;
        if (active) {
            this.triggerActivations();
        } else {
            LinkedList.LinkedListIterator it = this.list.iterator();
            RuleFlowGroupNode node = (RuleFlowGroupNode)it.next();
            while (node != null) {
                Activation activation = node.getActivation();
                activation.remove();
                if (activation.getActivationGroupNode() != null) {
                    activation.getActivationGroupNode().getActivationGroup().removeActivation(activation);
                }
                node = (RuleFlowGroupNode)it.next();
            }
        }
    }

    public boolean isActive() {
        return this.active;
    }

    public boolean isAutoDeactivate() {
        return this.autoDeactivate;
    }

    public void setAutoDeactivate(boolean autoDeactivate) {
        this.autoDeactivate = autoDeactivate;
        if (autoDeactivate && this.active && this.list.isEmpty()) {
            this.active = false;
        }
    }

    private void triggerActivations() {
        LinkedList.LinkedListIterator it = this.list.iterator();
        RuleFlowGroupNode node = (RuleFlowGroupNode)it.next();
        while (node != null) {
            Activation activation = node.getActivation();
            ((AgendaGroupImpl)activation.getAgendaGroup()).add(activation);
            node = (RuleFlowGroupNode)it.next();
        }
    }

    public void clear() {
        LinkedList.LinkedListIterator it = this.list.iterator();
        RuleFlowGroupNode node = (RuleFlowGroupNode)it.next();
        while (node != null) {
            node.getActivation().remove();
            node = (RuleFlowGroupNode)it.next();
        }
    }

    public int size() {
        return this.list.size();
    }

    public void addActivation(Activation activation) {
        RuleFlowGroupNode node = new RuleFlowGroupNode(activation, this);
        activation.setRuleFlowGroupNode(node);
        this.list.add(node);
        if (this.active) {
            ((AgendaGroupImpl)activation.getAgendaGroup()).add(activation);
        }
    }

    public void removeActivation(Activation activation, InternalWorkingMemory workingMemory) {
        RuleFlowGroupNode node = activation.getRuleFlowGroupNode();
        this.list.remove(node);
        activation.setActivationGroupNode(null);
        if (this.autoDeactivate && this.list.isEmpty()) {
            DeactivateCallback action = new DeactivateCallback(this);
            workingMemory.queueWorkingMemoryAction(action);
        }
    }

    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    public Iterator iterator() {
        return this.list.javaUtilIterator();
    }

    public String toString() {
        return "RuleFlowGroup '" + this.name + "'";
    }

    public boolean equal(Object object) {
        if (object == null || !(object instanceof RuleFlowGroupImpl)) {
            return false;
        }
        return ((RuleFlowGroupImpl)object).name.equals(this.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public void trigger(IRuleFlowNodeInstance parent) {
        this.setActive(true);
    }

    public static class DeactivateCallback
    implements WorkingMemoryAction {
        private final InternalRuleFlowGroup ruleFlowGroup;

        public DeactivateCallback(InternalRuleFlowGroup ruleFlowGroup) {
            this.ruleFlowGroup = ruleFlowGroup;
        }

        public void execute(InternalWorkingMemory workingMemory) {
            if (this.ruleFlowGroup.isEmpty()) {
                this.ruleFlowGroup.setActive(false);
                if (this.ruleFlowGroup.getProcessInstance() != null) {
                    this.ruleFlowGroup.triggerCompleted();
                }
            }
        }
    }
}

