/*
 * Decompiled with CFR 0.152.
 */
package org.drools.common;

import java.io.Serializable;
import org.drools.RuleBaseConfiguration;
import org.drools.base.evaluators.Operator;
import org.drools.common.BetaConstraints;
import org.drools.common.InternalFactHandle;
import org.drools.common.InternalWorkingMemory;
import org.drools.reteoo.BetaMemory;
import org.drools.reteoo.FactHandleMemory;
import org.drools.reteoo.ReteTuple;
import org.drools.reteoo.TupleMemory;
import org.drools.rule.ContextEntry;
import org.drools.rule.VariableConstraint;
import org.drools.spi.BetaNodeFieldConstraint;
import org.drools.util.AbstractHashTable;
import org.drools.util.FactHandleIndexHashTable;
import org.drools.util.FactHashTable;
import org.drools.util.LinkedList;
import org.drools.util.LinkedListEntry;
import org.drools.util.TupleHashTable;
import org.drools.util.TupleIndexHashTable;

public class SingleBetaConstraints
implements Serializable,
BetaConstraints {
    private static final long serialVersionUID = 320L;
    private final BetaNodeFieldConstraint constraint;
    private ContextEntry context;
    private boolean indexed;
    private RuleBaseConfiguration conf;

    public SingleBetaConstraints(BetaNodeFieldConstraint constraint, RuleBaseConfiguration conf) {
        int depth;
        this.conf = conf;
        this.indexed = !conf.isIndexLeftBetaMemory() && !conf.isIndexRightBetaMemory() ? false : (depth = conf.getCompositeKeyDepth()) >= 1 && this.isIndexable(constraint);
        this.constraint = constraint;
        this.context = constraint.getContextEntry();
    }

    private boolean isIndexable(BetaNodeFieldConstraint constraint) {
        if (constraint instanceof VariableConstraint) {
            VariableConstraint variableConstraint = (VariableConstraint)constraint;
            return variableConstraint.getEvaluator().getOperator() == Operator.EQUAL;
        }
        return false;
    }

    public void updateFromTuple(InternalWorkingMemory workingMemory, ReteTuple tuple) {
        this.context.updateFromTuple(workingMemory, tuple);
    }

    public void updateFromFactHandle(InternalWorkingMemory workingMemory, InternalFactHandle handle) {
        this.context.updateFromFactHandle(workingMemory, handle);
    }

    public boolean isAllowedCachedLeft(Object object) {
        return this.indexed || this.constraint.isAllowedCachedLeft(this.context, object);
    }

    public boolean isAllowedCachedRight(ReteTuple tuple) {
        return this.constraint.isAllowedCachedRight(tuple, this.context);
    }

    public boolean isIndexed() {
        return this.indexed;
    }

    public boolean isEmpty() {
        return false;
    }

    public BetaMemory createBetaMemory() {
        BetaMemory memory;
        if (this.indexed) {
            VariableConstraint variableConstraint = (VariableConstraint)this.constraint;
            AbstractHashTable.FieldIndex index = new AbstractHashTable.FieldIndex(variableConstraint.getFieldExtractor(), variableConstraint.getRequiredDeclarations()[0], variableConstraint.getEvaluator());
            AbstractHashTable tupleMemory = this.conf.isIndexLeftBetaMemory() ? new TupleIndexHashTable(new AbstractHashTable.FieldIndex[]{index}) : new TupleHashTable();
            AbstractHashTable factHandleMemory = this.conf.isIndexRightBetaMemory() ? new FactHandleIndexHashTable(new AbstractHashTable.FieldIndex[]{index}) : new FactHashTable();
            memory = new BetaMemory((TupleMemory)((Object)tupleMemory), (FactHandleMemory)((Object)factHandleMemory));
        } else {
            memory = new BetaMemory(new TupleHashTable(), new FactHashTable());
        }
        return memory;
    }

    public int hashCode() {
        return this.constraint.hashCode();
    }

    public LinkedList getConstraints() {
        LinkedList list = new LinkedList();
        list.add(new LinkedListEntry(this.constraint));
        return list;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        SingleBetaConstraints other = (SingleBetaConstraints)object;
        return this.constraint == other.constraint || this.constraint.equals(other);
    }
}

