/*
 * Decompiled with CFR 0.152.
 */
package org.drools.common;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.drools.FactException;
import org.drools.common.AbstractWorkingMemory;
import org.drools.common.EqualityKey;
import org.drools.common.EqualityKeyComparator;
import org.drools.common.InternalFactHandle;
import org.drools.common.InternalWorkingMemory;
import org.drools.common.LogicalDependency;
import org.drools.common.WorkingMemoryAction;
import org.drools.rule.Rule;
import org.drools.spi.Activation;
import org.drools.spi.PropagationContext;
import org.drools.util.LinkedList;
import org.drools.util.ObjectHashMap;
import org.drools.util.PrimitiveLongMap;

public class TruthMaintenanceSystem
implements Serializable {
    private static final long serialVersionUID = 320L;
    private final AbstractWorkingMemory workingMemory;
    private final PrimitiveLongMap justifiedMap;
    private final ObjectHashMap assertMap;

    public TruthMaintenanceSystem(AbstractWorkingMemory workingMemory) {
        this.workingMemory = workingMemory;
        this.justifiedMap = new PrimitiveLongMap(8, 32);
        this.assertMap = new ObjectHashMap();
        this.assertMap.setComparator(EqualityKeyComparator.getInstance());
    }

    public PrimitiveLongMap getJustifiedMap() {
        return this.justifiedMap;
    }

    public ObjectHashMap getAssertMap() {
        return this.assertMap;
    }

    public Object put(EqualityKey key) {
        return this.assertMap.put(key, key, false);
    }

    public EqualityKey get(EqualityKey key) {
        return (EqualityKey)this.assertMap.get(key);
    }

    public EqualityKey get(Object object) {
        return (EqualityKey)this.assertMap.get(object);
    }

    public EqualityKey remove(EqualityKey key) {
        return (EqualityKey)this.assertMap.remove(key);
    }

    public void removeLogicalDependencies(Activation activation, PropagationContext context, Rule rule) throws FactException {
        LinkedList list = activation.getLogicalDependencies();
        if (list == null || list.isEmpty()) {
            return;
        }
        for (LogicalDependency node = (LogicalDependency)list.getFirst(); node != null; node = (LogicalDependency)node.getNext()) {
            InternalFactHandle handle = (InternalFactHandle)node.getFactHandle();
            Set set = (Set)this.justifiedMap.get(handle.getId());
            if (set == null) continue;
            set.remove(node);
            LogicalRetractCallback action = new LogicalRetractCallback(this, node, set, handle, context);
            this.workingMemory.queueWorkingMemoryAction(action);
        }
    }

    public void removeLogicalDependencies(InternalFactHandle handle) throws FactException {
        Set set = (Set)this.justifiedMap.remove(handle.getId());
        if (set != null && !set.isEmpty()) {
            Iterator it = set.iterator();
            while (it.hasNext()) {
                LogicalDependency node = (LogicalDependency)it.next();
                node.getJustifier().getLogicalDependencies().remove(node);
            }
        }
    }

    public void addLogicalDependency(InternalFactHandle handle, Activation activation, PropagationContext context, Rule rule) throws FactException {
        LogicalDependency node = new LogicalDependency(activation, handle);
        activation.getRule().setHasLogicalDependency(true);
        activation.addLogicalDependency(node);
        HashSet<LogicalDependency> set = (HashSet<LogicalDependency>)this.justifiedMap.get(handle.getId());
        if (set == null) {
            if (context.getType() == 2) {
                // empty if block
            }
            set = new HashSet<LogicalDependency>();
            this.justifiedMap.put(handle.getId(), set);
        }
        set.add(node);
    }

    public static class LogicalRetractCallback
    implements WorkingMemoryAction {
        private final TruthMaintenanceSystem tms;
        private final LogicalDependency node;
        private final Set set;
        private final InternalFactHandle handle;
        private final PropagationContext context;

        public LogicalRetractCallback(TruthMaintenanceSystem tms, LogicalDependency node, Set set, InternalFactHandle handle, PropagationContext context) {
            this.tms = tms;
            this.node = node;
            this.set = set;
            this.handle = handle;
            this.context = context;
        }

        public void execute(InternalWorkingMemory workingMemory) {
            if (this.set.isEmpty() && this.set.isEmpty()) {
                this.tms.getJustifiedMap().remove(this.handle.getId());
                workingMemory.retractObject(this.handle, false, true, this.context.getRuleOrigin(), this.context.getActivationOrigin());
            }
        }
    }
}

