/*
 * Decompiled with CFR 0.152.
 */
package org.drools.conflict;

import org.drools.common.InternalFactHandle;
import org.drools.conflict.AbstractConflictResolver;
import org.drools.spi.Activation;
import org.drools.spi.ConflictResolver;

public class RecencyConflictResolver
extends AbstractConflictResolver {
    private static final long serialVersionUID = -1418542215680672535L;
    private static final RecencyConflictResolver INSTANCE = new RecencyConflictResolver();

    public static ConflictResolver getInstance() {
        return INSTANCE;
    }

    public int compare(Activation lhs, Activation rhs) {
        int lastIndex;
        InternalFactHandle[] lFacts = lhs.getTuple().getFactHandles();
        InternalFactHandle[] rFacts = rhs.getTuple().getFactHandles();
        InternalFactHandle leftMostRecent = this.getMostRecentFact(lFacts);
        InternalFactHandle rightMostRecent = this.getMostRecentFact(rFacts);
        int n = lastIndex = lFacts.length < rFacts.length ? lFacts.length : rFacts.length;
        if (leftMostRecent.getRecency() == rightMostRecent.getRecency() && lastIndex > 1) {
            for (int i = 0; i < lastIndex; ++i) {
                leftMostRecent = this.getMostRecentFact(lFacts, leftMostRecent);
                rightMostRecent = this.getMostRecentFact(rFacts, rightMostRecent);
                if (leftMostRecent == null || rightMostRecent == null) {
                    if (leftMostRecent != null || rightMostRecent == null) continue;
                    return (int)rightMostRecent.getRecency();
                }
                if (leftMostRecent.getRecency() == rightMostRecent.getRecency()) continue;
                return (int)(rightMostRecent.getRecency() - leftMostRecent.getRecency());
            }
        } else {
            return (int)(rightMostRecent.getRecency() - leftMostRecent.getRecency());
        }
        return rFacts.length - lFacts.length;
    }

    private InternalFactHandle getMostRecentFact(InternalFactHandle[] handles) {
        InternalFactHandle mostRecent = handles[0];
        for (int i = 1; i < handles.length; ++i) {
            InternalFactHandle eachHandle = handles[i];
            if (eachHandle.getRecency() <= mostRecent.getRecency()) continue;
            mostRecent = eachHandle;
        }
        return mostRecent;
    }

    private InternalFactHandle getMostRecentFact(InternalFactHandle[] handles, InternalFactHandle handle) {
        InternalFactHandle mostRecent = null;
        for (int i = 0; i < handles.length; ++i) {
            InternalFactHandle eachHandle = handles[i];
            if (mostRecent == null && eachHandle.getRecency() < handle.getRecency()) {
                mostRecent = eachHandle;
            }
            if (mostRecent == null || eachHandle.getRecency() <= mostRecent.getRecency() || eachHandle.getRecency() >= handle.getRecency()) continue;
            mostRecent = eachHandle;
        }
        return mostRecent;
    }
}

