/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import java.util.ArrayList;
import java.util.Arrays;
import org.drools.common.BetaConstraints;
import org.drools.common.EmptyBetaConstraints;
import org.drools.common.InternalFactHandle;
import org.drools.common.InternalWorkingMemory;
import org.drools.reteoo.BetaMemory;
import org.drools.reteoo.BetaNode;
import org.drools.reteoo.ObjectSource;
import org.drools.reteoo.ReteTuple;
import org.drools.reteoo.TupleSink;
import org.drools.reteoo.TupleSource;
import org.drools.rule.Accumulate;
import org.drools.spi.AlphaNodeFieldConstraint;
import org.drools.spi.PropagationContext;
import org.drools.util.AbstractHashTable;
import org.drools.util.Iterator;
import org.drools.util.ObjectHashMap;

public class AccumulateNode
extends BetaNode {
    private static final long serialVersionUID = -4081578178269297948L;
    private final Accumulate accumulate;
    private final AlphaNodeFieldConstraint[] resultConstraints;
    private final BetaConstraints resultBinder;

    AccumulateNode(int id, TupleSource leftInput, ObjectSource rightInput, Accumulate accumulate) {
        this(id, leftInput, rightInput, new AlphaNodeFieldConstraint[0], EmptyBetaConstraints.getInstance(), EmptyBetaConstraints.getInstance(), accumulate);
    }

    public AccumulateNode(int id, TupleSource leftInput, ObjectSource rightInput, AlphaNodeFieldConstraint[] resultConstraints, BetaConstraints sourceBinder, BetaConstraints resultBinder, Accumulate accumulate) {
        super(id, leftInput, rightInput, sourceBinder);
        this.resultBinder = resultBinder;
        this.resultConstraints = resultConstraints;
        this.accumulate = accumulate;
    }

    public void assertTuple(ReteTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        BetaMemory memory = (BetaMemory)workingMemory.getNodeMemory(this);
        memory.getTupleMemory().add(leftTuple);
        ArrayList<Object> matchingObjects = new ArrayList<Object>();
        Iterator it = memory.getFactHandleMemory().iterator(leftTuple);
        this.constraints.updateFromTuple(workingMemory, leftTuple);
        AbstractHashTable.FactEntry entry = (AbstractHashTable.FactEntry)it.next();
        while (entry != null) {
            InternalFactHandle handle = entry.getFactHandle();
            if (this.constraints.isAllowedCachedLeft(handle.getObject())) {
                matchingObjects.add(handle.getObject());
            }
            entry = (AbstractHashTable.FactEntry)it.next();
        }
        Object result = this.accumulate.accumulate(leftTuple, matchingObjects, workingMemory);
        boolean isAllowed = true;
        int length = this.resultConstraints.length;
        for (int i = 0; i < length; ++i) {
            if (this.resultConstraints[i].isAllowed(result, workingMemory)) continue;
            isAllowed = false;
            break;
        }
        if (isAllowed) {
            this.resultBinder.updateFromTuple(workingMemory, leftTuple);
            if (this.resultBinder.isAllowedCachedLeft(result)) {
                InternalFactHandle handle = workingMemory.getFactHandleFactory().newFactHandle(result);
                memory.getCreatedHandles().put(leftTuple, handle, false);
                this.sink.propagateAssertTuple(leftTuple, handle, context, workingMemory);
            }
        }
    }

    public void retractTuple(ReteTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        BetaMemory memory = (BetaMemory)workingMemory.getNodeMemory(this);
        memory.getTupleMemory().remove(leftTuple);
        InternalFactHandle handle = (InternalFactHandle)memory.getCreatedHandles().remove(leftTuple);
        if (handle != null) {
            this.sink.propagateRetractTuple(leftTuple, handle, context, workingMemory);
            workingMemory.getFactHandleFactory().destroyFactHandle(handle);
        }
    }

    public void assertObject(InternalFactHandle handle, PropagationContext context, InternalWorkingMemory workingMemory) {
        BetaMemory memory = (BetaMemory)workingMemory.getNodeMemory(this);
        memory.getFactHandleMemory().add(handle);
        Iterator it = memory.getTupleMemory().iterator();
        this.constraints.updateFromFactHandle(workingMemory, handle);
        ReteTuple tuple = (ReteTuple)it.next();
        while (tuple != null) {
            if (this.constraints.isAllowedCachedRight(tuple)) {
                this.retractTuple(tuple, context, workingMemory);
                this.assertTuple(tuple, context, workingMemory);
            }
            tuple = (ReteTuple)it.next();
        }
    }

    public void retractObject(InternalFactHandle handle, PropagationContext context, InternalWorkingMemory workingMemory) {
        BetaMemory memory = (BetaMemory)workingMemory.getNodeMemory(this);
        if (!memory.getFactHandleMemory().remove(handle)) {
            return;
        }
        Iterator it = memory.getTupleMemory().iterator();
        this.constraints.updateFromFactHandle(workingMemory, handle);
        ReteTuple tuple = (ReteTuple)it.next();
        while (tuple != null) {
            if (this.constraints.isAllowedCachedRight(tuple)) {
                this.retractTuple(tuple, context, workingMemory);
                this.assertTuple(tuple, context, workingMemory);
            }
            tuple = (ReteTuple)it.next();
        }
    }

    public void updateSink(TupleSink sink, PropagationContext context, InternalWorkingMemory workingMemory) {
        BetaMemory memory = (BetaMemory)workingMemory.getNodeMemory(this);
        Iterator it = memory.getCreatedHandles().iterator();
        ObjectHashMap.ObjectEntry entry = (ObjectHashMap.ObjectEntry)it.next();
        while (entry != null) {
            sink.assertTuple(new ReteTuple((ReteTuple)entry.getKey(), (InternalFactHandle)entry.getValue()), context, workingMemory);
            entry = (ObjectHashMap.ObjectEntry)it.next();
        }
    }

    public int hashCode() {
        return this.leftInput.hashCode() ^ this.rightInput.hashCode() ^ this.accumulate.hashCode() ^ this.resultBinder.hashCode() ^ Arrays.hashCode(this.resultConstraints);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof AccumulateNode)) {
            return false;
        }
        AccumulateNode other = (AccumulateNode)object;
        if (!(this.getClass() == other.getClass() && this.leftInput.equals(other.leftInput) && this.rightInput.equals(other.rightInput) && this.constraints.equals(other.constraints))) {
            return false;
        }
        return this.accumulate.equals(other.accumulate) && this.resultBinder.equals(other.resultBinder) && Arrays.equals(this.resultConstraints, other.resultConstraints);
    }

    public String toString() {
        return "[ " + this.getClass().getName() + "(" + this.id + ") ]";
    }
}

