/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import java.util.Arrays;
import java.util.Collection;
import org.drools.common.BetaConstraints;
import org.drools.common.EmptyBetaConstraints;
import org.drools.common.InternalFactHandle;
import org.drools.common.InternalWorkingMemory;
import org.drools.reteoo.BetaMemory;
import org.drools.reteoo.BetaNode;
import org.drools.reteoo.ObjectSink;
import org.drools.reteoo.ObjectSource;
import org.drools.reteoo.ReteTuple;
import org.drools.reteoo.TupleSink;
import org.drools.reteoo.TupleSource;
import org.drools.rule.Collect;
import org.drools.spi.AlphaNodeFieldConstraint;
import org.drools.spi.PropagationContext;
import org.drools.util.AbstractHashTable;
import org.drools.util.Iterator;
import org.drools.util.ObjectHashMap;

public class CollectNode
extends BetaNode
implements TupleSink,
ObjectSink {
    private static final long serialVersionUID = -8321568626178187047L;
    private final Collect collect;
    private final AlphaNodeFieldConstraint[] resultConstraints;
    private final BetaConstraints resultsBinder;

    CollectNode(int id, TupleSource leftInput, ObjectSource rightInput, Collect collect) {
        this(id, leftInput, rightInput, new AlphaNodeFieldConstraint[0], EmptyBetaConstraints.getInstance(), EmptyBetaConstraints.getInstance(), collect);
    }

    public CollectNode(int id, TupleSource leftInput, ObjectSource rightInput, AlphaNodeFieldConstraint[] resultConstraints, BetaConstraints sourceBinder, BetaConstraints resultsBinder, Collect collect) {
        super(id, leftInput, rightInput, sourceBinder);
        this.resultsBinder = resultsBinder;
        this.resultConstraints = resultConstraints;
        this.collect = collect;
    }

    public void assertTuple(ReteTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        BetaMemory memory = (BetaMemory)workingMemory.getNodeMemory(this);
        memory.getTupleMemory().add(leftTuple);
        Collection result = this.collect.instantiateResultObject();
        Iterator it = memory.getFactHandleMemory().iterator(leftTuple);
        this.constraints.updateFromTuple(workingMemory, leftTuple);
        AbstractHashTable.FactEntry entry = (AbstractHashTable.FactEntry)it.next();
        while (entry != null) {
            InternalFactHandle handle = entry.getFactHandle();
            if (this.constraints.isAllowedCachedLeft(handle.getObject())) {
                result.add(handle.getObject());
            }
            entry = (AbstractHashTable.FactEntry)it.next();
        }
        boolean isAllowed = true;
        int length = this.resultConstraints.length;
        for (int i = 0; i < length; ++i) {
            if (this.resultConstraints[i].isAllowed(result, workingMemory)) continue;
            isAllowed = false;
            break;
        }
        if (isAllowed) {
            this.resultsBinder.updateFromTuple(workingMemory, leftTuple);
            if (this.resultsBinder.isAllowedCachedLeft(result)) {
                InternalFactHandle handle = workingMemory.getFactHandleFactory().newFactHandle(result);
                memory.getCreatedHandles().put(leftTuple, handle, false);
                this.sink.propagateAssertTuple(leftTuple, handle, context, workingMemory);
            }
        }
    }

    public void retractTuple(ReteTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        BetaMemory memory = (BetaMemory)workingMemory.getNodeMemory(this);
        memory.getTupleMemory().remove(leftTuple);
        InternalFactHandle handle = (InternalFactHandle)memory.getCreatedHandles().remove(leftTuple);
        if (handle != null) {
            this.sink.propagateRetractTuple(leftTuple, handle, context, workingMemory);
            workingMemory.getFactHandleFactory().destroyFactHandle(handle);
        }
    }

    public void assertObject(InternalFactHandle handle, PropagationContext context, InternalWorkingMemory workingMemory) {
        BetaMemory memory = (BetaMemory)workingMemory.getNodeMemory(this);
        memory.getFactHandleMemory().add(handle);
        Iterator it = memory.getTupleMemory().iterator();
        this.constraints.updateFromFactHandle(workingMemory, handle);
        ReteTuple tuple = (ReteTuple)it.next();
        while (tuple != null) {
            if (this.constraints.isAllowedCachedRight(tuple)) {
                this.retractTuple(tuple, context, workingMemory);
                this.assertTuple(tuple, context, workingMemory);
            }
            tuple = (ReteTuple)it.next();
        }
    }

    public void retractObject(InternalFactHandle handle, PropagationContext context, InternalWorkingMemory workingMemory) {
        BetaMemory memory = (BetaMemory)workingMemory.getNodeMemory(this);
        if (!memory.getFactHandleMemory().remove(handle)) {
            return;
        }
        Iterator it = memory.getTupleMemory().iterator();
        this.constraints.updateFromFactHandle(workingMemory, handle);
        ReteTuple tuple = (ReteTuple)it.next();
        while (tuple != null) {
            if (this.constraints.isAllowedCachedRight(tuple)) {
                this.retractTuple(tuple, context, workingMemory);
                this.assertTuple(tuple, context, workingMemory);
            }
            tuple = (ReteTuple)it.next();
        }
    }

    public void updateSink(TupleSink sink, PropagationContext context, InternalWorkingMemory workingMemory) {
        BetaMemory memory = (BetaMemory)workingMemory.getNodeMemory(this);
        Iterator it = memory.getCreatedHandles().iterator();
        ObjectHashMap.ObjectEntry entry = (ObjectHashMap.ObjectEntry)it.next();
        while (entry != null) {
            sink.assertTuple(new ReteTuple((ReteTuple)entry.getKey(), (InternalFactHandle)entry.getValue()), context, workingMemory);
            entry = (ObjectHashMap.ObjectEntry)it.next();
        }
    }

    public int hashCode() {
        return this.leftInput.hashCode() ^ this.rightInput.hashCode() ^ this.collect.hashCode() ^ this.resultsBinder.hashCode() ^ Arrays.hashCode(this.resultConstraints);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof CollectNode)) {
            return false;
        }
        CollectNode other = (CollectNode)object;
        if (!(this.getClass() == other.getClass() && this.leftInput.equals(other.leftInput) && this.rightInput.equals(other.rightInput) && this.constraints.equals(other.constraints))) {
            return false;
        }
        return this.collect.equals(other.collect) && this.resultsBinder.equals(other.resultsBinder) && Arrays.equals(this.resultConstraints, other.resultConstraints);
    }

    public String toString() {
        return "[ " + this.getClass().getName() + "(" + this.id + ") ]";
    }
}

