/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import org.drools.RuleBaseConfiguration;
import org.drools.common.BaseNode;
import org.drools.common.InternalFactHandle;
import org.drools.common.InternalWorkingMemory;
import org.drools.common.NodeMemory;
import org.drools.common.PropagationContextImpl;
import org.drools.reteoo.ObjectSink;
import org.drools.reteoo.ObjectSinkNode;
import org.drools.reteoo.ObjectSource;
import org.drools.reteoo.ReteTuple;
import org.drools.reteoo.TupleSink;
import org.drools.reteoo.TupleSource;
import org.drools.spi.PropagationContext;
import org.drools.util.AbstractHashTable;
import org.drools.util.FactHashTable;
import org.drools.util.Iterator;

public class LeftInputAdapterNode
extends TupleSource
implements ObjectSinkNode,
NodeMemory {
    private static final long serialVersionUID = 320L;
    private final ObjectSource objectSource;
    private ObjectSinkNode previousObjectSinkNode;
    private ObjectSinkNode nextObjectSinkNode;

    public LeftInputAdapterNode(int id, ObjectSource source) {
        super(id);
        this.objectSource = source;
        this.setHasMemory(false);
    }

    public void attach() {
        this.objectSource.addObjectSink(this);
    }

    public void attach(InternalWorkingMemory[] workingMemories) {
        this.attach();
        int length = workingMemories.length;
        for (int i = 0; i < length; ++i) {
            InternalWorkingMemory workingMemory = workingMemories[i];
            PropagationContextImpl propagationContext = new PropagationContextImpl(workingMemory.getNextPropagationIdCounter(), 3, null, null);
            this.objectSource.updateSink(this, propagationContext, workingMemory);
        }
    }

    public void assertObject(InternalFactHandle handle, PropagationContext context, InternalWorkingMemory workingMemory) {
        this.sink.createAndPropagateAssertTuple(handle, context, workingMemory);
        if (this.hasMemory) {
            FactHashTable memory = (FactHashTable)workingMemory.getNodeMemory(this);
            memory.add(handle, false);
        }
    }

    public void retractObject(InternalFactHandle handle, PropagationContext context, InternalWorkingMemory workingMemory) {
        boolean propagate = true;
        if (this.hasMemory) {
            FactHashTable memory = (FactHashTable)workingMemory.getNodeMemory(this);
            propagate = memory.remove(handle);
        }
        if (propagate) {
            this.sink.createAndPropagateRetractTuple(handle, context, workingMemory);
        }
    }

    public void updateSink(TupleSink sink, PropagationContext context, InternalWorkingMemory workingMemory) {
        if (this.hasMemory) {
            FactHashTable memory = (FactHashTable)workingMemory.getNodeMemory(this);
            Iterator it = memory.iterator();
            AbstractHashTable.FactEntry entry = (AbstractHashTable.FactEntry)it.next();
            while (entry != null) {
                InternalFactHandle handle = entry.getFactHandle();
                sink.assertTuple(new ReteTuple(handle), context, workingMemory);
                it.next();
            }
        } else {
            ObjectSinkAdapter adapter = new ObjectSinkAdapter(sink);
            this.objectSource.updateSink(adapter, context, workingMemory);
        }
    }

    public void remove(BaseNode node, InternalWorkingMemory[] workingMemories) {
        if (!node.isInUse()) {
            this.removeTupleSink((TupleSink)((Object)node));
        }
        this.removeShare();
        if (!this.isInUse()) {
            int length = workingMemories.length;
            for (int i = 0; i < length; ++i) {
                workingMemories[i].clearNodeMemory(this);
            }
        }
        this.objectSource.remove(this, workingMemories);
    }

    public ObjectSinkNode getNextObjectSinkNode() {
        return this.nextObjectSinkNode;
    }

    public void setNextObjectSinkNode(ObjectSinkNode next) {
        this.nextObjectSinkNode = next;
    }

    public ObjectSinkNode getPreviousObjectSinkNode() {
        return this.previousObjectSinkNode;
    }

    public void setPreviousObjectSinkNode(ObjectSinkNode previous) {
        this.previousObjectSinkNode = previous;
    }

    public int hashCode() {
        return this.objectSource.hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !(object instanceof LeftInputAdapterNode)) {
            return false;
        }
        LeftInputAdapterNode other = (LeftInputAdapterNode)object;
        return this.objectSource.equals(other.objectSource);
    }

    public Object createMemory(RuleBaseConfiguration config) {
        return new FactHashTable();
    }

    private static class ObjectSinkAdapter
    implements ObjectSink {
        private TupleSink sink;

        public ObjectSinkAdapter(TupleSink sink) {
            this.sink = sink;
        }

        public void assertObject(InternalFactHandle handle, PropagationContext context, InternalWorkingMemory workingMemory) {
            ReteTuple tuple = new ReteTuple(handle);
            this.sink.assertTuple(tuple, context, workingMemory);
        }

        public void modifyObject(InternalFactHandle handle, PropagationContext context, InternalWorkingMemory workingMemory) {
            throw new UnsupportedOperationException("ObjectSinkAdapter onlys supports assertObject method calls");
        }

        public void retractObject(InternalFactHandle handle, PropagationContext context, InternalWorkingMemory workingMemory) {
            throw new UnsupportedOperationException("ObjectSinkAdapter onlys supports assertObject method calls");
        }
    }
}

