/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import java.lang.reflect.Field;
import org.drools.common.InternalWorkingMemory;
import org.drools.reteoo.AlphaNode;
import org.drools.reteoo.BetaMemory;
import org.drools.reteoo.FactHandleMemory;
import org.drools.reteoo.JoinNode;
import org.drools.reteoo.LeftInputAdapterNode;
import org.drools.reteoo.NotNode;
import org.drools.reteoo.ObjectSink;
import org.drools.reteoo.ObjectSinkPropagator;
import org.drools.reteoo.ObjectSource;
import org.drools.reteoo.ObjectTypeNode;
import org.drools.reteoo.Rete;
import org.drools.reteoo.ReteooRuleBase;
import org.drools.reteoo.RuleTerminalNode;
import org.drools.reteoo.TupleMemory;
import org.drools.reteoo.TupleSink;
import org.drools.reteoo.TupleSinkPropagator;
import org.drools.reteoo.TupleSource;
import org.drools.util.AbstractHashTable;
import org.drools.util.Entry;
import org.drools.util.FactHandleIndexHashTable;
import org.drools.util.FactHashTable;
import org.drools.util.Iterator;
import org.drools.util.ObjectHashMap;
import org.drools.util.ReflectiveVisitor;

public class MemoryVisitor
extends ReflectiveVisitor {
    private InternalWorkingMemory workingMemory;
    private int indent = 0;

    public MemoryVisitor(InternalWorkingMemory workingMemory) {
        this.workingMemory = workingMemory;
    }

    public void visitReteooRuleBase(ReteooRuleBase ruleBase) {
        this.visit(ruleBase.getRete());
    }

    public void visitRete(Rete rete) {
        ObjectHashMap map = rete.getObjectTypeNodes();
        Iterator it = map.iterator();
        ObjectHashMap.ObjectEntry entry = (ObjectHashMap.ObjectEntry)it.next();
        while (entry != null) {
            this.visit(entry.getValue());
            entry = (ObjectHashMap.ObjectEntry)it.next();
        }
    }

    public void visitObjectTypeNode(ObjectTypeNode node) {
        System.out.println(this.indent() + node);
        FactHashTable memory = (FactHashTable)this.workingMemory.getNodeMemory(node);
        this.checkObjectHashTable(memory);
        ++this.indent;
        try {
            Field field = ObjectSource.class.getDeclaredField("sink");
            field.setAccessible(true);
            ObjectSinkPropagator sink = (ObjectSinkPropagator)field.get(node);
            ObjectSink[] sinks = sink.getSinks();
            int length = sinks.length;
            for (int i = 0; i < length; ++i) {
                this.visit(sinks[i]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        --this.indent;
    }

    public void visitAlphaNode(AlphaNode node) {
        System.out.println(this.indent() + node);
        FactHashTable memory = (FactHashTable)this.workingMemory.getNodeMemory(node);
        this.checkObjectHashTable(memory);
        ++this.indent;
        try {
            Field field = ObjectSource.class.getDeclaredField("sink");
            field.setAccessible(true);
            ObjectSinkPropagator sink = (ObjectSinkPropagator)field.get(node);
            ObjectSink[] sinks = sink.getSinks();
            int length = sinks.length;
            for (int i = 0; i < length; ++i) {
                this.visit(sinks[i]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        --this.indent;
    }

    public void visitLeftInputAdapterNode(LeftInputAdapterNode node) {
        System.out.println(this.indent() + node);
        ++this.indent;
        try {
            Field field = TupleSource.class.getDeclaredField("sink");
            field.setAccessible(true);
            TupleSinkPropagator sink = (TupleSinkPropagator)field.get(node);
            TupleSink[] sinks = sink.getSinks();
            int length = sinks.length;
            for (int i = 0; i < length; ++i) {
                this.visit(sinks[i]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        --this.indent;
    }

    public void visitJoinNode(JoinNode node) {
        System.out.println(this.indent() + node);
        try {
            BetaMemory memory = (BetaMemory)this.workingMemory.getNodeMemory(node);
            this.checkObjectHashTable(memory.getFactHandleMemory());
            this.checkTupleMemory(memory.getTupleMemory());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ++this.indent;
        try {
            Field field = TupleSource.class.getDeclaredField("sink");
            field.setAccessible(true);
            TupleSinkPropagator sink = (TupleSinkPropagator)field.get(node);
            TupleSink[] sinks = sink.getSinks();
            int length = sinks.length;
            for (int i = 0; i < length; ++i) {
                this.visit(sinks[i]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        --this.indent;
    }

    public void visitNotNode(NotNode node) {
        System.out.println(this.indent() + node);
        try {
            BetaMemory memory = (BetaMemory)this.workingMemory.getNodeMemory(node);
            this.checkObjectHashTable(memory.getFactHandleMemory());
            this.checkTupleMemory(memory.getTupleMemory());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ++this.indent;
        try {
            Field field = TupleSource.class.getDeclaredField("sink");
            field.setAccessible(true);
            TupleSinkPropagator sink = (TupleSinkPropagator)field.get(node);
            TupleSink[] sinks = sink.getSinks();
            int length = sinks.length;
            for (int i = 0; i < length; ++i) {
                this.visit(sinks[i]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        --this.indent;
    }

    public void visitTerminalNode(RuleTerminalNode node) {
        System.out.println(this.indent() + node);
        RuleTerminalNode.TerminalNodeMemory memory = (RuleTerminalNode.TerminalNodeMemory)this.workingMemory.getNodeMemory(node);
        this.checkTupleMemory(memory.getTupleMemory());
    }

    private void checkObjectHashTable(FactHandleMemory memory) {
        if (memory instanceof FactHashTable) {
            this.checkFactHashTable((FactHashTable)memory);
        } else if (memory instanceof FactHandleIndexHashTable) {
            this.checkFieldIndexHashTable((FactHandleIndexHashTable)memory);
        } else {
            throw new RuntimeException(memory.getClass() + " should not be here");
        }
    }

    private void checkFactHashTable(FactHashTable memory) {
        Entry[] entries = memory.getTable();
        int count = 0;
        int length = entries.length;
        for (int i = 0; i < length; ++i) {
            if (entries[i] == null) continue;
            for (Entry entry = entries[i]; entry != null; entry = entry.getNext()) {
                ++count;
            }
        }
        System.out.println(this.indent() + "FactHashTable: " + memory.size() + ":" + count);
        if (memory.size() != count) {
            System.out.println(this.indent() + "error");
        }
    }

    private void checkFieldIndexHashTable(FactHandleIndexHashTable memory) {
        Entry[] entries = memory.getTable();
        int factCount = 0;
        int bucketCount = 0;
        int length = entries.length;
        for (int i = 0; i < length; ++i) {
            if (entries[i] == null) continue;
            FactHandleIndexHashTable.FieldIndexEntry fieldIndexEntry = (FactHandleIndexHashTable.FieldIndexEntry)entries[i];
            while (fieldIndexEntry != null) {
                if (fieldIndexEntry.getFirst() != null) {
                    Entry entry = fieldIndexEntry.getFirst();
                    while (entry != null) {
                        entry = entry.getNext();
                        ++factCount;
                    }
                } else {
                    System.out.println("error : fieldIndexHashTable cannot have empty FieldIndexEntry objects");
                }
                fieldIndexEntry = (FactHandleIndexHashTable.FieldIndexEntry)fieldIndexEntry.getNext();
                ++bucketCount;
            }
        }
        try {
            Field field = AbstractHashTable.class.getDeclaredField("size");
            field.setAccessible(true);
            System.out.println(this.indent() + "FieldIndexBuckets: " + (Integer)field.get(memory) + ":" + bucketCount);
            if ((Integer)field.get(memory) != bucketCount) {
                System.out.println(this.indent() + "error");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println(this.indent() + "FieldIndexFacts: " + memory.size() + ":" + factCount);
        if (memory.size() != factCount) {
            System.out.println(this.indent() + "error");
        }
    }

    private void checkTupleMemory(TupleMemory memory) {
        Entry[] entries = memory.getTable();
        int count = 0;
        int length = entries.length;
        for (int i = 0; i < length; ++i) {
            if (entries[i] == null) continue;
            for (Entry entry = entries[i]; entry != null; entry = entry.getNext()) {
                ++count;
            }
        }
        System.out.println(this.indent() + "TupleMemory: " + memory.size() + ":" + count);
        if (memory.size() != count) {
            System.out.println(this.indent() + "error");
        }
    }

    private String indent() {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < this.indent; ++i) {
            buffer.append("  ");
        }
        return buffer.toString();
    }
}

