/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import java.io.Serializable;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.drools.reteoo.ObjectSinkNode;

public class ObjectSinkNodeList
implements Serializable {
    private static final long serialVersionUID = 320L;
    private ObjectSinkNode firstNode;
    private ObjectSinkNode lastNode;
    private int size;

    public void add(ObjectSinkNode node) {
        if (this.firstNode == null) {
            this.firstNode = node;
            this.lastNode = node;
        } else {
            this.lastNode.setNextObjectSinkNode(node);
            node.setPreviousObjectSinkNode(this.lastNode);
            this.lastNode = node;
        }
        ++this.size;
    }

    public void remove(ObjectSinkNode node) {
        if (this.firstNode != node && this.lastNode != node) {
            node.getPreviousObjectSinkNode().setNextObjectSinkNode(node.getNextObjectSinkNode());
            node.getNextObjectSinkNode().setPreviousObjectSinkNode(node.getPreviousObjectSinkNode());
            --this.size;
            node.setPreviousObjectSinkNode(null);
            node.setNextObjectSinkNode(null);
        } else if (this.firstNode == node) {
            this.removeFirst();
        } else if (this.lastNode == node) {
            this.removeLast();
        }
    }

    public final ObjectSinkNode getFirst() {
        return this.firstNode;
    }

    public final ObjectSinkNode getLast() {
        return this.lastNode;
    }

    public ObjectSinkNode removeFirst() {
        if (this.firstNode == null) {
            return null;
        }
        ObjectSinkNode node = this.firstNode;
        this.firstNode = node.getNextObjectSinkNode();
        node.setNextObjectSinkNode(null);
        if (this.firstNode != null) {
            this.firstNode.setPreviousObjectSinkNode(null);
        } else {
            this.lastNode = null;
        }
        --this.size;
        return node;
    }

    public ObjectSinkNode removeLast() {
        if (this.lastNode == null) {
            return null;
        }
        ObjectSinkNode node = this.lastNode;
        this.lastNode = node.getPreviousObjectSinkNode();
        node.setPreviousObjectSinkNode(null);
        if (this.lastNode != null) {
            this.lastNode.setNextObjectSinkNode(null);
        } else {
            this.firstNode = this.lastNode;
        }
        --this.size;
        return node;
    }

    public final boolean isEmpty() {
        return this.firstNode == null;
    }

    public void clear() {
        while (this.removeFirst() != null) {
        }
    }

    public final int size() {
        return this.size;
    }

    public Iterator iterator() {
        return new Iterator(){
            private ObjectSinkNode currentNode = null;
            private ObjectSinkNode nextNode = ObjectSinkNodeList.this.getFirst();

            public boolean hasNext() {
                return this.nextNode != null;
            }

            public Object next() {
                this.currentNode = this.nextNode;
                if (this.currentNode == null) {
                    throw new NoSuchElementException("No more elements to return");
                }
                this.nextNode = this.currentNode.getNextObjectSinkNode();
                return this.currentNode;
            }

            public void remove() {
                if (this.currentNode == null) {
                    throw new IllegalStateException("No item to remove. Call next() before calling remove().");
                }
                ObjectSinkNodeList.this.remove(this.currentNode);
                this.currentNode = null;
            }
        };
    }
}

