/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import java.util.ArrayList;
import org.drools.common.InternalFactHandle;
import org.drools.rule.Declaration;
import org.drools.spi.Activation;
import org.drools.spi.Tuple;
import org.drools.util.Entry;

public class ReteTuple
implements Tuple,
Entry {
    private static final long serialVersionUID = 320L;
    private int index;
    private final InternalFactHandle handle;
    private ReteTuple parent;
    private Activation activation;
    private long recency;
    private int hashCode;
    private boolean fieldIndexed;
    private int matches;
    private Entry next;

    public ReteTuple(InternalFactHandle handle) {
        this.index = 0;
        this.parent = null;
        this.recency = handle.getRecency();
        this.handle = handle;
        int h = handle.hashCode();
        h += ~(h << 9);
        h ^= h >>> 14;
        h += h << 4;
        h ^= h >>> 10;
        this.hashCode = h;
    }

    public ReteTuple(ReteTuple tuple) {
        this.index = tuple.index;
        this.parent = tuple.parent;
        this.recency = tuple.recency;
        this.handle = tuple.handle;
        this.hashCode = tuple.hashCode();
    }

    public ReteTuple(ReteTuple parentTuple, InternalFactHandle handle) {
        this.index = parentTuple.index + 1;
        this.parent = parentTuple;
        this.recency = parentTuple.recency + handle.getRecency();
        this.handle = handle;
        this.hashCode = parentTuple.hashCode ^ handle.hashCode() * 31;
    }

    public InternalFactHandle get(int index) {
        ReteTuple entry = this;
        while (entry.index != index) {
            entry = entry.parent;
        }
        return entry.handle;
    }

    public void setNext(Entry next) {
        this.next = next;
    }

    public Entry getNext() {
        return this.next;
    }

    public boolean isFieldIndexed() {
        return this.fieldIndexed;
    }

    public void setIsFieldIndexHashCode(boolean fieldIndexed) {
        this.fieldIndexed = fieldIndexed;
    }

    public int getMatches() {
        return this.matches;
    }

    public void setMatches(int matches) {
        this.matches = matches;
    }

    public InternalFactHandle getLastHandle() {
        return this.handle;
    }

    public InternalFactHandle get(Declaration declaration) {
        return this.get(declaration.getPattern().getOffset());
    }

    public Activation getActivation() {
        return this.activation;
    }

    public InternalFactHandle[] getFactHandles() {
        ArrayList<InternalFactHandle> list = new ArrayList<InternalFactHandle>();
        ReteTuple entry = this;
        while (entry != null) {
            list.add(entry.handle);
            entry = entry.parent;
        }
        return list.toArray(new InternalFactHandle[list.size()]);
    }

    public long getRecency() {
        return this.recency;
    }

    public void setActivation(Activation activation) {
        this.activation = activation;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        ReteTuple entry = this;
        while (entry != null) {
            buffer.append(entry.handle + "\n");
            entry = entry.parent;
        }
        return buffer.toString();
    }

    public boolean equals(ReteTuple other) {
        if (other == this) {
            return true;
        }
        if (other == null || this.hashCode != other.hashCode) {
            return false;
        }
        if (this.handle != other.handle) {
            return false;
        }
        if (this.parent == null) {
            return other.parent == null;
        }
        return this.parent.equals(other.parent);
    }

    public boolean equals(Object object) {
        return this.equals((ReteTuple)object);
    }

    public int size() {
        return this.index + 1;
    }

    public ReteTuple getSubTuple(int elements) {
        ReteTuple entry = this;
        if (elements < this.size()) {
            int lastindex = elements - 1;
            while (entry.index != lastindex) {
                entry = entry.parent;
            }
        }
        return entry;
    }
}

