/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo.builder;

import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Map;
import org.drools.common.BetaConstraints;
import org.drools.common.InternalWorkingMemory;
import org.drools.reteoo.ObjectSource;
import org.drools.reteoo.ReteooBuilder;
import org.drools.reteoo.ReteooRuleBase;
import org.drools.reteoo.TupleSource;
import org.drools.rule.RuleConditionElement;

public class BuildContext {
    private TupleSource tupleSource;
    private ObjectSource objectSource;
    private Map objectType;
    private int currentPatternOffset;
    private ReteooRuleBase rulebase;
    private InternalWorkingMemory[] workingMemories;
    private ReteooBuilder.IdGenerator idGenerator;
    private LinkedList buildstack;
    BetaConstraints betaconstraints;

    public BuildContext(ReteooRuleBase rulebase, ReteooBuilder.IdGenerator idGenerator) {
        this.rulebase = rulebase;
        this.workingMemories = this.rulebase.getWorkingMemories();
        this.idGenerator = idGenerator;
        this.objectType = new LinkedHashMap();
        this.buildstack = new LinkedList();
        this.tupleSource = null;
        this.objectSource = null;
        this.currentPatternOffset = 0;
    }

    public int getCurrentPatternOffset() {
        return this.currentPatternOffset;
    }

    public void setCurrentPatternOffset(int currentPatternIndex) {
        this.currentPatternOffset = currentPatternIndex;
    }

    public ObjectSource getObjectSource() {
        return this.objectSource;
    }

    public void setObjectSource(ObjectSource objectSource) {
        this.objectSource = objectSource;
    }

    public Map getObjectType() {
        return this.objectType;
    }

    public void setObjectType(Map objectType) {
        this.objectType = objectType;
    }

    public TupleSource getTupleSource() {
        return this.tupleSource;
    }

    public void setTupleSource(TupleSource tupleSource) {
        this.tupleSource = tupleSource;
    }

    public void incrementCurrentPatternOffset() {
        ++this.currentPatternOffset;
    }

    public void decrementCurrentPatternOffset() {
        --this.currentPatternOffset;
    }

    public ReteooRuleBase getRuleBase() {
        return this.rulebase;
    }

    public InternalWorkingMemory[] getWorkingMemories() {
        return this.workingMemories;
    }

    public int getNextId() {
        return this.idGenerator.getNextId();
    }

    public void releaseLastId() {
        this.idGenerator.releaseLastId();
    }

    public void push(RuleConditionElement rce) {
        this.buildstack.addLast(rce);
    }

    public RuleConditionElement pop() {
        return (RuleConditionElement)this.buildstack.removeLast();
    }

    public RuleConditionElement peek() {
        return (RuleConditionElement)this.buildstack.getLast();
    }

    public ListIterator stackIterator() {
        return this.buildstack.listIterator();
    }

    public BetaConstraints getBetaconstraints() {
        return this.betaconstraints;
    }

    public void setBetaconstraints(BetaConstraints betaconstraints) {
        this.betaconstraints = betaconstraints;
    }
}

