/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo.builder;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.drools.common.BetaConstraints;
import org.drools.reteoo.CollectNode;
import org.drools.reteoo.TupleSource;
import org.drools.reteoo.builder.BuildContext;
import org.drools.reteoo.builder.BuildUtils;
import org.drools.reteoo.builder.ReteooComponentBuilder;
import org.drools.rule.Collect;
import org.drools.rule.Declaration;
import org.drools.rule.LiteralConstraint;
import org.drools.rule.Pattern;
import org.drools.rule.RuleConditionElement;
import org.drools.spi.AlphaNodeFieldConstraint;

public class CollectBuilder
implements ReteooComponentBuilder {
    public void build(BuildContext context, BuildUtils utils, RuleConditionElement rce) {
        Collect collect = (Collect)rce;
        Pattern sourcePattern = collect.getSourcePattern();
        ReteooComponentBuilder builder = utils.getBuilderFor(sourcePattern);
        builder.build(context, utils, sourcePattern);
        Pattern pattern = collect.getResultPattern();
        pattern.setOffset(context.getCurrentPatternOffset() - 1);
        List constraints = pattern.getConstraints();
        ArrayList<AlphaNodeFieldConstraint> betaConstraints = new ArrayList<AlphaNodeFieldConstraint>();
        ArrayList<AlphaNodeFieldConstraint> alphaConstraints = new ArrayList<AlphaNodeFieldConstraint>();
        Iterator it = constraints.iterator();
        while (it.hasNext()) {
            Object object = it.next();
            if (object instanceof Declaration) continue;
            AlphaNodeFieldConstraint fieldConstraint = (AlphaNodeFieldConstraint)object;
            if (fieldConstraint instanceof LiteralConstraint) {
                alphaConstraints.add(fieldConstraint);
                continue;
            }
            utils.checkUnboundDeclarations(context, fieldConstraint.getRequiredDeclarations());
            betaConstraints.add(fieldConstraint);
        }
        BetaConstraints resultsBinder = utils.createBetaNodeConstraint(context, betaConstraints);
        context.setTupleSource((TupleSource)utils.attachNode(context, new CollectNode(context.getNextId(), context.getTupleSource(), context.getObjectSource(), alphaConstraints.toArray(new AlphaNodeFieldConstraint[alphaConstraints.size()]), context.getBetaconstraints(), resultsBinder, collect)));
        context.setObjectSource(null);
    }

    public boolean requiresLeftActivation(BuildUtils utils, RuleConditionElement rce) {
        return true;
    }
}

