/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo.builder;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.drools.base.ClassObjectType;
import org.drools.common.BetaConstraints;
import org.drools.common.InstanceNotEqualsConstraint;
import org.drools.reteoo.AlphaNode;
import org.drools.reteoo.ObjectSource;
import org.drools.reteoo.ObjectTypeNode;
import org.drools.reteoo.builder.BuildContext;
import org.drools.reteoo.builder.BuildUtils;
import org.drools.reteoo.builder.ReteooComponentBuilder;
import org.drools.rule.Declaration;
import org.drools.rule.InvalidPatternException;
import org.drools.rule.Pattern;
import org.drools.rule.RuleConditionElement;
import org.drools.spi.AlphaNodeFieldConstraint;
import org.drools.spi.Constraint;

public class PatternBuilder
implements ReteooComponentBuilder {
    public void build(BuildContext context, BuildUtils utils, RuleConditionElement rce) {
        Pattern pattern = (Pattern)rce;
        context.setBetaconstraints(this.attachPattern(context, utils, pattern));
    }

    private BetaConstraints attachPattern(BuildContext context, BuildUtils utils, Pattern pattern) throws InvalidPatternException {
        pattern.setOffset(context.getCurrentPatternOffset());
        context.incrementCurrentPatternOffset();
        List predicates = this.attachAlphaNodes(context, utils, pattern);
        BetaConstraints binder = utils.createBetaNodeConstraint(context, predicates);
        return binder;
    }

    public List attachAlphaNodes(BuildContext context, BuildUtils utils, Pattern pattern) throws InvalidPatternException {
        List constraints = pattern.getConstraints();
        context.setObjectSource((ObjectSource)utils.attachNode(context, new ObjectTypeNode(context.getNextId(), pattern.getObjectType(), context.getRuleBase().getRete(), context.getRuleBase().getConfiguration().getAlphaNodeHashingThreshold())));
        ArrayList<Constraint> betaConstraints = new ArrayList<Constraint>();
        this.checkRemoveIdentities(context, pattern, betaConstraints);
        Iterator it = constraints.iterator();
        while (it.hasNext()) {
            Object object = it.next();
            if (object instanceof Declaration) continue;
            Constraint constraint = (Constraint)object;
            Declaration[] declarations = constraint.getRequiredDeclarations();
            boolean isAlphaConstraint = true;
            for (int i = 0; isAlphaConstraint && i < declarations.length; ++i) {
                if (declarations[i].getPattern() == pattern) continue;
                isAlphaConstraint = false;
            }
            if (isAlphaConstraint) {
                context.setObjectSource((ObjectSource)utils.attachNode(context, new AlphaNode(context.getNextId(), (AlphaNodeFieldConstraint)constraint, context.getObjectSource())));
                continue;
            }
            utils.checkUnboundDeclarations(context, constraint.getRequiredDeclarations());
            betaConstraints.add(constraint);
        }
        return betaConstraints;
    }

    private void checkRemoveIdentities(BuildContext context, Pattern pattern, List betaConstraints) {
        if (context.getRuleBase().getConfiguration().isRemoveIdentities() && pattern.getObjectType().getClass() == ClassObjectType.class) {
            List patterns = null;
            Class thisClass = ((ClassObjectType)pattern.getObjectType()).getClassType();
            Iterator it = context.getObjectType().entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                Class previousClass = ((ClassObjectType)entry.getKey()).getClassType();
                if (!thisClass.isAssignableFrom(previousClass)) continue;
                patterns = (List)entry.getValue();
                Iterator patternIter = patterns.iterator();
                while (patternIter.hasNext()) {
                    betaConstraints.add(new InstanceNotEqualsConstraint((Pattern)patternIter.next()));
                }
            }
            patterns = (ArrayList<Pattern>)context.getObjectType().get(pattern.getObjectType());
            if (patterns == null) {
                patterns = new ArrayList<Pattern>();
            }
            patterns.add(pattern);
            context.getObjectType().put(pattern.getObjectType(), patterns);
        }
    }

    public boolean requiresLeftActivation(BuildUtils utils, RuleConditionElement rce) {
        return false;
    }
}

