/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo.builder;

import java.util.ArrayList;
import java.util.List;
import org.drools.InitialFact;
import org.drools.base.ClassFieldExtractor;
import org.drools.base.ClassObjectType;
import org.drools.base.DroolsQuery;
import org.drools.base.FieldFactory;
import org.drools.base.ValueType;
import org.drools.base.evaluators.Operator;
import org.drools.common.BaseNode;
import org.drools.reteoo.QueryTerminalNode;
import org.drools.reteoo.ReteooBuilder;
import org.drools.reteoo.ReteooRuleBase;
import org.drools.reteoo.RuleTerminalNode;
import org.drools.reteoo.TerminalNode;
import org.drools.reteoo.builder.AccumulateBuilder;
import org.drools.reteoo.builder.BuildContext;
import org.drools.reteoo.builder.BuildUtils;
import org.drools.reteoo.builder.CollectBuilder;
import org.drools.reteoo.builder.EvalBuilder;
import org.drools.reteoo.builder.ForallBuilder;
import org.drools.reteoo.builder.FromBuilder;
import org.drools.reteoo.builder.GroupElementBuilder;
import org.drools.reteoo.builder.PatternBuilder;
import org.drools.reteoo.builder.ReteooComponentBuilder;
import org.drools.rule.Accumulate;
import org.drools.rule.Collect;
import org.drools.rule.EvalCondition;
import org.drools.rule.Forall;
import org.drools.rule.From;
import org.drools.rule.GroupElement;
import org.drools.rule.InvalidPatternException;
import org.drools.rule.LiteralConstraint;
import org.drools.rule.Pattern;
import org.drools.rule.Query;
import org.drools.rule.Rule;
import org.drools.spi.FieldValue;

public class ReteooRuleBuilder {
    private BuildUtils utils = new BuildUtils();

    public ReteooRuleBuilder() {
        this.utils.addBuilder(GroupElement.class, new GroupElementBuilder());
        this.utils.addBuilder(Pattern.class, new PatternBuilder());
        this.utils.addBuilder(EvalCondition.class, new EvalBuilder());
        this.utils.addBuilder(From.class, new FromBuilder());
        this.utils.addBuilder(Collect.class, new CollectBuilder());
        this.utils.addBuilder(Accumulate.class, new AccumulateBuilder());
        this.utils.addBuilder(Forall.class, new ForallBuilder());
    }

    public List addRule(Rule rule, ReteooRuleBase rulebase, ReteooBuilder.IdGenerator idGenerator) throws InvalidPatternException {
        ArrayList<TerminalNode> nodes = new ArrayList<TerminalNode>();
        GroupElement[] subrules = rule.getTransformedLhs();
        for (int i = 0; i < subrules.length; ++i) {
            BuildContext context = new BuildContext(rulebase, idGenerator);
            TerminalNode node = this.addSubRule(context, subrules[i], rule);
            nodes.add(node);
        }
        return nodes;
    }

    private TerminalNode addSubRule(BuildContext context, GroupElement subrule, Rule rule) throws InvalidPatternException {
        ReteooComponentBuilder builder;
        if (rule instanceof Query) {
            this.addQueryPattern(context, subrule, (Query)rule);
        }
        if ((builder = this.utils.getBuilderFor(subrule)).requiresLeftActivation(this.utils, subrule)) {
            this.addInitialFactPattern(context, subrule, rule);
        }
        builder.build(context, this.utils, subrule);
        BaseNode terminal = null;
        if (!(rule instanceof Query)) {
            if (rule.getConsequence() == null) {
                throw new InvalidPatternException("Rule '" + rule.getName() + "' has no Consequence");
            }
            terminal = new RuleTerminalNode(context.getNextId(), context.getTupleSource(), rule, subrule);
        } else {
            if (rule.getConsequence() != null) {
                throw new InvalidPatternException("Query '" + rule.getName() + "' should have no Consequence");
            }
            terminal = new QueryTerminalNode(context.getNextId(), context.getTupleSource(), rule, subrule);
        }
        if (context.getWorkingMemories().length == 0) {
            ((BaseNode)terminal).attach();
        } else {
            ((BaseNode)terminal).attach(context.getWorkingMemories());
        }
        return terminal;
    }

    private void addQueryPattern(BuildContext context, GroupElement subrule, Query query) {
        Pattern pattern = new Pattern(0, new ClassObjectType(DroolsQuery.class));
        ClassFieldExtractor extractor = new ClassFieldExtractor(DroolsQuery.class, "name");
        FieldValue field = FieldFactory.getFieldValue(query.getName(), ValueType.STRING_TYPE);
        LiteralConstraint constraint = new LiteralConstraint(extractor, ValueType.STRING_TYPE.getEvaluator(Operator.EQUAL), field);
        pattern.addConstraint(constraint);
        subrule.addChild(0, pattern);
    }

    private void addInitialFactPattern(BuildContext context, GroupElement subrule, Rule rule) {
        Pattern pattern = new Pattern(0, new ClassObjectType(InitialFact.class));
        subrule.addChild(0, pattern);
    }
}

