/*
 * Decompiled with CFR 0.152.
 */
package org.drools.rule;

import java.util.List;
import java.util.Map;
import org.drools.RuntimeDroolsException;
import org.drools.WorkingMemory;
import org.drools.rule.ConditionalElement;
import org.drools.rule.Declaration;
import org.drools.rule.Pattern;
import org.drools.spi.Accumulator;
import org.drools.spi.Tuple;

public class Accumulate
extends ConditionalElement {
    private static final long serialVersionUID = 4608000398919355806L;
    private Accumulator accumulator;
    private Pattern sourcePattern;
    private Pattern resultPattern;
    private Declaration[] requiredDeclarations;
    private Declaration[] innerDeclarations;

    public Accumulate(Pattern sourcePattern, Pattern resultPattern) {
        this(sourcePattern, resultPattern, new Declaration[0], new Declaration[0], null);
    }

    public Accumulate(Pattern sourcePattern, Pattern resultPattern, Declaration[] requiredDeclarations, Declaration[] innerDeclarations) {
        this(sourcePattern, resultPattern, requiredDeclarations, innerDeclarations, null);
    }

    public Accumulate(Pattern sourcePattern, Pattern resultPattern, Declaration[] requiredDeclarations, Declaration[] innerDeclarations, Accumulator accumulator) {
        this.sourcePattern = sourcePattern;
        this.resultPattern = resultPattern;
        this.requiredDeclarations = requiredDeclarations;
        this.innerDeclarations = innerDeclarations;
        this.accumulator = accumulator;
    }

    public Accumulator getAccumulator() {
        return this.accumulator;
    }

    public void setAccumulator(Accumulator accumulator) {
        this.accumulator = accumulator;
    }

    public Object accumulate(Tuple leftTuple, List matchingObjects, WorkingMemory workingMemory) {
        try {
            return this.accumulator.accumulate(leftTuple, matchingObjects, this.requiredDeclarations, this.innerDeclarations, workingMemory);
        }
        catch (Exception e) {
            throw new RuntimeDroolsException(e);
        }
    }

    public Object clone() {
        return new Accumulate(this.sourcePattern, this.resultPattern, this.requiredDeclarations, this.innerDeclarations, this.accumulator);
    }

    public Pattern getResultPattern() {
        return this.resultPattern;
    }

    public Pattern getSourcePattern() {
        return this.sourcePattern;
    }

    public Map getInnerDeclarations() {
        return this.sourcePattern.getInnerDeclarations();
    }

    public Map getOuterDeclarations() {
        return this.resultPattern.getOuterDeclarations();
    }

    public Declaration resolveDeclaration(String identifier) {
        return (Declaration)this.sourcePattern.getInnerDeclarations().get(identifier);
    }
}

