/*
 * Decompiled with CFR 0.152.
 */
package org.drools.rule;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Map;
import org.drools.rule.GroupElement;
import org.drools.rule.GroupElementFactory;
import org.drools.rule.InvalidPatternException;
import org.drools.rule.RuleConditionElement;

class LogicTransformer {
    private final Map orTransformations = new HashMap();
    private static LogicTransformer INSTANCE = null;

    static LogicTransformer getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new LogicTransformer();
        }
        return INSTANCE;
    }

    LogicTransformer() {
        this.initialize();
    }

    private void initialize() {
        this.addTransformationPair(GroupElement.NOT, new NotOrTransformation());
        this.addTransformationPair(GroupElement.EXISTS, new ExistOrTransformation());
        this.addTransformationPair(GroupElement.AND, new AndOrTransformation());
    }

    private void addTransformationPair(GroupElement.Type parent, Transformation method) {
        this.orTransformations.put(parent, method);
    }

    public GroupElement[] transform(GroupElement and) throws InvalidPatternException {
        GroupElement cloned = (GroupElement)and.clone();
        this.processTree(cloned);
        cloned.pack();
        GroupElement[] ands = null;
        if (cloned.isAnd()) {
            ands = new GroupElement[]{cloned};
        } else if (cloned.isOr()) {
            ands = new GroupElement[cloned.getChildren().size()];
            int i = 0;
            Iterator it = cloned.getChildren().iterator();
            while (it.hasNext()) {
                RuleConditionElement branch = (RuleConditionElement)it.next();
                if (branch instanceof GroupElement && ((GroupElement)branch).isAnd()) {
                    ands[i++] = (GroupElement)branch;
                    continue;
                }
                ands[i] = GroupElementFactory.newAndInstance();
                ands[i].addChild(branch);
                ++i;
            }
        } else {
            GroupElement wrapper = GroupElementFactory.newAndInstance();
            wrapper.addChild(cloned);
            ands = new GroupElement[]{wrapper};
        }
        return ands;
    }

    void processTree(GroupElement ce) throws InvalidPatternException {
        boolean hasChildOr = false;
        ce.pack();
        ListIterator it = ce.getChildren().listIterator();
        while (it.hasNext()) {
            Object object = it.next();
            if (!(object instanceof GroupElement)) continue;
            GroupElement child = (GroupElement)object;
            this.processTree(child);
            if (!child.isOr()) continue;
            hasChildOr = true;
        }
        if (hasChildOr) {
            this.applyOrTransformation(ce);
        }
    }

    void applyOrTransformation(GroupElement parent) throws InvalidPatternException {
        Transformation transformation = (Transformation)this.orTransformations.get(parent.getType());
        if (transformation == null) {
            throw new RuntimeException("applyOrTransformation could not find transformation for parent '" + parent.getType() + "' and child 'OR'");
        }
        transformation.transform(parent);
    }

    public class NotOrTransformation
    implements Transformation {
        public void transform(GroupElement parent) throws InvalidPatternException {
            if (!(parent.getChildren().get(0) instanceof GroupElement) && ((GroupElement)parent.getChildren().get(0)).isOr()) {
                throw new RuntimeException("NotOrTransformation expected 'OR' but instead found '" + parent.getChildren().get(0).getClass().getName() + "'");
            }
            GroupElement or = (GroupElement)parent.getChildren().get(0);
            parent.setType(GroupElement.AND);
            parent.getChildren().clear();
            Iterator it = or.getChildren().iterator();
            while (it.hasNext()) {
                GroupElement newNot = GroupElementFactory.newNotInstance();
                newNot.addChild((RuleConditionElement)it.next());
                parent.addChild(newNot);
            }
            parent.pack();
        }
    }

    class ExistOrTransformation
    implements Transformation {
        ExistOrTransformation() {
        }

        public void transform(GroupElement parent) throws InvalidPatternException {
            if (!(parent.getChildren().get(0) instanceof GroupElement) && ((GroupElement)parent.getChildren().get(0)).isExists()) {
                throw new RuntimeException("ExistOrTransformation expected 'OR' but instead found '" + parent.getChildren().get(0).getClass().getName() + "'");
            }
            GroupElement or = (GroupElement)parent.getChildren().get(0);
            parent.setType(GroupElement.OR);
            parent.getChildren().clear();
            Iterator it = or.getChildren().iterator();
            while (it.hasNext()) {
                GroupElement newExists = GroupElementFactory.newExistsInstance();
                newExists.addChild((RuleConditionElement)it.next());
                parent.addChild(newExists);
            }
            parent.pack();
        }
    }

    class AndOrTransformation
    implements Transformation {
        AndOrTransformation() {
        }

        public void transform(GroupElement parent) throws InvalidPatternException {
            ArrayList orsList = new ArrayList();
            Object[] others = new Object[parent.getChildren().size()];
            int permutations = 1;
            int index = 0;
            Iterator it = parent.getChildren().iterator();
            while (it.hasNext()) {
                Object child = it.next();
                if (child instanceof GroupElement && ((GroupElement)child).isOr()) {
                    permutations *= ((GroupElement)child).getChildren().size();
                    orsList.add(child);
                } else {
                    others[index] = child;
                }
                ++index;
            }
            parent.setType(GroupElement.OR);
            parent.getChildren().clear();
            GroupElement[] ors = orsList.toArray(new GroupElement[orsList.size()]);
            int[] indexes = new int[ors.length];
            for (int i = 1; i <= permutations; ++i) {
                int j;
                GroupElement and = GroupElementFactory.newAndInstance();
                int mod = 1;
                for (j = ors.length - 1; j >= 0; --j) {
                    and.getChildren().add(0, ors[j].getChildren().get(indexes[j]));
                    if (i % mod == 0) {
                        indexes[j] = (indexes[j] + 1) % ors[j].getChildren().size();
                    }
                    mod *= ors[j].getChildren().size();
                }
                for (j = 0; j < others.length; ++j) {
                    if (others[j] == null) continue;
                    and.getChildren().add(j, ((RuleConditionElement)others[j]).clone());
                }
                parent.addChild(and);
            }
            parent.pack();
        }
    }

    static interface Transformation {
        public void transform(GroupElement var1) throws InvalidPatternException;
    }
}

